/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class MapNamespaceContext
implements NamespaceContext {
    private Map<String, String> prefixToUri = new HashMap<String, String>();
    private Map<String, String> uriToPrefix = new HashMap<String, String>();

    public MapNamespaceContext() {
    }

    public MapNamespaceContext(String prefix, String uri) {
        this.put(prefix, uri);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.prefixToUri.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.uriToPrefix.get(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return this.prefixToUri.keySet().iterator();
    }

    public boolean containsPrefix(String prefix) {
        return this.prefixToUri.containsKey(prefix);
    }

    public void putAll(MapNamespaceContext otherContext) {
        for (Map.Entry<String, String> entry : otherContext.prefixToUri.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void put(String prefix, String uri) {
        this.prefixToUri.put(prefix, uri);
        this.uriToPrefix.put(uri, prefix);
    }
}

