/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.application.common.services.document.MapNamespaceContext;
import oracle.eclipse.tools.application.common.services.document.XPathVariableResolverImpl;

public class ExpressionBuilder {
    private final String _expression;
    private final MapNamespaceContext _nsContext;
    private final Map<String, String> _varSubs;
    private XPathVariableResolverImpl variableResolver;

    public ExpressionBuilder(String expression, MapNamespaceContext namespaceContext, Map<String, String> varSubs) {
        this._expression = expression;
        this._nsContext = namespaceContext;
        this._varSubs = varSubs;
    }

    public ExpressionBuilder(String expression, MapNamespaceContext namespaceContext) {
        this(expression, namespaceContext, new HashMap<String, String>());
    }

    public MapNamespaceContext getNamespaceContext() {
        return this._nsContext;
    }

    public XPathVariableResolverImpl getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(XPathVariableResolverImpl variableResolver) {
        this.variableResolver = variableResolver;
    }

    public String putSubstitution(String varName, String value) {
        return this._varSubs.put(varName, value);
    }

    public String getExpression() {
        return this._expression;
    }

    public String getResolvedExpression() {
        int nextDollarSign;
        Pattern VAR_SUB_EXPR = Pattern.compile("^(\\w[\\w-]*).*");
        StringBuilder builder = new StringBuilder();
        int curPos = 0;
        while ((nextDollarSign = this._expression.indexOf(36, curPos)) > -1) {
            builder.append(this._expression.substring(curPos, nextDollarSign));
            String startOfVar = this._expression.substring(nextDollarSign + 1);
            Matcher matcher = VAR_SUB_EXPR.matcher(startOfVar);
            if (matcher.matches()) {
                String group = matcher.group(1);
                String value = this._varSubs.get(group);
                if (value == null) {
                    throw new IllegalStateException();
                }
                builder.append(value);
                curPos = nextDollarSign + group.length() + 1;
                continue;
            }
            ++curPos;
        }
        if (curPos < this._expression.length()) {
            builder.append(this._expression.substring(curPos));
        }
        return builder.toString();
    }
}

