/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document;

import java.io.IOException;
import oracle.eclipse.tools.application.common.services.document.EditContext;
import oracle.eclipse.tools.application.common.services.document.XMerge;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.model.emfbinding.dom.StructuredModelXMLDocumentProvider;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Document;

public class EditManager {
    public static final int EDIT_ABORTED = -2147467260;

    public static EditContext startEdit(StructuredModelXMLDocumentProvider docProvider, IFile iFile, Object uiContext, boolean commit) {
        IDOMDocument iDOMDocument;
        block5: {
            assert (iFile != null) : "Must provide an IDocument";
            try {
                Document xmlDocument = docProvider.getXMLDocument(iFile);
                if (xmlDocument instanceof IDOMDocument) {
                    iDOMDocument = (IDOMDocument)xmlDocument;
                    break block5;
                }
                return null;
            }
            finally {
                docProvider.release();
            }
        }
        XMerge merge = XMerge.create(iDOMDocument);
        return new EditContext(iFile, iDOMDocument, merge, uiContext, commit);
    }

    public static IStatus endEdit(EditContext ctx) throws BadLocationException, CoreException, IOException {
        IStatus iStatus;
        ISchedulingRule rule;
        boolean fileConnected;
        IPath path;
        block22: {
            IDocument doc;
            DocumentRewriteSession session;
            IFile resource;
            ITextFileBuffer buffer;
            block20: {
                IStatus iStatus2;
                block21: {
                    IStatus status;
                    block18: {
                        IStatus iStatus3;
                        block19: {
                            assert (ctx != null) : "Must provide a EditContext";
                            buffer = null;
                            resource = ctx.getFile();
                            path = resource.getFullPath();
                            session = null;
                            fileConnected = false;
                            doc = null;
                            rule = null;
                            try {
                                assert (resource != null) : "Expected a non-null resource for an IDocument";
                                if (ctx.getDocumentRewriter().isDefined()) break block18;
                                iStatus3 = Status.OK_STATUS;
                                if (session == null) break block19;
                            }
                            catch (Throwable throwable) {
                                if (session != null) {
                                    ((IDocumentExtension4)doc).stopRewriteSession(session);
                                }
                                if (fileConnected) {
                                    FileBuffers.getTextFileBufferManager().disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                                }
                                if (rule != null) {
                                    Job.getJobManager().endRule(rule);
                                }
                                throw throwable;
                            }
                            ((IDocumentExtension4)doc).stopRewriteSession(session);
                        }
                        if (fileConnected) {
                            FileBuffers.getTextFileBufferManager().disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                        }
                        if (rule != null) {
                            Job.getJobManager().endRule(rule);
                        }
                        return iStatus3;
                    }
                    IWorkspace workspace = resource.getWorkspace();
                    if (workspace == null || (status = workspace.validateEdit(new IFile[]{resource}, ctx.getUIContext())).isOK()) break block20;
                    LoggingService.logError((String)"oracle.eclipse.tools.application.common.services", (String)status.getMessage());
                    iStatus2 = status = new Status(8, "oracle.eclipse.tools.application.common.services", -2147467260, NLS.bind((String)"The file ''{0}'' is read-only and cannot be modified.\nThe operation has been aborted.", (Object)resource.getFullPath()), null);
                    if (session == null) break block21;
                    ((IDocumentExtension4)doc).stopRewriteSession(session);
                }
                if (fileConnected) {
                    FileBuffers.getTextFileBufferManager().disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                }
                if (rule != null) {
                    Job.getJobManager().endRule(rule);
                }
                return iStatus2;
            }
            FileBuffers.getTextFileBufferManager().connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            fileConnected = true;
            buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(path, LocationKind.IFILE);
            rule = buffer.computeCommitRule();
            Job.getJobManager().beginRule(rule, (IProgressMonitor)new NullProgressMonitor());
            doc = buffer.getDocument();
            if (doc instanceof IDocumentExtension4 && ((IDocumentExtension4)doc).getActiveRewriteSession() == null) {
                session = ((IDocumentExtension4)doc).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
            }
            ctx.getDocumentRewriter().textEdit().apply(doc);
            if (ctx.shouldCommit()) {
                buffer.commit(null, false);
            }
            if (ctx.shouldFormat()) {
                FormatProcessorXML formatProcessor = new FormatProcessorXML();
                formatProcessor.formatFile(resource, ctx.getDocumentRewriter().getOffset(), ctx.getDocumentRewriter().getLength());
            }
            iStatus = Status.OK_STATUS;
            if (session == null) break block22;
            ((IDocumentExtension4)doc).stopRewriteSession(session);
        }
        if (fileConnected) {
            FileBuffers.getTextFileBufferManager().disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        }
        if (rule != null) {
            Job.getJobManager().endRule(rule);
        }
        return iStatus;
    }

    public static enum EditType {
        MERGE,
        OTHER;

    }
}

