/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document;

import oracle.eclipse.tools.application.common.services.documentservices.IScriptHandler;
import oracle.eclipse.tools.application.common.services.documentservices.TagAttributeDataBinding;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.StringToMethodReferenceConverter;
import oracle.eclipse.tools.application.common.services.variables.StringToValueReferenceConverter;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.common.services.document.AbstractDocumentService;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.techextservices.IDocumentBinder;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;

public abstract class AbstractSimpleDocumentBindingService
extends AbstractDocumentService
implements IDocumentBinder {
    protected static final int DEFAULT_SORT_PRIORITY = 10;

    public AbstractSimpleDocumentBindingService(IDocument doc) {
        super(doc);
    }

    public boolean canBind(IObservableValue targetTagAttribute, IObservableValue modelReference) {
        return modelReference.getValueType() == ValueReference.class ? this.canBindToValRef((ValueReference)modelReference.getValue()) : modelReference.getValueType() == MethodReference.class && this.canBindToMethodRef((MethodReference)modelReference.getValue());
    }

    protected abstract boolean canBindToValRef(ValueReference var1);

    protected abstract boolean canBindToMethodRef(MethodReference var1);

    public Binding createBinding(DataBindingContext dbc, IObservableValue target, IObservableValue model) {
        if (this.canBind(target, model)) {
            return this.internalCreateBinding(dbc, target, model);
        }
        return null;
    }

    private Binding internalCreateBinding(DataBindingContext dbc, IObservableValue target, IObservableValue model) {
        UpdateValueStrategy targetToModelUpdateStrategy = this.getTargetToModelUpdateStrategy(target, model);
        UpdateValueStrategy modelToTargetUpdateStrategy = this.getModelToTargetUpdateStrategy(model, target);
        TagAttributeDataBinding binder = new TagAttributeDataBinding(dbc, target, model, targetToModelUpdateStrategy, modelToTargetUpdateStrategy);
        return binder.createBinding();
    }

    protected UpdateValueStrategy getTargetToModelUpdateStrategy(IObservableValue targetTagAttribute, IObservableValue modelReference) {
        EMFUpdateValueStrategy modelToTargetStrategy = new EMFUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST);
        DocumentVariableQuery query = new DocumentVariableQuery(this.getDocument(), -1);
        if (modelReference.getValueType() == ValueReference.class) {
            modelToTargetStrategy.setConverter((IConverter)new StringToValueReferenceConverter(query));
        } else if (modelReference.getValueType() == MethodReference.class) {
            modelToTargetStrategy.setConverter((IConverter)new StringToMethodReferenceConverter(query));
        }
        return modelToTargetStrategy;
    }

    protected UpdateValueStrategy getModelToTargetUpdateStrategy(IObservableValue modelReference, IObservableValue targetTagAttribute) {
        UpdateValueStrategy strategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST);
        if (modelReference.getValueType() == ValueReference.class) {
            strategy.setConverter((IConverter)new ValueReferenceToStringConverter(this));
            strategy.setAfterGetValidator((IValidator)new ValueReferenceValidator(this));
        } else if (modelReference.getValueType() == MethodReference.class) {
            strategy.setConverter((IConverter)new MethodReferenceToStringConverter(this));
            strategy.setAfterGetValidator((IValidator)new MethodReferenceValidator(this));
        }
        return strategy;
    }

    public int getPriority() {
        return 10;
    }

    protected abstract IScriptHandler getScriptHandler();

    private static final class MethodReferenceToStringConverter
    extends Converter {
        private AbstractSimpleDocumentBindingService _bindingService;

        public MethodReferenceToStringConverter(AbstractSimpleDocumentBindingService bindingService) {
            super(MethodReference.class, String.class);
            this._bindingService = bindingService;
        }

        public Object convert(Object fromObject) {
            if (fromObject instanceof MethodReference) {
                return this._bindingService.getScriptHandler().computeExpression((MethodReference)fromObject);
            }
            return "";
        }
    }

    private static final class MethodReferenceValidator
    implements IValidator {
        private AbstractSimpleDocumentBindingService _bindingService;

        public MethodReferenceValidator(AbstractSimpleDocumentBindingService bindingService) {
            this._bindingService = bindingService;
        }

        public IStatus validate(Object value) {
            if (value instanceof MethodReference && this._bindingService.canBindToMethodRef((MethodReference)value)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }

    private static final class ValueReferenceToStringConverter
    extends Converter {
        private AbstractSimpleDocumentBindingService _bindingService;

        public ValueReferenceToStringConverter(AbstractSimpleDocumentBindingService bindingService) {
            super(ValueReference.class, String.class);
            this._bindingService = bindingService;
        }

        public Object convert(Object fromObject) {
            if (fromObject instanceof ValueReference) {
                return this._bindingService.getScriptHandler().computeExpression((ValueReference)fromObject);
            }
            return "";
        }
    }

    private static final class ValueReferenceValidator
    implements IValidator {
        private AbstractSimpleDocumentBindingService _bindingService;

        public ValueReferenceValidator(AbstractSimpleDocumentBindingService bindingService) {
            this._bindingService = bindingService;
        }

        public IStatus validate(Object value) {
            if (value instanceof ValueReference && this._bindingService.canBindToValRef((ValueReference)value)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }
}

