/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.discovery.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.discovery.IStructuredModelDiscoveryVisitor;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.Preferences;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class StructuredModelDiscoveryVisitorBuilder {
    private String modelVisitorClassName = null;
    private String modelVisitorFactoryClassName = null;
    private Expression expression = null;
    private List<String> dependentTechnologies = null;
    private final String pluginID;

    public StructuredModelDiscoveryVisitorBuilder(String pluginID) {
        this.pluginID = pluginID;
    }

    public IStructuredModelDiscoveryVisitor build() {
        if (this.modelVisitorClassName == null && this.modelVisitorFactoryClassName == null) {
            throw new IllegalStateException("Exactly one of model-visitor-class or model-visitor-factory is allowed");
        }
        IStructuredModelDiscoveryVisitor smv = null;
        if (this.modelVisitorClassName != null) {
            smv = (IStructuredModelDiscoveryVisitor)PluginUtil.instantiate((String)this.pluginID, (String)this.modelVisitorClassName, IStructuredModelDiscoveryVisitor.class);
            if (smv == null) {
                LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)("Unable to instantiate " + this.modelVisitorClassName + " for plugin " + this.pluginID));
            }
        } else {
            Class modelVisitorFactoryClass = PluginUtil.loadClass((String)this.pluginID, (String)this.modelVisitorFactoryClassName);
            if (modelVisitorFactoryClass != null) {
                try {
                    Method getModelVisitorMethod = modelVisitorFactoryClass.getMethod("getModelVisitor", null);
                    Object modelVisitor = getModelVisitorMethod.invoke(null, null);
                    if (modelVisitor instanceof IStructuredModelDiscoveryVisitor) {
                        smv = (IStructuredModelDiscoveryVisitor)modelVisitor;
                    } else {
                        LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)(String.valueOf(this.modelVisitorFactoryClassName) + "#getModelVisitor() did not return an instance of IStructuredModelDiscoveryVisitor"));
                    }
                }
                catch (NoSuchMethodException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
            }
        }
        return smv;
    }

    public StructuredModelDiscoveryVisitorBuilder setModelVisitorClass(String modelVisitorClassName) {
        if (this.modelVisitorFactoryClassName != null) {
            throw new IllegalStateException("Exactly one of modelVisitor-class or modelVisitor-factory is allowed");
        }
        this.modelVisitorClassName = modelVisitorClassName;
        return this;
    }

    public StructuredModelDiscoveryVisitorBuilder setModelVisitorFactoryClass(String modelVisitorFactoryClassName) {
        if (this.modelVisitorClassName != null) {
            throw new IllegalStateException("Exactly one of model-visitor-class or model-visitor-factory is allowed");
        }
        this.modelVisitorFactoryClassName = modelVisitorFactoryClassName;
        return this;
    }

    public StructuredModelDiscoveryVisitorBuilder setEnablementExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public StructuredModelDiscoveryVisitorBuilder setDependentTechnologies(String technologies) {
        this.dependentTechnologies = StringUtil.split((String)technologies, (char)',');
        return this;
    }

    public boolean isEnabledFor(IProject project) throws CoreException {
        boolean isEnabled = true;
        if (this.expression != null) {
            EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
            evalContext.setAllowPluginActivation(true);
            boolean bl = isEnabled = EvaluationResult.TRUE == this.expression.evaluate((IEvaluationContext)evalContext);
        }
        if (!isEnabled) {
            return false;
        }
        Project prj = (Project)project.getAdapter(Project.class);
        if (prj == null) {
            return false;
        }
        Set activeExtensions = prj.getTechnologyExtensions();
        HashMap<String, HashSet<String>> techMap = new HashMap<String, HashSet<String>>(activeExtensions.size(), 1.0f);
        for (ITechnologyExtension ite : activeExtensions) {
            HashSet<String> versionSet = (HashSet<String>)techMap.get(ite.getId());
            if (versionSet == null) {
                versionSet = new HashSet<String>();
                techMap.put(ite.getId(), versionSet);
            }
            versionSet.add(ite.getVersion());
        }
        if (this.dependentTechnologies != null) {
            Preferences prefs = Activator.getDefault().getPreferences().getProjectPreferences(project);
            for (String technology : this.dependentTechnologies) {
                int colonIndex = technology.indexOf(58);
                String tech = null;
                String version = null;
                if (colonIndex != -1) {
                    tech = technology.substring(0, colonIndex);
                    version = technology.substring(colonIndex + 1);
                } else {
                    tech = technology;
                }
                Set activeVersions = (Set)techMap.get(tech);
                if (activeVersions == null) {
                    isEnabled = false;
                    break;
                }
                if (version == null) {
                    boolean hasAnyEnabledVersion = false;
                    for (String activeVersion : activeVersions) {
                        if (!prefs.isTechnologyExtensionActiveForDiscovery(tech, activeVersion)) continue;
                        hasAnyEnabledVersion = true;
                        break;
                    }
                    isEnabled &= hasAnyEnabledVersion;
                } else {
                    isEnabled = activeVersions.contains(version) ? (isEnabled &= prefs.isTechnologyExtensionActiveForDiscovery(tech, version)) : false;
                }
                if (!isEnabled) break;
            }
        }
        return isEnabled;
    }

    public String toString() {
        return this.modelVisitorClassName != null ? this.modelVisitorClassName : this.modelVisitorFactoryClassName;
    }
}

