/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.discovery.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import oracle.eclipse.tools.application.common.services.TraceOptions;
import oracle.eclipse.tools.application.common.services.discovery.IStructuredModelDiscoveryVisitor;
import oracle.eclipse.tools.application.common.services.discovery.internal.StructuredDocumentDiscoveryContextImpl;
import oracle.eclipse.tools.application.common.services.discovery.internal.StructuredDocumentResourceDiscoveryContext;
import oracle.eclipse.tools.application.common.services.discovery.internal.StructuredModelDiscoveryVisitorBuilder;
import oracle.eclipse.tools.application.common.services.discovery.internal.StructuredModelVisitorExtensionReader;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class StructuredModelDiscoveryParticipant
implements IDiscoveryParticipant {
    private final Set<StructuredModelDiscoveryVisitorBuilder> builders;
    private Set<IStructuredModelDiscoveryVisitor> visitors;
    private StructuredDocumentDiscoveryContextImpl context = null;

    private StructuredModelDiscoveryParticipant(Set<StructuredModelDiscoveryVisitorBuilder> builders) {
        this.builders = builders;
    }

    public synchronized Set<IResource> getDependentResources(IProject project, Set<IResource> changedResources, IProgressMonitor monitor) {
        if (this.visitors == null) {
            this.initVisitors(project);
        }
        LinkedHashSet<IResource> dependentResources = new LinkedHashSet<IResource>();
        for (IStructuredModelDiscoveryVisitor visitor : this.visitors) {
            dependentResources.addAll(visitor.getDependentResources(changedResources, monitor));
        }
        return dependentResources;
    }

    private void initVisitors(IProject project) {
        this.visitors = new LinkedHashSet<IStructuredModelDiscoveryVisitor>(this.builders.size());
        for (StructuredModelDiscoveryVisitorBuilder builder : this.builders) {
            try {
                IStructuredModelDiscoveryVisitor visitor;
                if (!builder.isEnabledFor(project) || (visitor = builder.build()) == null) continue;
                this.visitors.add(visitor);
            }
            catch (CoreException e) {
                LoggingService.logError((String)"oracle.eclipse.tools.application.common.services", (String)("Unable to determine enablement for visitor discovery may be limited. " + builder.toString()));
                LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (CoreException)e);
            }
        }
    }

    public synchronized void startDiscovery(IDiscoveryContext aContext, IProgressMonitor monitor) {
        this.context = new StructuredDocumentDiscoveryContextImpl(aContext);
        if (this.visitors == null) {
            this.initVisitors(this.context.getProject());
        }
        for (IStructuredModelDiscoveryVisitor visitor : this.visitors) {
            visitor.startDiscovery(this.context, monitor);
        }
    }

    public void discover(IResourceDiscoveryContext resourceContext, IProgressMonitor monitor) {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)this.visitors.size());
        if (this.context == null) {
            throw new IllegalStateException("Must call startDiscovery() before discover().");
        }
        StructuredDocumentResourceDiscoveryContext contextWrapper = new StructuredDocumentResourceDiscoveryContext(resourceContext);
        IResource resource = contextWrapper.getResource();
        if (resource != null && resource.isAccessible() && resource.getType() == 1) {
            LinkedHashSet<IStructuredModelDiscoveryVisitor> applicableVisitors = new LinkedHashSet<IStructuredModelDiscoveryVisitor>(this.visitors.size());
            for (IStructuredModelDiscoveryVisitor visitor : this.visitors) {
                if (!visitor.match(contextWrapper)) continue;
                applicableVisitors.add(visitor);
            }
            if (!applicableVisitors.isEmpty()) {
                IVisitableDOMModel model = null;
                try {
                    long timestamp = 0L;
                    if (TraceOptions.APPXRAY_PERF) {
                        timestamp = System.nanoTime();
                    }
                    model = contextWrapper.getVisitableModel();
                    if (TraceOptions.APPXRAY_PERF && model != null) {
                        TraceOptions.log("StructuredModelDiscoveryParticipant get structured model (" + resource.getName() + ") time ns, " + (System.nanoTime() - timestamp));
                        timestamp = System.nanoTime();
                    }
                    if (model != null) {
                        for (IStructuredModelDiscoveryVisitor visitor : applicableVisitors) {
                            visitor.beginResource(contextWrapper, monitor);
                        }
                        model.accept((IStructuredXMLModelVisitor)new Visitor(applicableVisitors));
                        for (IStructuredModelDiscoveryVisitor visitor : applicableVisitors) {
                            visitor.endResource(contextWrapper, monitor);
                        }
                        if (TraceOptions.APPXRAY_PERF) {
                            TraceOptions.log("StructuredModelDiscoveryParticipant process the model (" + resource.getName() + ") time ns, " + (System.nanoTime() - timestamp));
                        }
                    }
                }
                finally {
                    if (model != null) {
                        model.dispose();
                    }
                    ProgressMonitorUtil.done((IProgressMonitor)monitor);
                }
            }
        }
    }

    public void discoverFromExistingModel(IResourceDiscoveryContext resourceContext, IVisitableDOMModel model, IProgressMonitor monitor) {
        if (this.context == null) {
            throw new IllegalStateException("Must call startDiscovery() before discoverFromExistingModel().");
        }
        StructuredDocumentResourceDiscoveryContext contextWrapper = new StructuredDocumentResourceDiscoveryContext(resourceContext, model);
        IResource resource = contextWrapper.getResource();
        if (resource != null && resource.isAccessible() && resource.getType() == 1) {
            LinkedHashSet<IStructuredModelDiscoveryVisitor> applicableVisitors = new LinkedHashSet<IStructuredModelDiscoveryVisitor>(this.visitors.size());
            for (IStructuredModelDiscoveryVisitor visitor : this.visitors) {
                if (!visitor.match(contextWrapper)) continue;
                applicableVisitors.add(visitor);
            }
            if (!applicableVisitors.isEmpty() && model != null) {
                for (IStructuredModelDiscoveryVisitor visitor : applicableVisitors) {
                    visitor.beginResource(contextWrapper, monitor);
                }
                model.accept((IStructuredXMLModelVisitor)new Visitor(applicableVisitors));
                for (IStructuredModelDiscoveryVisitor visitor : applicableVisitors) {
                    visitor.endResource(contextWrapper, monitor);
                }
            }
        }
    }

    public IStatus stopDiscovery(IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus("oracle.eclipse.tools.application.common.services", 0, "", null);
        for (IStructuredModelDiscoveryVisitor visitor : this.visitors) {
            IStatus partStatus = visitor.stopDiscovery(monitor);
            if (partStatus == null) continue;
            status.merge(partStatus);
        }
        return status;
    }

    /* synthetic */ StructuredModelDiscoveryParticipant(Set set, StructuredModelDiscoveryParticipant structuredModelDiscoveryParticipant) {
        this(set);
    }

    public static class FACTORY {
        public static IDiscoveryParticipant getParticipant() {
            return new StructuredModelDiscoveryParticipant(StructuredModelVisitorExtensionReader.getParticipantBuilders(), null);
        }
    }

    private static class Visitor
    implements IStructuredXMLModelVisitor {
        private final Set<IStructuredModelDiscoveryVisitor> visitors;
        private Stack<StackNode> stack = new Stack();

        public Visitor(Set<IStructuredModelDiscoveryVisitor> visitors) {
            this.visitors = new LinkedHashSet<IStructuredModelDiscoveryVisitor>(visitors);
        }

        public boolean visit(IDOMNode node) {
            return this.visit(node, this.getParentVisitors(node));
        }

        public boolean visit(IDOMAttr attribute) {
            return this.visit((IDOMNode)attribute, this.getParentVisitors(attribute));
        }

        public boolean visit(IDOMElement element) {
            return this.visit((IDOMNode)element, this.getParentVisitors((IDOMNode)element));
        }

        public boolean visit(IDOMDocument document) {
            boolean result = false;
            Iterator<IStructuredModelDiscoveryVisitor> visitorIterator = this.visitors.iterator();
            while (visitorIterator.hasNext()) {
                IStructuredModelDiscoveryVisitor visitor = visitorIterator.next();
                if (!visitor.visit(document)) {
                    visitorIterator.remove();
                    continue;
                }
                result = true;
            }
            return result;
        }

        private boolean visit(IDOMNode node, Set<? extends IStructuredXMLModelVisitor> parentVisitors) {
            LinkedHashSet<IStructuredXMLModelVisitor> childVisitors = new LinkedHashSet();
            if (node instanceof IDOMElement) {
                IDOMElement iDOMElement = (IDOMElement)node;
                for (IStructuredXMLModelVisitor iStructuredXMLModelVisitor : parentVisitors) {
                    if (!iStructuredXMLModelVisitor.visit(iDOMElement)) continue;
                    childVisitors.add(iStructuredXMLModelVisitor);
                }
            } else if (node instanceof IDOMAttr) {
                IDOMAttr iDOMAttr = (IDOMAttr)node;
                for (IStructuredXMLModelVisitor iStructuredXMLModelVisitor : parentVisitors) {
                    if (!iStructuredXMLModelVisitor.visit(iDOMAttr)) continue;
                    childVisitors.add(iStructuredXMLModelVisitor);
                }
            } else {
                for (IStructuredXMLModelVisitor iStructuredXMLModelVisitor : parentVisitors) {
                    if (!iStructuredXMLModelVisitor.visit(node)) continue;
                    childVisitors.add(iStructuredXMLModelVisitor);
                }
            }
            if (childVisitors.isEmpty()) {
                childVisitors = Collections.emptySet();
            }
            this.stack.push(new StackNode(node, childVisitors));
            return !childVisitors.isEmpty();
        }

        private Set<? extends IStructuredXMLModelVisitor> getParentVisitors(IDOMNode node) {
            IDOMNode parentNode = (IDOMNode)node.getParentNode();
            return parentNode != null ? this.getVisitors(parentNode) : Collections.EMPTY_SET;
        }

        private Set<? extends IStructuredXMLModelVisitor> getParentVisitors(IDOMAttr attr) {
            IDOMNode parentNode = (IDOMNode)attr.getOwnerElement();
            return this.getVisitors(parentNode);
        }

        private Set<? extends IStructuredXMLModelVisitor> getVisitors(IDOMNode node) {
            while (!this.stack.isEmpty() && !node.equals(this.stack.peek().getNode())) {
                this.stack.pop();
            }
            if (this.stack.isEmpty()) {
                return this.visitors;
            }
            return this.stack.peek().getVisitors();
        }

        private static class StackNode {
            private final IDOMNode node;
            private final Set<IStructuredXMLModelVisitor> visitors;

            public StackNode(IDOMNode node, Set<IStructuredXMLModelVisitor> visitors) {
                this.node = node;
                this.visitors = visitors;
            }

            public IDOMNode getNode() {
                return this.node;
            }

            public Set<IStructuredXMLModelVisitor> getVisitors() {
                return this.visitors;
            }
        }
    }
}

