/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.discovery.internal;

import java.io.IOException;
import oracle.eclipse.tools.application.common.services.discovery.IStructuredDocumentResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;

public class StructuredDocumentResourceDiscoveryContext
implements IStructuredDocumentResourceDiscoveryContext {
    private final IResourceDiscoveryContext context;
    private IVisitableDOMModel model = null;
    private final boolean disposeOfModel;

    public StructuredDocumentResourceDiscoveryContext(IResourceDiscoveryContext context) {
        this.context = context;
        this.disposeOfModel = true;
    }

    StructuredDocumentResourceDiscoveryContext(IResourceDiscoveryContext context, IVisitableDOMModel model) {
        this.context = context;
        this.model = model;
        this.disposeOfModel = false;
    }

    @Override
    public synchronized IVisitableDOMModel getVisitableModel() {
        IResource resource;
        if (this.model == null && (resource = this.context.getResource()) != null && resource.getType() == 1) {
            try {
                this.model = StructuredModelFactory.getVisitableModelForRead((IFile)((IFile)resource));
            }
            catch (CoreException ce) {
                LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (CoreException)ce);
            }
            catch (IOException ioe) {
                LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)ioe);
            }
        }
        return this.model;
    }

    public IResource getResource() {
        return this.context.getResource();
    }

    public Object getProperty(String key) {
        return this.context.getProperty(key);
    }

    public void setProperty(String key, Object value) {
        this.context.setProperty(key, value);
    }

    public boolean isWorkingCopy() {
        return this.context.isWorkingCopy();
    }

    public Object getAdapter(Class adapter) {
        return this.context.getAdapter(adapter);
    }

    @Override
    public IDocument getDocument() {
        return this.getVisitableModel().getModel().getStructuredDocument();
    }

    public synchronized void dispose() {
        if (this.disposeOfModel && this.model != null) {
            this.model.dispose();
            this.model = null;
        }
    }

    public String getContentTypeId() {
        return this.context.getContentTypeId();
    }
}

