/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.application.common.services.tagsupport.ITypedParameterSymbol;
import oracle.eclipse.tools.application.common.services.tagsupport.ITypedSymbol;
import oracle.eclipse.tools.application.common.services.tagsupport.TypedComponentSymbolDelegate;
import oracle.eclipse.tools.application.common.services.variables.CachingDocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.IFileVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.IVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.NestedVariableWithLocation;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceFactory;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.StringUtil;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContextFactory;
import oracle.eclipse.tools.xml.model.metadata.TagMetadata;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.context.IDocumentContext;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.source.IAdditionalContextSymbolInfo;

public abstract class AbstractTagDiscoveryParticipant {
    protected ResourceData resourceData = null;
    protected IDatatypeProvider dataTypeProvider = null;
    private ICollectionFilter filter = null;
    protected static final Pattern VAR_PATTERN = Pattern.compile("<\\s*oepe:var\\s+(name|type)\\s*=\\s*\"([^\"]+)\"\\s+(name|type)\\s*=\\s*\"([^\"]+)\"\\s*/>");
    private Map<IFileVariablesCache, Set<ValueReferencePlaceHolder>> delayedReferences = new HashMap<IFileVariablesCache, Set<ValueReferencePlaceHolder>>();
    private Project prj;

    public AbstractTagDiscoveryParticipant() {
        this.filter = this.createCollectionFilter();
    }

    protected abstract ICollectionFilter createCollectionFilter();

    public void beginResource(IResourceDiscoveryContext ctx, IProgressMonitor monitor) {
        this.resourceData = this.createResourceData(ctx);
    }

    protected abstract ResourceData createResourceData(IResourceDiscoveryContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endResource(IResourceDiscoveryContext resourceCtx, IProgressMonitor monitor) {
        Map<IFileVariablesCache, Set<ValueReferencePlaceHolder>> map = this.delayedReferences;
        synchronized (map) {
            if (!this.resourceData.getReferenceHolders().isEmpty()) {
                this.delayedReferences.put(this.resourceData.getCache(), this.resourceData.getReferenceHolders());
            }
        }
        this.resourceData = null;
    }

    public Set<IResource> getDependentResources(Set<IResource> changedResources, IProgressMonitor monitor) {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDiscovery(IDiscoveryContext context, IProgressMonitor monitor) {
        IProject project = context.getProject();
        this.prj = (Project)project.getAdapter(Project.class);
        if (this.prj == null) {
            throw new IllegalArgumentException("Unable to retrieve project adapter");
        }
        this.dataTypeProvider = (IDatatypeProvider)this.prj.getAppService(IDatatypeProvider.class);
        Map<IFileVariablesCache, Set<ValueReferencePlaceHolder>> map = this.delayedReferences;
        synchronized (map) {
            this.delayedReferences.clear();
        }
    }

    protected Project getOepeProject() {
        return this.prj;
    }

    protected boolean isUnifiedELJSFActive(Project oepeProject) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus stopDiscovery(IProgressMonitor monitor) {
        ValueReferenceFactory vrFactory = new ValueReferenceFactory();
        Map<IFileVariablesCache, Set<ValueReferencePlaceHolder>> map = this.delayedReferences;
        synchronized (map) {
            HashMap<IDocument, DocumentVariableQuery> queries = new HashMap<IDocument, DocumentVariableQuery>();
            for (Map.Entry<IFileVariablesCache, Set<ValueReferencePlaceHolder>> entry : this.delayedReferences.entrySet()) {
                for (ValueReferencePlaceHolder refHolder : entry.getValue()) {
                    List<ValueReference> refs;
                    DocumentVariableQuery query = (DocumentVariableQuery)queries.get(refHolder.getDocument());
                    if (query == null) {
                        query = new CachingDocumentVariableQuery(refHolder.getDocument(), -1);
                        queries.put(refHolder.getDocument(), query);
                    }
                    if ((refs = this.discoverVarReferenceFromHolder(vrFactory, refHolder, query)) == null) continue;
                    for (ValueReference ref : refs) {
                        entry.getKey().add(ref);
                    }
                }
            }
        }
        this.dataTypeProvider = null;
        return Status.OK_STATUS;
    }

    public boolean match(IResourceDiscoveryContext context) {
        return this.filter.match((IResourceContext)context);
    }

    protected Variable.SCOPE getScope(SymbolContribAggregator aggregator) {
        String scopeAttr = aggregator.getScopeAttr();
        String scopeAttributeValue = null;
        if (scopeAttr != null && scopeAttr.length() > 0) {
            scopeAttributeValue = aggregator.getAttributeValue(scopeAttr);
        }
        Variable.SCOPE scope = null;
        scope = this.getScopeFromAttributeValue(scopeAttributeValue);
        if (scope != null) {
            return scope;
        }
        scope = this.getScopeFromTrait(aggregator);
        if (scope != null) {
            return scope;
        }
        return Variable.SCOPE.PAGE_SCOPE;
    }

    protected final Variable.SCOPE getScopeFromAttributeValue(String scopeAttributeValue) {
        if (scopeAttributeValue != null && scopeAttributeValue.length() > 0) {
            Variable.SCOPE scope = Variable.SCOPE.fromString(scopeAttributeValue);
            switch (scope) {
                case AT_BEGIN_SCOPE: 
                case AT_END_SCOPE: 
                case NESTED_SCOPE: {
                    break;
                }
                default: {
                    return scope;
                }
            }
        }
        return null;
    }

    protected final Variable.SCOPE getScopeFromTrait(SymbolContribAggregator aggregator) {
        String scopeTraitValue = aggregator.getScope();
        if (scopeTraitValue != null && scopeTraitValue.length() > 0) {
            return Variable.SCOPE.fromString(scopeTraitValue);
        }
        return null;
    }

    protected ISymbol getTypedSymbol(ISymbol symbol, SymbolContribAggregator aggregator) {
        if (symbol instanceof ITypedSymbol) {
            return symbol;
        }
        if (symbol instanceof IComponentSymbol) {
            ITypedSymbol typedSymbol;
            ISymbol hintedSymbol;
            if (aggregator.acceptsTypeHint() && (hintedSymbol = aggregator.createFromHints(symbol, this.dataTypeProvider, this.resourceData.getImports())) != null) {
                return hintedSymbol;
            }
            String[] typeAttrNames = aggregator.getTypeAttrs();
            if (typeAttrNames != null && typeAttrNames.length > 0) {
                String[] stringArray = typeAttrNames;
                int n = typeAttrNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String typeAttrName = stringArray[n2];
                    String typeAttributeValue = aggregator.getAttributeValue(typeAttrName);
                    if (typeAttributeValue != null && typeAttributeValue.length() > 0) {
                        TypedComponentSymbolDelegate typedSymbol2 = new TypedComponentSymbolDelegate((IComponentSymbol)symbol);
                        typedSymbol2.setTypeName(typeAttributeValue);
                        typedSymbol2.setDataTypeProvider(this.dataTypeProvider);
                        typedSymbol2.setImportedTypeNames(this.resourceData.getImports());
                        return typedSymbol2;
                    }
                    ++n2;
                }
            }
            if ((typedSymbol = this.maybeConvertToTypedSymbol((IComponentSymbol)symbol)) != null) {
                return typedSymbol;
            }
            String staticType = aggregator.getStaticType();
            if (staticType != null && staticType.length() > 0) {
                TypedComponentSymbolDelegate typedSymbolDelegate = new TypedComponentSymbolDelegate((IComponentSymbol)symbol);
                typedSymbolDelegate.setTypeName(staticType);
                typedSymbolDelegate.setDataTypeProvider(this.dataTypeProvider);
                typedSymbolDelegate.setImportedTypeNames(this.resourceData.getImports());
                return typedSymbolDelegate;
            }
        }
        return symbol;
    }

    private ITypedSymbol maybeConvertToTypedSymbol(IComponentSymbol symbol) {
        String fullyQualifiedName;
        ITypeDescriptor typeDescriptor = symbol.getTypeDescriptor();
        if (typeDescriptor == null) {
            return null;
        }
        String typeSignature = typeDescriptor.getTypeSignature();
        if (typeSignature == null) {
            typeSignature = typeDescriptor.getTypeSignatureDelegate();
        }
        if (typeSignature != null && (fullyQualifiedName = TypeUtil.getFullyQualifiedName((String)typeSignature)) != null) {
            TypedComponentSymbolDelegate typedSymbol = new TypedComponentSymbolDelegate(symbol);
            typedSymbol.setTypeName(fullyQualifiedName);
            typedSymbol.setDataTypeProvider(this.dataTypeProvider);
            typedSymbol.setImportedTypeNames(this.resourceData.getImports());
            return typedSymbol;
        }
        return null;
    }

    private List<ValueReference> discoverVarReferenceFromHolder(ValueReferenceFactory vrFactory, ValueReferencePlaceHolder refHolder, DocumentVariableQuery query) {
        Range range = refHolder.getRange();
        query.setOffset(range == null ? -1 : (int)range.getOffset());
        String elExpression = refHolder.getELExpression();
        if (elExpression != null) {
            return this.findValueReferences(vrFactory, query, range, elExpression);
        }
        List<Variable> vars = query.findVariable(new VariableQuery.NameMatcher(refHolder.getVarName()));
        if (!vars.isEmpty()) {
            return Collections.singletonList(new ValueReference(vars.get(0), refHolder.getFieldName(), range));
        }
        ValueReference unknownVarRef = new ValueReference(new Variable(refHolder.getVarName(), DataType.getUnspecifiedType(), Variable.SCOPE.PAGE_SCOPE, ResolutionTime.NOT_AVAILABLE, null, null), refHolder.getFieldName(), range);
        unknownVarRef.setUnknownVar();
        return Collections.singletonList(unknownVarRef);
    }

    protected List<ValueReference> findValueReferences(ValueReferenceFactory vrFactory, DocumentVariableQuery query, Range range, String elExpression) {
        return vrFactory.createValueReference(elExpression, query, range, true);
    }

    protected boolean isUnifiedELJSFActive() {
        return true;
    }

    protected boolean isDeferredEvaluationEL(String expression) {
        return true;
    }

    protected final ResolutionTime getResolutionTime(SymbolContribAggregator aggregator) {
        String dependsOnAttr;
        String value;
        ResolutionTime resTime = ResolutionTime.PAGE_COMPILE;
        if (aggregator.forDeferredEvaluation()) {
            resTime = ResolutionTime.PAGE_RUN;
        } else if (resTime == null && aggregator.getDeferredValueDependsOnAttr() != null && (value = aggregator.getAttributeValue(dependsOnAttr = aggregator.getDeferredValueDependsOnAttr())) != null && this.isDeferredEvaluationEL(value)) {
            resTime = ResolutionTime.PAGE_RUN;
        }
        if (aggregator.isUnifiedELVariable() && this.isUnifiedELJSFActive()) {
            resTime = ResolutionTime.PAGE_RUN_OR_COMPILE;
        }
        return resTime;
    }

    protected void createSymbolsWithoutFactory(SymbolContribAggregator aggregator, String symbolName) {
        ResourceLocation loc = aggregator.getElementLocation();
        ResourceLocation locInBaseSourceFile = aggregator.getElementLocationInBaseSource();
        ResolutionTime resolutionTime = this.getResolutionTime(aggregator);
        Variable.SCOPE scope = this.getScope(aggregator);
        if (aggregator.isRuntimeIncludedNode() || scope == Variable.SCOPE.REQUEST_SCOPE || scope == Variable.SCOPE.SESSION_SCOPE || scope == Variable.SCOPE.APPLICATION_SCOPE) {
            Variable var = new Variable(symbolName, DataType.getUnspecifiedType(), scope, resolutionTime, loc, locInBaseSourceFile);
            this.resourceData.getCache().add(var);
        }
    }

    protected void createSymbolsWithFactory(String uri, SymbolContribAggregator aggregator, String symbolName) {
        ISymbol symbol = aggregator.createSymbol(symbolName);
        if (symbol != null) {
            DataType dataType = null;
            dataType = (symbol = this.getTypedSymbol(symbol, aggregator)) instanceof ITypedSymbol ? ((ITypedSymbol)symbol).getDataType() : DataType.getUnspecifiedType();
            ResourceLocation loc = aggregator.getLocation(symbol);
            ResourceLocation locInBaseSourceFile = aggregator.getLocationInBaseSourceFile(symbol);
            ResolutionTime resolutionTime = this.getResolutionTime(aggregator);
            Variable.SCOPE scope = this.getScope(aggregator);
            if (!aggregator.isRuntimeIncludedNode(symbol) || scope == Variable.SCOPE.REQUEST_SCOPE || scope == Variable.SCOPE.SESSION_SCOPE || scope == Variable.SCOPE.APPLICATION_SCOPE || scope == Variable.SCOPE.VIEW_SCOPE) {
                IVariablesCache cache = this.resourceData.getCache();
                if (symbol instanceof ITypedParameterSymbol) {
                    ISymbol actualSymbol = ((ITypedParameterSymbol)symbol).getActualSymbol();
                    String pathToCallee = ((ITypedParameterSymbol)symbol).getPathToCallee();
                    IVariablesCache resolveCache = this.resourceData.resolveCache(pathToCallee);
                    if (resolveCache != null) {
                        symbol = actualSymbol;
                        cache = resolveCache;
                    } else {
                        symbol = null;
                    }
                }
                if (cache != null && symbol != null) {
                    Variable var = null;
                    var = "http://xmlns.oracle.com/adf/faces/rich".equals(uri) && scope == Variable.SCOPE.NESTED_SCOPE ? new NestedVariableWithLocation(symbol.getName(), dataType, scope, resolutionTime, loc, locInBaseSourceFile) : new Variable(symbol.getName(), dataType, scope, resolutionTime, loc, locInBaseSourceFile);
                    cache.add(var);
                }
            }
        }
    }

    protected void processSymbolContrib(String uri, SymbolContribAggregator aggregator, String symbolName) {
        if (aggregator != null) {
            if (aggregator.hasFactory()) {
                this.createSymbolsWithFactory(uri, aggregator, symbolName);
            } else {
                this.createSymbolsWithoutFactory(aggregator, symbolName);
            }
        }
    }

    protected void reportELVarReference(String elText, Range range) {
        this.resourceData.getReferenceHolders().add(new ValueReferencePlaceHolder(elText, range, this.resourceData.getDocument()));
    }

    protected void reportVarReference(String varName, String fieldName, Range range) {
        this.resourceData.getReferenceHolders().add(new ValueReferencePlaceHolder(varName, fieldName, range, this.resourceData.getDocument()));
    }

    protected static class AdditionalContextSymbolInfo
    implements IAdditionalContextSymbolInfo {
        private final String _symbolTypeSignature;
        private final String _valueExpressionAttributeName;

        AdditionalContextSymbolInfo(String symbolTypeSignature, String valueExpressionAttributeName) {
            this._symbolTypeSignature = symbolTypeSignature;
            this._valueExpressionAttributeName = valueExpressionAttributeName;
        }

        public String getSymbolTypeSignature() {
            return this._symbolTypeSignature;
        }

        public String getValueExpressionAttributeName() {
            return this._valueExpressionAttributeName;
        }
    }

    protected abstract class ResourceData {
        private ITaglibContextResolver taglibResolver;
        private TagMetadata tagMetadata;
        private Set<ValueReferencePlaceHolder> referenceHolders = new HashSet<ValueReferencePlaceHolder>();
        private Set<String> imports = new HashSet<String>();
        private String superClass = null;
        private IFileVariablesCache cache = null;
        private IFile file;
        private IDocument document = null;
        private IResourceDiscoveryContext resourceContext = null;

        public ResourceData(IResourceDiscoveryContext resourceContext) {
            this.resourceContext = resourceContext;
            this.cache = (IFileVariablesCache)resourceContext.getAdapter(IFileVariablesCache.class);
            this.file = (IFile)resourceContext.getResource();
            this.taglibResolver = this.createTaglibResolver(this.getDocumentContext(resourceContext));
            this.document = (IDocument)Platform.getAdapterManager().loadAdapter((Object)this.file, IDocument.class.getName());
            IXMLMetadataContext metaDataContext = (IXMLMetadataContext)this.document.getAdapter(IXMLMetadataContext.class);
            INamespaceContextFactory nsContextFactory = (INamespaceContextFactory)this.document.getAdapter(INamespaceContextFactory.class);
            this.tagMetadata = new TagMetadata(nsContextFactory.getNamespaceContext(this.file), metaDataContext, this.file);
        }

        public ITaglibContextResolver getTaglibResolver() {
            return this.taglibResolver;
        }

        public final TagMetadata getTagMetadata() {
            return this.tagMetadata;
        }

        protected abstract ITaglibContextResolver createTaglibResolver(IDocumentContext var1);

        public final Set<ValueReferencePlaceHolder> getReferenceHolders() {
            return this.referenceHolders;
        }

        public final Set<String> getImports() {
            return this.imports;
        }

        public final String getSuperClass() {
            return this.superClass;
        }

        public final IFileVariablesCache getCache() {
            return this.cache;
        }

        public final IFile getFile() {
            return this.file;
        }

        public final IDocument getDocument() {
            return this.document;
        }

        public IResourceDiscoveryContext getResourceContext() {
            return this.resourceContext;
        }

        public final void setSuperClass(String superClass) {
            this.superClass = superClass;
        }

        public IVariablesCache resolveCache(String resourcePath) {
            IResource resourceForPath;
            IWebRootResolver adapter;
            Project proj;
            IProject project = this.getFile().getProject();
            if (resourcePath != null && resourcePath.startsWith("/") && (proj = (Project)project.getAdapter(Project.class)) != null && (adapter = (IWebRootResolver)proj.getAppService(IWebRootResolver.class)) != null && (resourceForPath = adapter.getResourceForPath(resourcePath)) != null && resourceForPath.getType() == 1) {
                return VariablesController.getInstance().getFileCache((IFile)resourceForPath, false);
            }
            return null;
        }

        public abstract IDocumentContext getDocumentContext(IResourceDiscoveryContext var1);
    }

    protected static class SymbolContribAggregator {
        private SymbolContribAggregatorData data;

        public static SymbolContribAggregator create(SymbolContribAggregatorData data) {
            if (data.contribsValueBindings) {
                return new SymbolContribAggregator(data);
            }
            return null;
        }

        public boolean hasFactory() {
            return this.data.hasFactory();
        }

        public ISymbol createSymbol(String symbolName) {
            return this.data.createSymbol(symbolName);
        }

        protected SymbolContribAggregator(SymbolContribAggregatorData data) {
            this.data = data;
        }

        public String getScope() {
            return this.data.scope;
        }

        public String getScopeAttr() {
            return this.data.scopeAttr;
        }

        public String getStaticType() {
            return this.data.staticType;
        }

        public String[] getTypeAttrs() {
            String typeAttrsString = this.data.typeAttrs;
            return typeAttrsString == null || typeAttrsString.length() == 0 ? null : StringUtil.strToList((String)typeAttrsString, (char)',').toArray(new String[0]);
        }

        public String getValueExpressionAttr() {
            return this.data.valueExprAttr;
        }

        public boolean acceptsTypeHint() {
            return Boolean.valueOf(this.data.acceptTypeHint);
        }

        public boolean forDeferredEvaluation() {
            return Boolean.valueOf(this.data.forDeferredEval);
        }

        public String getDeferredValueDependsOnAttr() {
            return this.data.dependsOnAttr;
        }

        public boolean isUnifiedELVariable() {
            return Boolean.valueOf(this.data.isUnifiedELVariable);
        }

        public String getAttributeValue(String typeAttrName) {
            return this.data.getAttributeValue(typeAttrName);
        }

        public IModelContext getDocumentContext() {
            return this.data.getDocumentContext();
        }

        public ResourceLocation getLocation(ISymbol symbol) {
            return this.data.getLocation(symbol);
        }

        public ResourceLocation getLocationInBaseSourceFile(ISymbol symbol) {
            return this.data.getLocationInBaseSourceFile(symbol);
        }

        public boolean isRuntimeIncludedNode(ISymbol symbol) {
            return this.data.isRuntimeIncludedNode(symbol);
        }

        public ISymbol createFromHints(ISymbol symbol, IDatatypeProvider dataTypeProvider, Set<String> imports) {
            return this.data.createFromHints(symbol, dataTypeProvider, imports);
        }

        public ResourceLocation getElementLocation() {
            return this.data.getElementLocation();
        }

        public ResourceLocation getElementLocationInBaseSource() {
            return this.data.getElementLocationInBaseSource();
        }

        public boolean isRuntimeIncludedNode() {
            return this.data.isRuntimeIncludeNode();
        }
    }

    protected static class SymbolContribAggregatorData {
        private static final String CONTRIBUTES_VALUE_BINDING = "contributes-value-binding";
        private static final String OEPE_CONTRIBUTES_VALUE_BINDING = "oepe-contributes-value-binding";
        private static final String VALUE_BINDING_SCOPE = "value-binding-scope";
        private static final String SCOPE_ATTRIBUTE = "scopeFromAttribute";
        private static final String TYPE_ATTRIBUTES = "typeFromAttributes";
        private static final String TYPE_HINT = "acceptTypeHint";
        private static final String VALUE_BINDING_SYMBOL_FACTORY = "value-binding-symbol-factory";
        private static final String OVERRIDE_VALUE_BINDING_SYMBOL_FACTORY = "adopter-override-value-binding-symbol-factory";
        private static final String STATIC_TYPE_KEY = "optional-value-binding-static-type";
        private static final String VALUEEXPRESSION_ATTR_NAME_KEY = "optional-value-binding-valueexpr-attr";
        private static final String FOR_DEFERRED_EVALUATION = "for-deferred-evaluation";
        private static final String DEFERRED_VALUE_DEPENDS_ON_ATTR = "deferred-value-depends-on-attribute";
        private static final String IS_UNIFIED_EL_VARIABLE_KEY = "is-unified-el-variable";
        private static final String OEPE_VAR_CONTRIB_TAG_ATTRS = "oepe-var-contrib-tag-attrs";
        String scope = null;
        String scopeAttr = null;
        String typeAttrs = null;
        String symbolFactory = null;
        String staticType = null;
        String valueExprAttr = null;
        String acceptTypeHint = null;
        String forDeferredEval = null;
        String dependsOnAttr = null;
        String isUnifiedELVariable = null;
        private boolean contribsValueBindings;
        private IFile file;
        private String uri;

        public SymbolContribAggregatorData(IFile file, String uri, String elementName, String attributeName) {
            this.file = file;
            this.uri = uri;
            String entityKey = String.valueOf(elementName) + "/" + attributeName;
            IMetaDataDomainContext mdContext = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(file);
            IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery(mdContext);
            Entity entity = query.getQueryHelper().getEntity(uri, entityKey);
            Trait trait = query.getQueryHelper().getTrait(entity, OEPE_CONTRIBUTES_VALUE_BINDING);
            if (trait == null) {
                trait = query.getQueryHelper().getTrait(entity, CONTRIBUTES_VALUE_BINDING);
            }
            this.contribsValueBindings = TraitValueHelper.getValueAsBoolean((Trait)trait);
            trait = query.getQueryHelper().getTrait(entity, SCOPE_ATTRIBUTE);
            this.scopeAttr = TraitValueHelper.getValueAsString((Trait)trait);
            trait = query.getQueryHelper().getTrait(entity, VALUE_BINDING_SCOPE);
            this.scope = TraitValueHelper.getValueAsString((Trait)trait);
            trait = query.getQueryHelper().getTrait(entity, OVERRIDE_VALUE_BINDING_SYMBOL_FACTORY);
            this.symbolFactory = TraitValueHelper.getValueAsString((Trait)trait);
            if (this.symbolFactory == null) {
                trait = query.getQueryHelper().getTrait(entity, VALUE_BINDING_SYMBOL_FACTORY);
                this.symbolFactory = TraitValueHelper.getValueAsString((Trait)trait);
            }
            trait = query.getQueryHelper().getTrait(entity, TYPE_ATTRIBUTES);
            this.typeAttrs = TraitValueHelper.getValueAsString((Trait)trait);
            trait = query.getQueryHelper().getTrait(entity, STATIC_TYPE_KEY);
            this.staticType = TraitValueHelper.getValueAsString((Trait)trait);
            trait = query.getQueryHelper().getTrait(entity, VALUEEXPRESSION_ATTR_NAME_KEY);
            this.valueExprAttr = TraitValueHelper.getValueAsString((Trait)trait);
            trait = query.getQueryHelper().getTrait(entity, TYPE_HINT);
            this.acceptTypeHint = TraitValueHelper.getValueAsString((Trait)trait);
            trait = query.getQueryHelper().getTrait(entity, FOR_DEFERRED_EVALUATION);
            this.forDeferredEval = TraitValueHelper.getValueAsString((Trait)trait);
            trait = query.getQueryHelper().getTrait(entity, DEFERRED_VALUE_DEPENDS_ON_ATTR);
            this.dependsOnAttr = TraitValueHelper.getValueAsString((Trait)trait);
            trait = query.getQueryHelper().getTrait(entity, IS_UNIFIED_EL_VARIABLE_KEY);
            this.isUnifiedELVariable = TraitValueHelper.getValueAsString((Trait)trait);
        }

        public static Set<String> getVarDeclaringTagAttributes(IFile file, String uri, String tagName) {
            String valueAsListOfStrings;
            List strToList;
            String entityKey = tagName;
            IMetaDataDomainContext mdContext = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(file);
            IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery(mdContext);
            Entity entity = query.getQueryHelper().getEntity(uri, entityKey);
            Trait trait = query.getQueryHelper().getTrait(entity, OEPE_VAR_CONTRIB_TAG_ATTRS);
            if (trait != null && !(strToList = StringUtil.strToList((String)(valueAsListOfStrings = TraitValueHelper.getValueAsString((Trait)trait)), (char)',')).isEmpty()) {
                return new HashSet<String>(strToList);
            }
            return Collections.EMPTY_SET;
        }

        public String getAttributeValue(String attributeName) {
            return null;
        }

        public IFile getFile() {
            return this.file;
        }

        public String getUri() {
            return this.uri;
        }

        public IModelContext getDocumentContext() {
            return null;
        }

        public ResourceLocation getLocation(ISymbol symbol) {
            return null;
        }

        public ResourceLocation getLocationInBaseSourceFile(ISymbol symbol) {
            return null;
        }

        public boolean isRuntimeIncludedNode(ISymbol symbol) {
            return false;
        }

        public ISymbol createFromHints(ISymbol symbol, IDatatypeProvider dataTypeProvider, Set<String> importedNames) {
            return null;
        }

        public ResourceLocation getElementLocation() {
            return null;
        }

        public ResourceLocation getElementLocationInBaseSource() {
            return null;
        }

        public boolean isRuntimeIncludeNode() {
            return false;
        }

        public ISymbol createSymbol(String symbolName) {
            return null;
        }

        public boolean hasFactory() {
            return false;
        }

        public String getStaticType() {
            return this.staticType;
        }

        public String getValueExprAttr() {
            return this.valueExprAttr;
        }
    }

    protected static class ValueReferencePlaceHolder {
        private final String varName;
        private final String fieldName;
        private final Range referenceRange;
        private final IDocument document;
        private final String elExpression;

        public ValueReferencePlaceHolder(String varName, String fieldName, Range referenceRange, IDocument document) {
            this.varName = varName;
            this.fieldName = fieldName;
            this.referenceRange = referenceRange;
            this.document = document;
            this.elExpression = null;
        }

        public ValueReferencePlaceHolder(String elExpression, Range referenceRange, IDocument document) {
            this.varName = null;
            this.elExpression = elExpression;
            this.referenceRange = referenceRange;
            this.document = document;
            this.fieldName = null;
        }

        public String getVarName() {
            return this.varName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getELExpression() {
            return this.elExpression;
        }

        public Range getRange() {
            return this.referenceRange;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public String toString() {
            return "var: " + this.varName + ", field: " + this.fieldName + ", el: " + this.elExpression + ", @ " + (this.referenceRange == null ? "unknown" : this.referenceRange.toString());
        }
    }
}

