/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.collection.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import oracle.eclipse.tools.application.common.services.TraceOptions;
import oracle.eclipse.tools.application.common.services.collection.IStructuredModelCollectionVisitor;
import oracle.eclipse.tools.application.common.services.collection.internal.StructuredDocumentCollectionContextImpl;
import oracle.eclipse.tools.application.common.services.collection.internal.StructuredDocumentResourceCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.internal.StructuredModelCollectionVisitorBuilder;
import oracle.eclipse.tools.application.common.services.collection.internal.StructuredModelVisitorExtensionReader;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.CollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.IResourceCollectionContext;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class StructuredModelCollectionParticipant
implements ICollectionParticipant {
    private final Set<StructuredModelCollectionVisitorBuilder> builders;
    private Set<IStructuredModelCollectionVisitor> visitors;
    private StructuredDocumentCollectionContextImpl context = null;

    private StructuredModelCollectionParticipant(Set<StructuredModelCollectionVisitorBuilder> builders) {
        this.builders = builders;
    }

    public synchronized Set<IResource> getDependentResources(IProject project, Set<IResource> changedResources, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return Collections.emptySet();
        }
        if (this.visitors == null) {
            this.initVisitors(project);
        }
        LinkedHashSet<IResource> dependentResources = new LinkedHashSet<IResource>();
        for (IStructuredModelCollectionVisitor visitor : this.visitors) {
            if (monitor != null && monitor.isCanceled()) {
                return Collections.emptySet();
            }
            dependentResources.addAll(visitor.getDependentResources(changedResources, monitor));
        }
        return dependentResources;
    }

    private void initVisitors(IProject project) {
        this.visitors = new LinkedHashSet<IStructuredModelCollectionVisitor>(this.builders.size());
        for (StructuredModelCollectionVisitorBuilder builder : this.builders) {
            try {
                if (!builder.isEnabledFor(project)) continue;
                IStructuredModelCollectionVisitor visitor = builder.build();
                this.visitors.add(visitor);
            }
            catch (CoreException e) {
                LoggingService.logError((String)"oracle.eclipse.tools.application.common.services", (String)("Unable to determine enablement for visitor collection may be limited. " + builder.toString()));
                LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (CoreException)e);
            }
        }
    }

    public synchronized void startCollecting(CollectionContext aContext, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.context = new StructuredDocumentCollectionContextImpl(aContext);
        if (this.visitors == null) {
            this.initVisitors(this.context.getProject());
        }
        for (IStructuredModelCollectionVisitor visitor : this.visitors) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            visitor.startCollecting(this.context, monitor);
        }
    }

    public void collect(IResourceCollectionContext resourceContext, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)this.visitors.size());
        if (this.context == null) {
            throw new IllegalStateException("Must call startCollecting() before collect().");
        }
        StructuredDocumentResourceCollectionContext contextWrapper = new StructuredDocumentResourceCollectionContext(resourceContext);
        IResource resource = contextWrapper.getResource();
        if (resource != null && resource.isAccessible() && resource.getType() == 1) {
            LinkedHashSet<IStructuredModelCollectionVisitor> applicableVisitors = new LinkedHashSet<IStructuredModelCollectionVisitor>(this.visitors.size());
            for (IStructuredModelCollectionVisitor visitor : this.visitors) {
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                if (!visitor.match(contextWrapper)) continue;
                applicableVisitors.add(visitor);
            }
            if (!applicableVisitors.isEmpty()) {
                IVisitableDOMModel model = null;
                try {
                    long timestamp = 0L;
                    if (TraceOptions.APPXRAY_PERF) {
                        timestamp = System.nanoTime();
                    }
                    model = contextWrapper.getVisitableModel();
                    if (TraceOptions.APPXRAY_PERF && model != null) {
                        TraceOptions.log("StructuredModelCollectionParticipant get structured model (" + resource.getName() + ") time ns, " + (System.nanoTime() - timestamp));
                        timestamp = System.nanoTime();
                    }
                    if (model != null) {
                        for (IStructuredModelCollectionVisitor visitor : applicableVisitors) {
                            if (monitor != null && monitor.isCanceled()) {
                                return;
                            }
                            visitor.beginResource(contextWrapper, monitor);
                        }
                        model.accept((IStructuredXMLModelVisitor)new Visitor(applicableVisitors), null, monitor);
                        for (IStructuredModelCollectionVisitor visitor : applicableVisitors) {
                            if (monitor != null && monitor.isCanceled()) {
                                return;
                            }
                            visitor.endResource(contextWrapper, monitor);
                        }
                        if (TraceOptions.APPXRAY_PERF) {
                            TraceOptions.log("StructuredModelCollectionParticipant process the model (" + resource.getName() + ") time ns, " + (System.nanoTime() - timestamp));
                        }
                    }
                }
                finally {
                    if (model != null) {
                        model.dispose();
                    }
                    ProgressMonitorUtil.done((IProgressMonitor)monitor);
                }
            }
        }
    }

    public IStatus stopCollecting(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        MultiStatus status = new MultiStatus("oracle.eclipse.tools.application.common.services", 0, "", null);
        for (IStructuredModelCollectionVisitor visitor : this.visitors) {
            if (monitor != null && monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            IStatus partStatus = visitor.stopCollecting(monitor);
            if (partStatus == null) continue;
            status.merge(partStatus);
        }
        return status;
    }

    /* synthetic */ StructuredModelCollectionParticipant(Set set, StructuredModelCollectionParticipant structuredModelCollectionParticipant) {
        this(set);
    }

    public static class FACTORY {
        public static ICollectionParticipant getParticipant() {
            return new StructuredModelCollectionParticipant(StructuredModelVisitorExtensionReader.getParticipantBuilders(), null);
        }
    }

    private static class Visitor
    implements IStructuredXMLModelVisitor {
        private final Set<IStructuredModelCollectionVisitor> visitors;
        private Stack<StackNode> stack = new Stack();

        public Visitor(Set<IStructuredModelCollectionVisitor> visitors) {
            this.visitors = new LinkedHashSet<IStructuredModelCollectionVisitor>(visitors);
        }

        public boolean visit(IDOMNode node) {
            return this.visit(node, this.getParentVisitors(node));
        }

        public boolean visit(IDOMAttr attribute) {
            return this.visit((IDOMNode)attribute, this.getParentVisitors(attribute));
        }

        public boolean visit(IDOMElement element) {
            return this.visit((IDOMNode)element, this.getParentVisitors((IDOMNode)element));
        }

        public boolean visit(IDOMDocument document) {
            boolean result = false;
            Iterator<IStructuredModelCollectionVisitor> visitorIterator = this.visitors.iterator();
            while (visitorIterator.hasNext()) {
                IStructuredModelCollectionVisitor visitor = visitorIterator.next();
                if (!visitor.visit(document)) {
                    visitorIterator.remove();
                    continue;
                }
                result = true;
            }
            return result;
        }

        private boolean visit(IDOMNode node, Set<? extends IStructuredXMLModelVisitor> parentVisitors) {
            LinkedHashSet<IStructuredXMLModelVisitor> childVisitors = new LinkedHashSet();
            if (node instanceof IDOMElement) {
                IDOMElement iDOMElement = (IDOMElement)node;
                for (IStructuredXMLModelVisitor iStructuredXMLModelVisitor : parentVisitors) {
                    if (!iStructuredXMLModelVisitor.visit(iDOMElement)) continue;
                    childVisitors.add(iStructuredXMLModelVisitor);
                }
            } else if (node instanceof IDOMAttr) {
                IDOMAttr iDOMAttr = (IDOMAttr)node;
                for (IStructuredXMLModelVisitor iStructuredXMLModelVisitor : parentVisitors) {
                    if (!iStructuredXMLModelVisitor.visit(iDOMAttr)) continue;
                    childVisitors.add(iStructuredXMLModelVisitor);
                }
            } else {
                for (IStructuredXMLModelVisitor iStructuredXMLModelVisitor : parentVisitors) {
                    if (!iStructuredXMLModelVisitor.visit(node)) continue;
                    childVisitors.add(iStructuredXMLModelVisitor);
                }
            }
            if (childVisitors.isEmpty()) {
                childVisitors = Collections.emptySet();
            }
            this.stack.push(new StackNode(node, childVisitors));
            return !childVisitors.isEmpty();
        }

        private Set<? extends IStructuredXMLModelVisitor> getParentVisitors(IDOMNode node) {
            return this.getVisitors((IDOMNode)node.getParentNode());
        }

        private Set<? extends IStructuredXMLModelVisitor> getParentVisitors(IDOMAttr attr) {
            IDOMNode parentNode = (IDOMNode)attr.getOwnerElement();
            return this.getVisitors(parentNode);
        }

        private Set<? extends IStructuredXMLModelVisitor> getVisitors(IDOMNode node) {
            while (!this.stack.isEmpty() && node != null && !node.equals(this.stack.peek().getNode())) {
                this.stack.pop();
            }
            if (this.stack.isEmpty()) {
                return this.visitors;
            }
            return this.stack.peek().getVisitors();
        }

        private static class StackNode {
            private final IDOMNode node;
            private final Set<IStructuredXMLModelVisitor> visitors;

            public StackNode(IDOMNode node, Set<IStructuredXMLModelVisitor> visitors) {
                this.node = node;
                this.visitors = visitors;
            }

            public IDOMNode getNode() {
                return this.node;
            }

            public Set<IStructuredXMLModelVisitor> getVisitors() {
                return this.visitors;
            }
        }
    }
}

