/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.collection.internal;

import java.io.IOException;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentResourceCollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.IResourceCollectionContext;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

class StructuredDocumentResourceCollectionContext
implements IStructuredDocumentResourceCollectionContext {
    private final IResourceCollectionContext context;
    private IVisitableDOMModel model = null;

    StructuredDocumentResourceCollectionContext(IResourceCollectionContext context) {
        this.context = context;
    }

    @Override
    public synchronized IVisitableDOMModel getVisitableModel() {
        IResource resource;
        if (this.model == null && (resource = this.context.getResource()) != null && resource.getType() == 1) {
            try {
                this.model = StructuredModelFactory.getVisitableModelForRead((IFile)((IFile)resource));
            }
            catch (CoreException ce) {
                LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (CoreException)ce);
            }
            catch (IOException ioe) {
                LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)ioe);
            }
        }
        return this.model;
    }

    public IResource getResource() {
        return this.context.getResource();
    }

    public void resetCollection(String artifactCollectorID) {
        this.context.resetCollection(artifactCollectorID);
    }

    public Object getProperty(String key) {
        return this.context.getProperty(key);
    }

    public void setProperty(String key, Object value) {
        this.context.setProperty(key, value);
    }

    public synchronized void dispose() {
        if (this.model != null) {
            this.model.dispose();
        }
    }

    public String toString() {
        return String.valueOf(this.context.toString()) + " -- Model is " + (this.model == null ? "null." : "non-null.");
    }

    public String getContentTypeId() {
        return this.context.getContentTypeId();
    }
}

