/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.collection.internal;

import java.util.Collection;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ArtifactException;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.CollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StructuredDocumentCollectionContextImpl
implements IStructuredDocumentCollectionContext {
    private final CollectionContext context;

    public void addArtifact(IArtifact artifact, String artifactCollectorID) {
        this.context.addArtifact(artifact, artifactCollectorID);
    }

    @Override
    public ResourceLocation getLocationOfNode(IResource resource, IDOMNode structuredNode) {
        if (resource.getType() == 1) {
            StructuredDocumentResourceLocationFactory locationFactory = new StructuredDocumentResourceLocationFactory((IFile)resource);
            if (structuredNode instanceof IDOMAttr) {
                return locationFactory.createForAttributeValue((IDOMAttr)structuredNode);
            }
            if (structuredNode instanceof IDOMElement) {
                return locationFactory.createForEntireElement((IDOMElement)structuredNode);
            }
        }
        return new ResourceLocation(resource, null);
    }

    @Override
    public void createResourceReferenceFromElement(IArtifact referantArtifact, IDOMElement element, boolean validateOnChange, String artifactCollectorID) {
        this.createResourceReferenceFromElement(referantArtifact, element, 0, 0, validateOnChange, artifactCollectorID);
    }

    @Override
    public IResource createResourceReferenceFromElement(IArtifact referantArtifact, IDOMElement element, int additionalOffset, int overrideLength, boolean validateOnChange, String artifactCollectorID) {
        IStructuredDocumentRegion startRegion = element.getStartStructuredDocumentRegion();
        IFile targetResource = null;
        if (startRegion != null && element.getEndStructuredDocumentRegion() != null) {
            int start = startRegion.getEndOffset() + additionalOffset;
            ResourceLocation loc = referantArtifact.getLocation();
            if (loc != null) {
                IResource resource = loc.getResource();
                String pathString = this.getNodeText((Node)element);
                if (pathString != null) {
                    int length = overrideLength > 0 ? overrideLength : pathString.length();
                    ResourceLocation referenceLocation = new ResourceLocation(resource, new Range((long)start, (long)length));
                    Path runtimePath = new Path(pathString.substring(additionalOffset, additionalOffset + length));
                    IVirtualFile runtimeFile = ComponentCore.createFile((IProject)resource.getProject(), (IPath)runtimePath);
                    targetResource = runtimeFile.getUnderlyingFile();
                    this.addReferencedResource(referantArtifact, (IResource)targetResource, validateOnChange, referenceLocation, (byte)1, artifactCollectorID);
                }
            }
        }
        return targetResource;
    }

    @Override
    public String getNodeText(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 5) {
                String reference = ((EntityReference)child).getNodeValue();
                if (reference == null && child.getNodeName() != null) {
                    reference = "&" + child.getNodeName() + ";";
                }
                if (reference != null) {
                    s.append(reference.trim());
                }
            } else {
                s.append(child.getNodeValue().trim());
            }
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }

    @Override
    public void addTypeReference(IArtifact src, IProject project, String typeName, IResource resource, IDOMElement element, boolean addSuperDataTypes, String artifactCollectorID) {
        this.context.addTypeReference(src, project, typeName, this.getLocationOfNode(resource, (IDOMNode)element), addSuperDataTypes, artifactCollectorID);
    }

    public void addDocumentToResourceDependancy(IResource resourceDependedOn, ResourceLocation referenceLocation, byte refType, String artifactCollectorID) {
        this.context.addDocumentToResourceDependancy(resourceDependedOn, referenceLocation, refType, artifactCollectorID);
    }

    public void addReferencedArtifact(IArtifact referantArtifact, IArtifactReference reference, boolean validateOnContentChange, byte refType) {
        this.context.addReferencedArtifact(referantArtifact, reference, validateOnContentChange, refType);
    }

    public void addReferencedResource(IArtifact referantArtifact, IResource referredToResource, boolean validateOnContentChange, ResourceLocation referenceLocation, byte refType, String artifactCollectorID) {
        this.context.addReferencedResource(referantArtifact, referredToResource, validateOnContentChange, referenceLocation, refType, artifactCollectorID);
    }

    public void addTypeReference(IArtifact src, IProject project, String typeName, ResourceLocation referenceLocation, boolean addSuperDataTypes, String artifactCollectorID) {
        this.context.addTypeReference(src, project, typeName, referenceLocation, addSuperDataTypes, artifactCollectorID);
    }

    public ResourceArtifact ensureResourceArtifact(IResource resource) {
        return this.context.ensureResourceArtifact(resource);
    }

    public IArtifact findArtifact(Integer ownerId, String type, String name) throws ArtifactException {
        return this.context.findArtifact(ownerId, type, name);
    }

    public Collection<IArtifact> findArtifactsByTypes(Collection<String> artifactTypes) throws ArtifactException {
        return this.context.findArtifactsByTypes(artifactTypes);
    }

    public Collection<? extends IArtifact> getArtifactReferences(IArtifact artifact) {
        return this.context.getArtifactReferences(artifact);
    }

    public Set<Integer> getArtifactReferencesByID(Integer artifactId) {
        return this.context.getArtifactReferencesByID(artifactId);
    }

    public Set<IArtifact> getChildren(IArtifact parent, String artifact_type) {
        return this.context.getChildren(parent, artifact_type);
    }

    public IProject getProject() {
        return this.context.getProject();
    }

    public Set<Integer> getReferringArtifactIDsByID(Integer artifactId, boolean forValidationOnly) {
        return this.context.getReferringArtifactIDsByID(artifactId, forValidationOnly);
    }

    public Set<Integer> getReferringArtifacts(IArtifact artifact, boolean forValidationOnly) {
        return this.context.getReferringArtifacts(artifact, forValidationOnly);
    }

    public Collection<? extends IArtifact> getReferringArtifactsByID(Integer artifactId, boolean forValidationOnly) {
        return this.context.getReferringArtifactsByID(artifactId, forValidationOnly);
    }

    public boolean hasIncludeDependants(ResourceArtifact fileArtifact) {
        return this.context.hasIncludeDependants(fileArtifact);
    }

    public IArtifact loadArtifact(Integer id) throws ArtifactException {
        return this.context.loadArtifact(id);
    }

    public void updateArtifact(IArtifact artifact) throws ArtifactException {
        this.context.updateArtifact(artifact);
    }

    public void updateCollectionDate(IResource resource) {
        this.context.updateCollectionDate(resource);
    }

    public void updateCollectionDate(ResourceArtifact fileArtifact) {
        this.context.updateCollectionDate(fileArtifact);
    }

    public void resetCollection(IArtifact artifact, String artifactCollectorID) {
        this.context.resetCollection(artifact, artifactCollectorID);
    }

    public void resetCollection(IArtifact artifact, String artifactCollectorID, IResource onlyForThisResource) {
        this.context.resetCollection(artifact, artifactCollectorID, onlyForThisResource);
    }

    public StructuredDocumentCollectionContextImpl(CollectionContext context) {
        this.context = context;
    }

    public Set<IResource> getChangedResources() {
        return this.context.getChangedResources();
    }

    public void removeReferences(ResourceArtifact artifact, String artifactCollectorID) {
        this.context.removeReferences(artifact, artifactCollectorID);
    }

    public void removeArtifact(IArtifact artifact) {
        this.context.removeArtifact(artifact);
    }
}

