/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.collection;

import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentRangeFactory;
import oracle.eclipse.tools.application.common.services.include.model.IMergedModelNode;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public final class StructuredDocumentResourceLocationFactory {
    private final IFile _owningFile;
    private final StructuredDocumentRangeFactory _factory;

    public StructuredDocumentResourceLocationFactory(IFile owningFile) {
        this._owningFile = owningFile;
        this._factory = new StructuredDocumentRangeFactory();
    }

    public ResourceLocation createForAttributeValue(IDOMAttr domAttr) {
        IMergedModelNode mmNode = (IMergedModelNode)domAttr.getAdapterFor(IMergedModelNode.class);
        if (mmNode != null) {
            return mmNode.getResourceLocation();
        }
        return new ResourceLocation((IResource)this._owningFile, this._factory.createRangeForAttributeValue(domAttr));
    }

    public ResourceLocation createForEntireElement(IDOMElement domElement) {
        int startOffset = domElement.getStartOffset();
        int end = domElement.getEndOffset();
        if (startOffset >= 0 && end >= startOffset) {
            IMergedModelNode mmNode = (IMergedModelNode)domElement.getAdapterFor(IMergedModelNode.class);
            if (mmNode != null) {
                return mmNode.getResourceLocation(end - startOffset + 1);
            }
            return new ResourceLocation((IResource)this._owningFile, new Range((long)startOffset, (long)(end - startOffset + 1)));
        }
        return null;
    }
}

