/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.collection;

import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.metadata.TagMetadata;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class AbstractTagCollector {
    private final IStructuredDocumentCollectionContext _collectionContext;
    private final TagMetadata _tagMetaData;
    private final AbstractTagContextUriResolver _contextUriResolver;
    private final String _collectorId;
    private final IXMLMetadataContext _mdContext;
    private StructuredDocumentResourceLocationFactory _locationFactory;

    public AbstractTagCollector(INamespaceContext namespaceContext, IXMLMetadataContext mdContext, IStructuredDocumentCollectionContext collectionContext, AbstractTagContextUriResolver contextUriResolver, StructuredDocumentResourceLocationFactory locationFactory, IFile baseFile, String collectorID) {
        this._mdContext = mdContext;
        this._tagMetaData = new TagMetadata(namespaceContext, mdContext, baseFile);
        this._collectionContext = collectionContext;
        this._contextUriResolver = contextUriResolver;
        this._locationFactory = locationFactory;
        this._collectorId = collectorID;
    }

    protected IXMLMetadataContext getMetadataContext() {
        return this._mdContext;
    }

    protected ResourceLocation createLocation(IDOMNode domNode, StructuredDocumentResourceLocationFactory factory) {
        if (domNode instanceof IDOMAttr) {
            return factory.createForAttributeValue((IDOMAttr)domNode);
        }
        return null;
    }

    protected TagMetadata getTagMetadata() {
        return this._tagMetaData;
    }

    protected IStructuredDocumentCollectionContext getCollectionContext() {
        return this._collectionContext;
    }

    protected String getID() {
        return this._collectorId;
    }

    protected AbstractTagContextUriResolver getTagContextUriResolver() {
        return this._contextUriResolver;
    }

    protected StructuredDocumentResourceLocationFactory getLocationFactory() {
        return this._locationFactory;
    }

    public static abstract class AbstractTagContextUriResolver {
        public abstract IPath resolve(IFile var1, IDOMElement var2, IDOMNode var3, String var4);
    }
}

