/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.collection;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.collection.AbstractWebDiscoveryParticipant;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentRangeFactory;
import oracle.eclipse.tools.application.common.services.documentservices.DOMUtil;
import oracle.eclipse.tools.application.common.services.documentservices.LocalizationRangeStore;
import oracle.eclipse.tools.application.common.services.documentservices.internal.IDocumentLocalizationContextWorkingCopy;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredXMLModelVisitorAdapter;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractLocalizationDiscoveryParticipant
extends AbstractWebDiscoveryParticipant {
    protected static volatile int counter = 0;

    public AbstractLocalizationDiscoveryParticipant(String id, LocalizationInjectableDependencies dependencies) {
        super(id, dependencies);
    }

    @Override
    protected final boolean initForFile(IFile file) {
        boolean success = super.initForFile(file);
        if (success) {
            IDocumentLocalizationContextWorkingCopy adapter;
            success = false;
            Project project = (Project)file.getProject().getAdapter(Project.class);
            ITechnologyExtension techExtension = project.getTechnologyExtensionById(this.getDependencies().getTechId());
            if (techExtension != null && (adapter = (IDocumentLocalizationContextWorkingCopy)techExtension.getDocumentService(IDocumentLocalizationContextWorkingCopy.class, this.getDependencies().getDocument())) != null) {
                this.getDependencies().setDocumentContext(adapter);
                success = true;
            }
        }
        return success;
    }

    protected LocalizationVisitor doDiscover(IVisitableDOMModel model) {
        if (this.getDependencies().isDebugEnabled()) {
            System.out.printf("doDiscover for file: %s (%d)\n", this.getDependencies().getFile(), counter++);
        }
        LocalizationVisitor visitor = (LocalizationVisitor)super.doDiscover(model);
        IDocumentLocalizationContextWorkingCopy context = this.getDependencies().getContext();
        if (visitor != null && context != null) {
            this.getDependencies().getBundles().update(visitor.getBundleRanges());
            this.getDependencies().getLocales().update(visitor.getLocaleRanges());
            context.flushQueuedEvents();
        }
        return visitor;
    }

    @Override
    public IStatus stopDiscovery(IProgressMonitor monitor) {
        this.getDependencies().clear();
        return Status.OK_STATUS;
    }

    @Override
    protected LocalizationInjectableDependencies getDependencies() {
        return (LocalizationInjectableDependencies)super.getDependencies();
    }

    protected abstract LocalizationVisitor createVisitor();

    public static class LocalizationInjectableDependencies
    extends AbstractWebDiscoveryParticipant.InjectableDependencies {
        private final DOMUtil _domUtil;
        private final String _techId;
        private IDocumentLocalizationContextWorkingCopy _context;

        public LocalizationInjectableDependencies(String techId, boolean isDebugEnabled) {
            this.setDebugEnabled(isDebugEnabled);
            this._domUtil = new DOMUtil();
            this._techId = techId;
        }

        public final DOMUtil getDomUtil() {
            return this._domUtil;
        }

        public final LocalizationRangeStore<String> getBundles() {
            return this._context == null ? null : this._context.getBundleRangeStore();
        }

        public final void setDocumentContext(IDocumentLocalizationContextWorkingCopy context) {
            this._context = context;
        }

        public final LocalizationRangeStore<Locale> getLocales() {
            return this._context == null ? null : this._context.getLocaleRangeStore();
        }

        public final IDocumentLocalizationContextWorkingCopy getContext() {
            return this._context;
        }

        protected final String getTechId() {
            return this._techId;
        }

        @Override
        public void clear() {
            super.clear();
            this._context = null;
        }
    }

    protected static abstract class LocalizationVisitor
    extends StructuredXMLModelVisitorAdapter {
        private final LocalizationInjectableDependencies _dependencies;
        private final Set<LocalizationRangeStore.RangeKeyedValue<String>> _newBundleData;
        private final Set<LocalizationRangeStore.RangeKeyedValue<Locale>> _newLocaleData;
        protected final StructuredDocumentRangeFactory _rangeFactory;
        private final boolean DEBUG;

        public LocalizationVisitor(LocalizationInjectableDependencies dependencies) {
            this._dependencies = dependencies;
            this._newBundleData = new HashSet<LocalizationRangeStore.RangeKeyedValue<String>>();
            this._newLocaleData = new HashSet<LocalizationRangeStore.RangeKeyedValue<Locale>>();
            this._rangeFactory = new StructuredDocumentRangeFactory();
            this.DEBUG = dependencies.isDebugEnabled();
        }

        protected final LocalizationInjectableDependencies getDependencies() {
            return this._dependencies;
        }

        protected final void addBundleRange(Range range, Range definitionRange, String value) {
            LocalizationRangeStore.RangeKeyedValue<String> rangeKeyedValue = new LocalizationRangeStore.RangeKeyedValue<String>(range, definitionRange, value);
            if (this.DEBUG) {
                System.out.println("Adding bundle range: " + rangeKeyedValue);
            }
            this._newBundleData.add(rangeKeyedValue);
        }

        protected final void addLocaleRange(Range range, Range definitionRange, Locale value) {
            LocalizationRangeStore.RangeKeyedValue<Locale> rangeKeyedValue = new LocalizationRangeStore.RangeKeyedValue<Locale>(range, definitionRange, value);
            if (this.DEBUG) {
                System.out.println("Adding locale range: " + rangeKeyedValue);
            }
            this._newLocaleData.add(rangeKeyedValue);
        }

        public final Set<LocalizationRangeStore.RangeKeyedValue<String>> getBundleRanges() {
            return Collections.unmodifiableSet(this._newBundleData);
        }

        public final Set<LocalizationRangeStore.RangeKeyedValue<Locale>> getLocaleRanges() {
            return Collections.unmodifiableSet(this._newLocaleData);
        }
    }
}

