/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.collection;

import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentResourceCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.IStructuredModelCollectionVisitor;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ContentTypeCollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.IResourceCollectionContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractArtifactCollector
implements IStructuredModelCollectionVisitor {
    private final String _id;
    private final Set<String> _contentTypes;
    private final ICollectionFilter _collectionFilter;
    protected IStructuredDocumentCollectionContext structuredContext;

    @Override
    public boolean match(IResourceCollectionContext context) {
        return this.getFilter().match((IResourceContext)context);
    }

    protected AbstractArtifactCollector(String id, Set<String> contentTypes) {
        this._id = id;
        this._contentTypes = Collections.unmodifiableSet(contentTypes);
        this._collectionFilter = new ContentTypeCollectionFilter(this._contentTypes);
    }

    @Override
    public void startCollecting(IStructuredDocumentCollectionContext context, IProgressMonitor monitor) {
        this.structuredContext = context;
    }

    @Override
    public void beginResource(IStructuredDocumentResourceCollectionContext resourceContext, IProgressMonitor monitor) {
        resourceContext.resetCollection(this.getID());
    }

    @Override
    public void endResource(IStructuredDocumentResourceCollectionContext resourceContext, IProgressMonitor monitor) {
    }

    @Override
    public final String getID() {
        return this._id;
    }

    @Override
    public IStatus stopCollecting(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public ICollectionFilter getFilter() {
        return this._collectionFilter;
    }

    @Override
    public Set<IResource> getDependentResources(Set<IResource> changedResources, IProgressMonitor monitor) {
        return Collections.emptySet();
    }
}

