/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services;

import java.util.List;
import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.appservices.IDesignTimeLocaleService;
import oracle.eclipse.tools.application.common.services.appservices.IExpectedFacetService;
import oracle.eclipse.tools.application.common.services.appservices.IPreferredTagLibraryProvider;
import oracle.eclipse.tools.application.common.services.appservices.IVersionProvider;
import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.application.common.services.appservices.IWebVersionAppService;
import oracle.eclipse.tools.application.common.services.appservices.TechComposingAppService;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.techextservices.IPreferredTagLibraryHandler;
import oracle.eclipse.tools.application.common.services.webapp.DesignTimeLocaleService;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.model.internal.DiscoveryStore;
import oracle.eclipse.tools.common.services.dependency.model.internal.IDiscoveryStore;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.app.services.AppServicesFactory;
import oracle.eclipse.tools.common.services.refactoring.IArtifactRefactoringService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.J2EEFileUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class JavaWebAppServicesFactory
extends AppServicesFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!(adaptableObject instanceof Project)) {
            return null;
        }
        Project project = (Project)adaptableObject;
        if (adapterType == IDatatypeProvider.class || adapterType == IAppClassLoaderProvider.class) {
            return this.getSingleTechExtAdapter(project, adapterType);
        }
        if (adapterType == IPreferredTagLibraryProvider.class) {
            return this.doCreatePreferredTagLibraryProvider(project);
        }
        if (adapterType == IWebVersionAppService.class) {
            return new JavaWebAppVersionService(project);
        }
        if (adapterType == IAppLocalizer.class) {
            return this.getSingleTechExtAdapter(project, adapterType);
        }
        if (adapterType == IDesignTimeLocaleService.class) {
            return new DesignTimeLocaleService(project);
        }
        if (adapterType == IDiscoveryStore.class) {
            return new DiscoveryStore(project);
        }
        if (adapterType == IVersionProvider.class) {
            return new JavaWebAppVersionProvidingService(project);
        }
        if (adapterType == IArtifactRefactoringService.class) {
            return new ArtifactRefactoringService(project);
        }
        if (adapterType == IWebRootResolver.class) {
            return this.getFirstTechExtToAnswer(project, IWebRootResolver.class);
        }
        return null;
    }

    public Class[] getAdapterList() {
        throw new UnsupportedOperationException("JavaWebAppServicesFactory does not support getAdapterList.");
    }

    private IPreferredTagLibraryProvider doCreatePreferredTagLibraryProvider(Project project) {
        return new PreferredTagLibrariesProvider(project);
    }

    protected static final class ArtifactRefactoringService
    extends TechComposingAppService<IArtifactRefactoringService>
    implements IArtifactRefactoringService {
        public ArtifactRefactoringService(Project project) {
            super(project);
        }

        public RefactoringStatus validateArtifactRename(IArtifact artifact, String newName) {
            RefactoringStatus status = new RefactoringStatus();
            List<IArtifactRefactoringService> serviceList = this.createComposedServiceList(IArtifactRefactoringService.class);
            for (IArtifactRefactoringService service : serviceList) {
                status.merge(service.validateArtifactRename(artifact, newName));
            }
            return status;
        }
    }

    protected static final class JavaWebAppVersionProvidingService
    extends TechComposingAppService<IVersionProvider>
    implements IVersionProvider {
        public JavaWebAppVersionProvidingService(Project project) {
            super(project);
        }

        @Override
        public IVersion getVersion(String nsId) {
            for (IVersionProvider prov : this.getVersionProviders()) {
                IVersion version = prov.getVersion(nsId);
                if (version == null) continue;
                return version;
            }
            return null;
        }

        private List<IVersionProvider> getVersionProviders() {
            return this.createComposedServiceList(IVersionProvider.class);
        }
    }

    protected static final class JavaWebAppVersionService
    extends TechComposingAppService<IExpectedFacetService>
    implements IWebVersionAppService {
        private final IProject _iProject;

        public JavaWebAppVersionService(Project project) {
            super(project);
            this._iProject = project.getEclipseProject();
        }

        @Override
        public IWebVersionAppService.ServletVersion getServletVersion() {
            IResource webXMLResource;
            IVirtualResource webXMLVirtualResource;
            int servletVersion = -1;
            IVirtualComponent component = ComponentCore.createComponent((IProject)this._iProject);
            if (component != null && (webXMLVirtualResource = component.getRootFolder().findMember("WEB-INF/web.xml")) != null && (webXMLResource = webXMLVirtualResource.getUnderlyingResource()) != null && webXMLResource.isAccessible()) {
                String fileURI = webXMLResource.getLocation().toOSString();
                servletVersion = J2EEFileUtil.getFastSpecVersion((String)fileURI);
            }
            switch (servletVersion) {
                case 22: {
                    return IWebVersionAppService.ServletVersion.VERSION_2_2;
                }
                case 23: {
                    return IWebVersionAppService.ServletVersion.VERSION_2_3;
                }
                case 24: {
                    return IWebVersionAppService.ServletVersion.VERSION_2_4;
                }
                case 25: {
                    return IWebVersionAppService.ServletVersion.VERSION_2_5;
                }
                case 30: {
                    return IWebVersionAppService.ServletVersion.VERSION_3_0;
                }
            }
            return IWebVersionAppService.ServletVersion.UNKNOWN;
        }

        @Override
        public List<IExpectedFacetService> getExpectedFacetServices() {
            return this.createComposedServiceList(IExpectedFacetService.class);
        }
    }

    protected static final class PreferredTagLibrariesProvider
    extends TechComposingAppService<IPreferredTagLibraryHandler>
    implements IPreferredTagLibraryProvider {
        public PreferredTagLibrariesProvider(Project project) {
            super(project);
        }

        @Override
        public IPreferredTagLibraryHandler.Preference handleTagLibrary(String uri) {
            List<IPreferredTagLibraryHandler> handlers = this.createComposedServiceList(IPreferredTagLibraryHandler.class);
            for (IPreferredTagLibraryHandler handler : handlers) {
                IPreferredTagLibraryHandler.Preference pref = handler.handleTagLibrary(uri);
                if (pref == IPreferredTagLibraryHandler.Preference.NOT_HANDLED) continue;
                return pref;
            }
            return IPreferredTagLibraryHandler.Preference.NOT_HANDLED;
        }
    }
}

