/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.wst.jsdt.internal.core.util.QualificationHelpers;

public class TypeDeclarationPattern
extends JavaSearchPattern {
    public char[] qualification;
    public char[] simpleName;
    public char[][] superTypes;
    public char[][] enclosingTypeNames;
    public int modifiers;
    private char[] fSearchPrefix;
    private static char[][] CATEGORIES = new char[][]{TYPE_DECL};

    TypeDeclarationPattern(int matchRule) {
        super(8, matchRule);
    }

    public TypeDeclarationPattern(char[] qualification, char[] simpleName, int matchRule) {
        this(qualification, simpleName, null, matchRule);
    }

    public TypeDeclarationPattern(char[] qualification, char[] simpleName, char[][] superTypes, int matchRule) {
        this(matchRule);
        if ((qualification == null || qualification.length == 0) && CharOperation.contains('.', simpleName)) {
            char[][] seperated = QualificationHelpers.seperateFullyQualifedName(simpleName);
            this.qualification = seperated[0];
            this.simpleName = seperated[1];
        } else {
            this.qualification = (char[])(qualification != null && qualification.length > 0 ? qualification : null);
            this.simpleName = simpleName;
        }
        this.qualification = this.isCaseSensitive() || this.isCamelCase() ? this.qualification : CharOperation.toLowerCase(this.qualification);
        this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? this.simpleName : CharOperation.toLowerCase(this.simpleName);
        this.superTypes = superTypes;
    }

    public TypeDeclarationPattern(char[] searchPrefix, int matchRule) {
        this(matchRule);
        this.fSearchPrefix = this.isCaseSensitive() || this.isCamelCase() ? searchPrefix : CharOperation.toLowerCase(searchPrefix);
    }

    public void decodeIndexKey(char[] key) {
        char[][] seperated = CharOperation.splitOn('/', key);
        this.simpleName = seperated[0];
        this.qualification = seperated[1];
        this.superTypes = CharOperation.splitOn(',', seperated[2]);
        this.modifiers = seperated[3][0] + seperated[3][1];
    }

    public SearchPattern getBlankPattern() {
        return new TypeDeclarationPattern(8);
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        TypeDeclarationPattern pattern = (TypeDeclarationPattern)decodedPattern;
        char[][] seperatedSearchPrefix = QualificationHelpers.seperateFullyQualifedName(this.fSearchPrefix);
        return this.fSearchPrefix != null && (this.matchesName(this.fSearchPrefix, CharOperation.append(pattern.qualification, '.')) || this.matchesName(this.fSearchPrefix, pattern.simpleName) || (CharOperation.equals(seperatedSearchPrefix[0], pattern.qualification, this.isCaseSensitive) || TypeDeclarationPattern.matchesQualificationPattern(seperatedSearchPrefix[0], pattern.qualification, this.isCaseSensitive)) && this.matchesName(seperatedSearchPrefix[1], pattern.simpleName)) || this.fSearchPrefix == null && this.matchesName(this.qualification, pattern.qualification) && this.matchesName(this.simpleName, pattern.simpleName) || this.fSearchPrefix == null && this.superTypes != null && this.matchesName(this.superTypes, pattern.superTypes);
    }

    private boolean matchesName(char[][] superTypes, char[][] patternSuperTypes) {
        int i = 0;
        while (i < superTypes.length) {
            int j = 0;
            while (j < patternSuperTypes.length) {
                if (this.matchesName(this.superTypes[i], patternSuperTypes[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        char[] simpleNamePattern;
        char[] qualificationPattern;
        EntryResult[] results = null;
        if (this.fSearchPrefix != null) {
            char[][] seperatedSearchPrefix = QualificationHelpers.seperateFullyQualifedName(this.fSearchPrefix);
            qualificationPattern = seperatedSearchPrefix[0];
            simpleNamePattern = seperatedSearchPrefix[1];
        } else {
            qualificationPattern = this.qualification;
            simpleNamePattern = this.simpleName;
        }
        char[][] keys = null;
        int[] matchRules = null;
        switch (this.getMatchMode()) {
            case 0: {
                keys = new char[1][];
                matchRules = new int[1];
                if (this.isCamelCase) break;
                keys[0] = qualificationPattern == null || qualificationPattern.length == 0 ? CharOperation.append(simpleNamePattern, '/') : CharOperation.concat(simpleNamePattern, qualificationPattern, '/');
                keys[0] = CharOperation.append(keys[0], '/');
                if (this.superTypes != null) {
                    keys[0] = CharOperation.concat(keys[0], CharOperation.concatWith(this.superTypes, ','));
                }
                matchRules[0] = this.getMatchRule();
                matchRules[0] = matchRules[0] & 0xFFFFFFFF;
                matchRules[0] = matchRules[0] | 1;
                break;
            }
            case 1: {
                if (qualificationPattern != null && qualificationPattern.length > 0) {
                    if (simpleNamePattern == null || simpleNamePattern.length == 0) {
                        keys = new char[1][];
                        matchRules = new int[1];
                    } else {
                        keys = new char[2][];
                        matchRules = new int[2];
                        keys[1] = simpleNamePattern;
                        matchRules[1] = this.getMatchRule();
                    }
                    char[] trimmedPrefix = this.fSearchPrefix;
                    if (this.fSearchPrefix != null && this.fSearchPrefix[this.fSearchPrefix.length - 1] == '.') {
                        trimmedPrefix = CharOperation.subarray(this.fSearchPrefix, 0, this.fSearchPrefix.length - 1);
                    }
                    keys[0] = CharOperation.concat(ONE_STAR, trimmedPrefix, '/');
                    keys[0] = CharOperation.concat(keys[0], ONE_STAR);
                    if (this.superTypes != null) {
                        keys[0] = CharOperation.concat(keys[0], CharOperation.concatWith(this.superTypes, ','));
                    }
                    matchRules[0] = this.getMatchRule();
                    matchRules[0] = matchRules[0] & 0xFFFFFFFE;
                    matchRules[0] = matchRules[0] | 2;
                    break;
                }
                if (simpleNamePattern == null || simpleNamePattern.length == 0) {
                    keys = new char[1][];
                    matchRules = new int[1];
                } else {
                    keys = new char[2][];
                    matchRules = new int[2];
                    keys[1] = simpleNamePattern;
                    matchRules[1] = this.getMatchRule();
                }
                keys[0] = CharOperation.concat(ONE_STAR, simpleNamePattern, '/');
                keys[0] = CharOperation.concat(keys[0], ONE_STAR);
                matchRules[0] = this.getMatchRule();
                matchRules[0] = matchRules[0] & 0xFFFFFFFE;
                matchRules[0] = matchRules[0] | 2;
                break;
            }
            case 2: {
                if (this.fSearchPrefix != null) {
                    keys = new char[2][];
                    matchRules = new int[2];
                    keys[1] = CharOperation.concat(ONE_STAR, this.fSearchPrefix, '/');
                    keys[1] = CharOperation.concat(keys[1], ONE_STAR, '/');
                    matchRules[1] = this.getMatchRule();
                } else {
                    keys = new char[1][];
                    matchRules = new int[1];
                }
                if (simpleNamePattern == null || simpleNamePattern.length == 0) {
                    simpleNamePattern = ONE_STAR;
                }
                if (qualificationPattern == null || qualificationPattern.length == 0) {
                    qualificationPattern = ONE_STAR;
                }
                keys[0] = CharOperation.concat(simpleNamePattern, qualificationPattern, '/');
                keys[0] = this.superTypes != null ? CharOperation.concat(keys[0], '/', CharOperation.concatWith(this.superTypes, ','), '/', ONE_STAR) : CharOperation.concat(keys[0], ONE_STAR, '/');
                matchRules[0] = this.getMatchRule();
                break;
            }
            case 4: {
                Logger.log(2, "Regular expression matching is not implimented by ConstructorDeclarationPattern");
            }
        }
        int i = 0;
        while (i < keys.length) {
            EntryResult[] additionalResults = index.query(this.getIndexCategories(), keys[i], matchRules[i]);
            if (additionalResults != null && additionalResults.length > 0) {
                if (results == null) {
                    results = additionalResults;
                } else {
                    EntryResult[] existingResults = results;
                    results = new EntryResult[existingResults.length + additionalResults.length];
                    System.arraycopy(existingResults, 0, results, 0, existingResults.length);
                    System.arraycopy(additionalResults, 0, results, existingResults.length, additionalResults.length);
                }
            }
            ++i;
        }
        return results;
    }

    protected StringBuffer print(StringBuffer output) {
        if (this.qualification != null) {
            output.append(this.qualification);
        } else {
            output.append("*");
        }
        if (this.simpleName != null) {
            output.append(this.simpleName);
        } else {
            output.append("*");
        }
        output.append(">");
        return super.print(output);
    }

    public static char[] createIndexKey(char[] qualification, char[] simpleName, char[][] fullyQualifiedSuperTypeNames, int modifiers) {
        char[] indexKey = null;
        if (simpleName != null) {
            char[] fullyQualifiedSuperTypeNamesList = null;
            fullyQualifiedSuperTypeNamesList = fullyQualifiedSuperTypeNames != null ? CharOperation.concatWith(fullyQualifiedSuperTypeNames, ',') : CharOperation.NO_CHAR;
            int simpleNameLength = simpleName.length;
            int qualificationLength = qualification == null ? 0 : qualification.length;
            int keyLength = simpleNameLength + 1 + qualificationLength + 1 + fullyQualifiedSuperTypeNamesList.length + 3;
            indexKey = new char[keyLength];
            int pos = 0;
            if (simpleNameLength > 0) {
                System.arraycopy(simpleName, 0, indexKey, pos, simpleNameLength);
                pos += simpleNameLength;
            }
            indexKey[pos++] = 47;
            if (qualificationLength > 0) {
                System.arraycopy(qualification, 0, indexKey, pos, qualificationLength);
                pos += qualificationLength;
            }
            indexKey[pos++] = 47;
            if (fullyQualifiedSuperTypeNamesList.length > 0) {
                System.arraycopy(fullyQualifiedSuperTypeNamesList, 0, indexKey, pos, fullyQualifiedSuperTypeNamesList.length);
                pos += fullyQualifiedSuperTypeNamesList.length;
            }
            indexKey[pos++] = 47;
            indexKey[pos++] = (char)modifiers;
            indexKey[pos++] = (char)(modifiers >> 16);
        }
        return indexKey;
    }

    public char[] getSearchPrefix() {
        return this.fSearchPrefix;
    }
}

