/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class AddJarFileToIndex
extends IndexRequest {
    private static final char JAR_SEPARATOR = "|".charAt(0);
    IFile resource;
    Scanner scanner;

    public AddJarFileToIndex(IFile resource, IndexManager manager) {
        super(resource.getFullPath(), manager);
        this.resource = resource;
    }

    public AddJarFileToIndex(IPath jarPath, IndexManager manager) {
        super(jarPath, manager);
    }

    public boolean equals(Object o) {
        if (o instanceof AddJarFileToIndex) {
            if (this.resource != null) {
                return this.resource.equals((Object)((AddJarFileToIndex)o).resource);
            }
            if (this.containerPath != null) {
                return this.containerPath.equals((Object)((AddJarFileToIndex)o).containerPath);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.resource != null) {
            return this.resource.hashCode();
        }
        if (this.containerPath != null) {
            return this.containerPath.hashCode();
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled != false) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        try {
            block44: {
                block43: {
                    block40: {
                        block41: {
                            index = this.manager.getIndexForUpdate(this.containerPath, false, false);
                            if (index != null) {
                                if (JobManager.VERBOSE == false) return true;
                                Util.verbose("-> no indexing required (index already exists) for " + this.containerPath);
                                return true;
                            }
                            index = this.manager.getIndexForUpdate(this.containerPath, true, true);
                            if (index == null) {
                                if (JobManager.VERBOSE == false) return true;
                                Util.verbose("-> index could not be created for " + this.containerPath);
                                return true;
                            }
                            monitor = index.monitor;
                            if (monitor == null) {
                                if (JobManager.VERBOSE == false) return true;
                                Util.verbose("-> index for " + this.containerPath + " just got deleted");
                                return true;
                            }
                            zip = null;
                            try {
                                block49: {
                                    block48: {
                                        block47: {
                                            block45: {
                                                block46: {
                                                    block42: {
                                                        zipFilePath = null;
                                                        monitor.enterWrite();
                                                        if (this.resource == null) break block45;
                                                        location = this.resource.getLocationURI();
                                                        if (location == null) {
lbl28:
                                                            // 6 sources

                                                            while (true) {
                                                                var17_9 = null;
                                                                if (zip == null) break block40;
                                                                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                                                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                                                                }
                                                                break block41;
                                                                break;
                                                            }
                                                        }
                                                        if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                                            System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + location.getPath());
                                                        }
                                                        file = null;
                                                        try {
                                                            file = Util.toLocalFile(location, progressMonitor);
                                                        }
                                                        catch (CoreException e) {
                                                            if (!JobManager.VERBOSE) break block42;
                                                            Util.verbose("-> failed to index " + location.getPath() + " because of the following exception:");
                                                            e.printStackTrace();
                                                        }
                                                    }
                                                    if (file != null) break block46;
                                                    if (JobManager.VERBOSE) {
                                                        Util.verbose("-> failed to index " + location.getPath() + " because the file could not be fetched");
                                                    }
                                                    ** GOTO lbl28
                                                }
                                                zip = new ZipFile(file);
                                                zipFilePath = (Path)this.resource.getFullPath().makeRelative();
                                                break block47;
                                            }
                                            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                                System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + this.containerPath);
                                            }
                                            zip = new ZipFile(this.containerPath.toFile());
                                            zipFilePath = (Path)this.containerPath;
                                        }
                                        if (!this.isCancelled) break block48;
                                        if (JobManager.VERBOSE) {
                                            Util.verbose("-> indexing of " + zip.getName() + " has been cancelled");
                                        }
                                        ** GOTO lbl28
                                    }
                                    if (JobManager.VERBOSE) {
                                        Util.verbose("-> indexing " + zip.getName());
                                    }
                                    initialTime = System.currentTimeMillis();
                                    paths = index.queryDocumentNames("");
                                    if (paths != null) {
                                        max = paths.length;
                                        EXISTS = "OK";
                                        DELETED = "DELETED";
                                        indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                                        i = 0;
                                        while (true) {
                                            if (i >= max) break;
                                            indexedFileNames.put(paths[i], DELETED);
                                            ++i;
                                        }
                                        e = zip.entries();
                                        while (true) {
                                            if (!e.hasMoreElements()) {
                                                v0 = needToReindex = indexedFileNames.elementSize != max;
                                            }
                                            ze = e.nextElement();
                                            zipEntryName = ze.getName();
                                            if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(zipEntryName)) continue;
                                            indexedFileNames.put(zipEntryName, EXISTS);
                                        }
                                        if (!needToReindex) {
                                            valueTable = indexedFileNames.valueTable;
                                            i = 0;
                                            l = valueTable.length;
                                            while (i < l) {
                                                if (valueTable[i] == DELETED) {
                                                    needToReindex = true;
                                                    break;
                                                }
                                                ++i;
                                            }
                                            if (!needToReindex) {
                                                if (JobManager.VERBOSE) {
                                                    Util.verbose("-> no indexing required (index is consistent with library) for " + zip.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                                                }
                                                this.manager.saveIndex(index);
                                                break block43;
                                            }
                                        }
                                    }
                                    participant = SearchEngine.getDefaultSearchParticipant();
                                    if (this.manager.resetIndex(this.containerPath)) break block49;
                                    this.manager.removeIndex(this.containerPath);
                                    ** GOTO lbl28
                                }
                                indexPath = null;
                                e = zip.entries();
                                block11: while (true) {
                                    block50: {
                                        if (!e.hasMoreElements()) {
                                            this.manager.saveIndex(index);
                                            if (JobManager.VERBOSE) {
                                                Util.verbose("-> done indexing of " + zip.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                                            }
                                            break block44;
                                        }
                                        if (!this.isCancelled) break block50;
                                        if (!JobManager.VERBOSE) ** GOTO lbl28
                                        Util.verbose("-> indexing of " + zip.getName() + " has been cancelled");
                                        ** continue;
                                    }
                                    ze = e.nextElement();
                                    zipEntryName = ze.getName();
                                    if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(zipEntryName)) continue;
                                    classFileBytes = org.eclipse.wst.jsdt.internal.compiler.util.Util.getZipEntryByteContent(ze, zip);
                                    classFileChars = new char[classFileBytes.length];
                                    i = 0;
                                    while (true) {
                                        if (i >= classFileChars.length) {
                                            entryDocument = new JavaSearchDocument(ze, (IPath)zipFilePath, classFileChars, participant);
                                            this.manager.indexDocument(entryDocument, participant, index, indexPath);
                                            continue block11;
                                        }
                                        classFileChars[i] = (char)classFileBytes[i];
                                        ++i;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable var18_30) {
                                var17_11 = null;
                                if (zip != null) {
                                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                                    }
                                    zip.close();
                                }
                                monitor.exitWrite();
                                throw var18_30;
                            }
                        }
                        zip.close();
                    }
                    monitor.exitWrite();
                    return false;
                }
                var17_10 = null;
                if (zip != null) {
                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                    }
                    zip.close();
                }
                monitor.exitWrite();
                return true;
            }
            var17_12 = null;
            if (zip != null) {
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                }
                zip.close();
            }
            monitor.exitWrite();
            return true;
        }
        catch (IOException e) {
            if (JobManager.VERBOSE) {
                Util.verbose("-> failed to index " + this.containerPath + " because of the following exception:");
                e.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            return false;
        }
    }

    private boolean isIdentifier() throws InvalidInputException {
        switch (this.scanner.scanIdentifier()) {
            case 32: 
            case 95: {
                return true;
            }
        }
        return false;
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing " + this.containerPath.toString();
    }
}

