/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.IInferEngine;
import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.wst.jsdt.internal.core.ImportContainer;
import org.eclipse.wst.jsdt.internal.core.ImportDeclaration;
import org.eclipse.wst.jsdt.internal.core.ImportDeclarationElementInfo;
import org.eclipse.wst.jsdt.internal.core.Initializer;
import org.eclipse.wst.jsdt.internal.core.InitializerElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.SourceConstructorInfo;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceFieldElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceMethodElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceMethodInfo;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;
import org.eclipse.wst.jsdt.internal.core.SourceRefElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.util.ReferenceInfoAdapter;

public class CompilationUnitStructureRequestor
extends ReferenceInfoAdapter
implements ISourceElementRequestor {
    protected IJavaScriptElement unit;
    protected CompilationUnitElementInfo unitInfo;
    protected JavaElementInfo importContainerInfo = null;
    protected Map newElements;
    protected Stack infoStack;
    protected HashMap children;
    protected Stack handleStack;
    protected int referenceCount = 0;
    protected boolean hasSyntaxErrors = false;
    protected Parser parser;
    protected static byte[] NO_BYTES = new byte[0];
    protected HashtableOfObject fieldRefCache;
    protected HashtableOfObject messageRefCache;
    protected HashtableOfObject typeRefCache;
    protected HashtableOfObject unknownRefCache;

    protected CompilationUnitStructureRequestor(IJavaScriptElement unit, CompilationUnitElementInfo unitInfo, Map newElements) {
        this.unit = unit;
        this.unitInfo = unitInfo;
        this.newElements = newElements;
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[][] tokens, boolean onDemand) {
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        if (parentHandle.getElementType() != 5) {
            Assert.isTrue((boolean)false);
        }
        IJavaScriptUnit parentCU = (IJavaScriptUnit)((Object)parentHandle);
        ImportContainer importContainer = (ImportContainer)parentCU.getImportContainer();
        if (this.importContainerInfo == null) {
            this.importContainerInfo = new JavaElementInfo();
            JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
            this.addToChildren(parentInfo, importContainer);
            this.newElements.put(importContainer, this.importContainerInfo);
        }
        String elementName = JavaModelManager.getJavaModelManager().intern(new String(CharOperation.concatWith(tokens, '.')));
        ImportDeclaration handle = new ImportDeclaration(importContainer, elementName, onDemand);
        this.resolveDuplicates(handle);
        ImportDeclarationElementInfo info = new ImportDeclarationElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        this.addToChildren(this.importContainerInfo, handle);
        this.newElements.put(handle, info);
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptProblem(CategorizedProblem problem) {
        if ((problem.getID() & 0x40000000) != 0) {
            this.hasSyntaxErrors = true;
        }
    }

    private void addToChildren(JavaElementInfo parentInfo, JavaElement handle) {
        ArrayList<JavaElement> childrenList = (ArrayList<JavaElement>)this.children.get(parentInfo);
        if (childrenList == null) {
            childrenList = new ArrayList<JavaElement>();
            this.children.put(parentInfo, childrenList);
        }
        childrenList.add(handle);
    }

    static String[] convertTypeNamesToSigs(char[][] typeNames) {
        if (typeNames == null) {
            return CharOperation.NO_STRINGS;
        }
        int n = typeNames.length;
        if (n == 0) {
            return CharOperation.NO_STRINGS;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        String[] typeSigs = new String[n];
        int i = 0;
        while (i < n) {
            typeSigs[i] = manager.intern(Signature.createTypeSignature(typeNames[i], false));
            ++i;
        }
        return typeSigs;
    }

    public void enterCompilationUnit() {
        this.infoStack = new Stack();
        this.children = new HashMap();
        this.handleStack = new Stack();
        this.infoStack.push(this.unitInfo);
        this.handleStack.push(this.unit);
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        this.enterMethod(methodInfo);
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        SourceField handle = null;
        if (parentHandle.getElementType() == 7 || parentHandle.getElementType() == 5 || parentHandle.getElementType() == 6 || parentHandle.getElementType() == 9) {
            String fieldName = JavaModelManager.getJavaModelManager().intern(new String(fieldInfo.name));
            handle = new SourceField(parentHandle, fieldName);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates(handle);
        SourceFieldElementInfo info = new SourceFieldElementInfo();
        info.setNameSourceStart(fieldInfo.nameSourceStart);
        info.setNameSourceEnd(fieldInfo.nameSourceEnd);
        info.setSourceRangeStart(fieldInfo.declarationStart);
        info.setFlags(fieldInfo.modifiers);
        if (fieldInfo.type != null) {
            char[] typeName = JavaModelManager.getJavaModelManager().intern(fieldInfo.type);
            info.setTypeName(typeName);
        }
        this.addToChildren(parentInfo, handle);
        if (parentInfo instanceof CompilationUnitElementInfo) {
            CompilationUnitElementInfo compilationUnitInfo = (CompilationUnitElementInfo)parentInfo;
            compilationUnitInfo.addCategories(handle, fieldInfo.categories);
        }
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        Initializer handle = null;
        if (parentHandle.getElementType() == 7) {
            handle = new Initializer(parentHandle, 1);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates(handle);
        InitializerElementInfo info = new InitializerElementInfo();
        info.setSourceRangeStart(declarationSourceStart);
        info.setFlags(modifiers);
        this.addToChildren(parentInfo, handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        SourceMethod handle = null;
        if (methodInfo.parameterTypes == null) {
            methodInfo.parameterTypes = CharOperation.NO_CHAR_CHAR;
        }
        if (methodInfo.parameterNames == null) {
            methodInfo.parameterNames = CharOperation.NO_CHAR_CHAR;
        }
        String[] parameterTypeSigs = CompilationUnitStructureRequestor.convertTypeNamesToSigs(methodInfo.parameterTypes);
        if (parentHandle.getElementType() == 7 || parentHandle.getElementType() == 5 || parentHandle.getElementType() == 6 || parentHandle.getElementType() == 9 || parentHandle.getElementType() == 8) {
            char[] cs = methodInfo.name != null ? methodInfo.name : CharOperation.concat(IInferEngine.ANONYMOUS_PREFIX, IInferEngine.ANONYMOUS_CLASS_ID);
            String selector = JavaModelManager.getJavaModelManager().intern(new String(cs));
            handle = new SourceMethod(parentHandle, selector, parameterTypeSigs);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.resolveDuplicates(handle);
        SourceMethodElementInfo info = methodInfo.isConstructor ? new SourceConstructorInfo() : new SourceMethodInfo();
        info.setSourceRangeStart(methodInfo.declarationStart);
        int flags = methodInfo.modifiers;
        info.setNameSourceStart(methodInfo.nameSourceStart);
        info.setNameSourceEnd(methodInfo.nameSourceEnd);
        info.setFlags(flags);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        char[][] parameterNames = methodInfo.parameterNames;
        int i = 0;
        int length = parameterNames.length;
        while (i < length) {
            parameterNames[i] = manager.intern(parameterNames[i]);
            ++i;
        }
        info.setArgumentNames(parameterNames);
        char[] returnType = methodInfo.returnType == null ? null : manager.intern(methodInfo.returnType);
        info.setReturnType(returnType);
        this.addToChildren(parentInfo, handle);
        if (parentInfo instanceof CompilationUnitElementInfo) {
            CompilationUnitElementInfo compilationUnitInfo = (CompilationUnitElementInfo)parentInfo;
            compilationUnitInfo.addCategories(handle, methodInfo.categories);
        }
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        String nameString = new String(typeInfo.name);
        while (typeInfo.isIndexed && !(parentHandle instanceof IJavaScriptUnit)) {
            parentHandle = parentHandle.parent;
            if (parentHandle != null) continue;
            parentHandle = (JavaElement)this.handleStack.peek();
            break;
        }
        SourceType handle = new SourceType(parentHandle, nameString, typeInfo.anonymousMember);
        this.resolveDuplicates(handle);
        SourceTypeElementInfo info = new SourceTypeElementInfo(parentHandle instanceof ClassFile, typeInfo.anonymousMember);
        info.setHandle(handle);
        info.setSourceRangeStart(typeInfo.declarationStart);
        info.setFlags(typeInfo.modifiers);
        info.setNameSourceStart(typeInfo.nameSourceStart);
        info.setNameSourceEnd(typeInfo.nameSourceEnd);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        char[] superclass = typeInfo.superclass;
        info.setSuperclassName(superclass == null ? null : manager.intern(superclass));
        info.addCategories(handle, typeInfo.categories);
        if (parentHandle.getElementType() == 7) {
            ((SourceTypeElementInfo)parentInfo).addCategories(handle, typeInfo.categories);
        }
        this.addToChildren(parentInfo, handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void exitCompilationUnit(int declarationEnd) {
        if (this.importContainerInfo != null) {
            this.setChildren(this.importContainerInfo);
        }
        this.setChildren(this.unitInfo);
        this.unitInfo.setSourceLength(declarationEnd + 1);
        this.unitInfo.setIsStructureKnown(!this.hasSyntaxErrors);
    }

    public void exitConstructor(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationSourceEnd);
        this.setChildren(info);
        this.handleStack.pop();
    }

    public void exitInitializer(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void exitMember(int declarationEnd) {
        SourceRefElementInfo info = (SourceRefElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationEnd);
        this.setChildren(info);
        this.handleStack.pop();
    }

    public void exitMethod(int declarationEnd, int defaultValueStart, int defaultValueEnd) {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationEnd);
        this.setChildren(info);
        this.handleStack.pop();
    }

    public void exitType(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void resolveDuplicates(SourceRefElement handle) {
        while (this.newElements.containsKey(handle)) {
            ++handle.occurrenceCount;
        }
    }

    private void setChildren(JavaElementInfo info) {
        ArrayList childrenList = (ArrayList)this.children.get(info);
        if (childrenList != null) {
            int length = childrenList.size();
            IJavaScriptElement[] elements = new IJavaScriptElement[length];
            childrenList.toArray(elements);
            info.children = elements;
        }
    }
}

