/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.infer;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.infer.DefaultInferrenceProvider;
import org.eclipse.wst.jsdt.core.infer.IInferEngine;
import org.eclipse.wst.jsdt.core.infer.IInferenceFile;
import org.eclipse.wst.jsdt.core.infer.InferrenceProvider;
import org.eclipse.wst.jsdt.core.infer.InferrenceSupportExtension;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class InferrenceManager {
    private static final boolean _debugInfer = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.core/debug/inferEngine"));
    public static final String EXTENSION_POINT = "inferrenceSupport";
    protected static final String TAG_INFERENCE_PROVIDER = "inferenceProvider";
    protected static final String ATTR_INFERENGINE_CLASS = "class";
    private static InferrenceManager instance = null;
    private InferrenceSupportExtension[] extensions;

    public static InferrenceManager getInstance() {
        if (instance == null) {
            instance = new InferrenceManager();
        }
        return instance;
    }

    public InferrenceProvider[] getInferenceProviders() {
        if (this.extensions == null) {
            this.loadInferenceExtensions();
        }
        ArrayList<InferrenceProvider> extProviders = new ArrayList<InferrenceProvider>();
        extProviders.add(new DefaultInferrenceProvider());
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].inferProvider != null) {
                extProviders.add(this.extensions[i].inferProvider);
            }
            ++i;
        }
        return extProviders.toArray(new InferrenceProvider[extProviders.size()]);
    }

    public InferrenceProvider[] getInferenceProviders(IInferenceFile script) {
        ArrayList<InferrenceProvider> proposedProviders = new ArrayList<InferrenceProvider>();
        InferrenceProvider[] inferenceProviders = this.getInferenceProviders();
        if (inferenceProviders.length == 1) {
            return new InferrenceProvider[]{inferenceProviders[0]};
        }
        if (inferenceProviders.length > 1) {
            proposedProviders.add(inferenceProviders[0]);
        }
        int i = 1;
        while (i < inferenceProviders.length) {
            if (inferenceProviders[i].getID().equals(script.getInferenceID())) {
                proposedProviders.clear();
                proposedProviders.add(inferenceProviders[0]);
                proposedProviders.add(inferenceProviders[i]);
                break;
            }
            int applies = 2;
            try {
                applies = inferenceProviders[i].applysTo(script);
            }
            catch (Exception e) {
                Util.log(e, "exception in inference provider " + inferenceProviders[i].getID());
            }
            switch (applies) {
                case 3: {
                    proposedProviders.add(inferenceProviders[i]);
                    break;
                }
                case 1: {
                    proposedProviders.clear();
                    proposedProviders.add(inferenceProviders[i]);
                    return proposedProviders.toArray(new InferrenceProvider[proposedProviders.size()]);
                }
            }
            ++i;
        }
        if (_debugInfer) {
            String proposedProvidersString = "";
            Iterator providers = proposedProviders.iterator();
            while (providers.hasNext()) {
                proposedProvidersString = String.valueOf(proposedProvidersString) + ((InferrenceProvider)providers.next()).getID().toString() + ", ";
            }
            Logger.log(201, "Proposed Inference Providers: " + proposedProvidersString);
        }
        return proposedProviders.toArray(new InferrenceProvider[proposedProviders.size()]);
    }

    public IInferEngine[] getInferenceEngines(CompilationUnitDeclaration script) {
        ArrayList<IInferEngine> proposedEngines = new ArrayList<IInferEngine>();
        InferrenceProvider[] inferenceProviders = this.getInferenceProviders(script);
        int i = 0;
        while (i < inferenceProviders.length) {
            proposedEngines.add(inferenceProviders[i].getInferEngine());
            ++i;
        }
        return proposedEngines.toArray(new IInferEngine[proposedEngines.size()]);
    }

    protected void loadInferenceExtensions() {
        IExtensionPoint point;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<InferrenceSupportExtension> extList = new ArrayList<InferrenceSupportExtension>();
        if (registry != null && (point = registry.getExtensionPoint("org.eclipse.wst.jsdt.core", EXTENSION_POINT)) != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        InferrenceProvider inferProvider = null;
                        if (elements[j].getName().equals(TAG_INFERENCE_PROVIDER)) {
                            inferProvider = (InferrenceProvider)elements[j].createExecutableExtension(ATTR_INFERENGINE_CLASS);
                        }
                        InferrenceSupportExtension inferenceSupport = new InferrenceSupportExtension();
                        inferenceSupport.inferProvider = inferProvider;
                        extList.add(inferenceSupport);
                    }
                    catch (CoreException e) {
                        Util.log(e, "Error in loading inference extension");
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.extensions = extList.toArray(new InferrenceSupportExtension[extList.size()]);
    }
}

