/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wpe;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.application.common.services.variables.IVariablesListener;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.wpe.WPELocalizationListener;
import oracle.eclipse.tools.webtier.ui.wpe.WPEUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;

public class WPEUpdateListener
implements IPartListener2 {
    private final Map<HTMLEditor, EditorEntry> _watchingParts = new HashMap<HTMLEditor, EditorEntry>();
    private final Map<IFile, VariableChangeListener> _varListeners = new HashMap<IFile, VariableChangeListener>();
    private final IDocumentLocalizationContext.ILocalizationListener _listener = new WPELocalizationListener(this);
    private final IAppLocalizer.IAppLocalizationChangeListener _appLocalizationListener = new AppLocalizationChangeListener();

    private static void refreshEditor(String sourceName, WPEUtil wpeUtil, EditorEntry editorEntry) {
        if (editorEntry.getEditor().getDesignerMode() != 3) {
            editorEntry.queueUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<HTMLEditor, EditorEntry> cloneWatchingParts() {
        Map<HTMLEditor, EditorEntry> map = this._watchingParts;
        synchronized (map) {
            return (Map)((HashMap)this._watchingParts).clone();
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        if (partRef instanceof IEditorReference) {
            this.maybeAdd((IEditorReference)partRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeAdd(IEditorReference editorReference) {
        IDocument doc;
        HTMLEditor editor = this.extractEditor((IWorkbenchPartReference)editorReference);
        if (editor != null && (doc = this.getDocument(editor)) != null) {
            IAppLocalizer appLocalizer;
            IDocumentLocalizationContext context = (IDocumentLocalizationContext)doc.getAdapter(IDocumentLocalizationContext.class);
            if (context != null) {
                context.addListener(this._listener);
            }
            if ((appLocalizer = (IAppLocalizer)doc.getProject().getAppService(IAppLocalizer.class)) != null) {
                appLocalizer.addListener(this._appLocalizationListener);
            }
            EditorEntry editorEntry = new EditorEntry(editor, doc.getFile());
            VariableChangeListener varChangeListener = new VariableChangeListener(editorEntry);
            this._varListeners.put(doc.getFile(), varChangeListener);
            VariablesController.getInstance().addListener((IVariablesListener)varChangeListener, doc.getFile());
            Map<HTMLEditor, EditorEntry> map = this._watchingParts;
            synchronized (map) {
                this._watchingParts.put(editor, editorEntry);
            }
            WPEUpdateListener.refreshEditor("maybeAdd", new WPEUtil(), editorEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partClosed(IWorkbenchPartReference partRef) {
        HTMLEditor editor = this.extractEditor(partRef);
        if (editor != null) {
            VariableChangeListener varChangeListener;
            IFile file;
            IDocumentLocalizationContext context;
            IDocument doc = this.getDocument(editor);
            if (doc != null && (context = (IDocumentLocalizationContext)doc.getAdapter(IDocumentLocalizationContext.class)) != null) {
                context.removeListener(this._listener);
            }
            if ((file = this.getFile(editor)) != null && (varChangeListener = this._varListeners.remove(file)) != null) {
                varChangeListener.dispose();
                VariablesController.getInstance().removeListener((IVariablesListener)varChangeListener, file);
            }
            EditorEntry removed = null;
            Map<HTMLEditor, EditorEntry> map = this._watchingParts;
            synchronized (map) {
                removed = this._watchingParts.remove(editor);
            }
            if (removed == null) {
                LoggingService.logWarning((Plugin)Activator.getDefault(), (String)("Failed to remove for part: " + editor.toString()));
            } else {
                removed.dispose();
            }
        }
    }

    private HTMLEditor extractEditor(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof HTMLEditor) {
            return (HTMLEditor)part;
        }
        return null;
    }

    private IDocument getDocument(HTMLEditor editor) {
        IFile file = this.getFile(editor);
        if (file != null && file.exists()) {
            return (IDocument)file.getAdapter(IDocument.class);
        }
        return null;
    }

    private IFile getFile(HTMLEditor editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partInputChanged(IWorkbenchPartReference partRef) {
        HTMLEditor editor = this.extractEditor(partRef);
        if (editor != null) {
            IFile newFile;
            IFile oldFile;
            EditorEntry entry = null;
            Map<HTMLEditor, EditorEntry> map = this._watchingParts;
            synchronized (map) {
                entry = this._watchingParts.get(editor);
            }
            if (entry != null && !(oldFile = entry.getFile()).equals((Object)(newFile = this.getFile(editor)))) {
                VariableChangeListener listener = this._varListeners.remove(oldFile);
                if (listener != null) {
                    listener.dispose();
                    VariablesController.getInstance().removeListener((IVariablesListener)listener, oldFile);
                }
                entry.setFile(newFile);
                listener = new VariableChangeListener(entry);
                VariablesController.getInstance().addListener((IVariablesListener)listener, newFile);
                this._varListeners.put(newFile, listener);
            }
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    private final class AppLocalizationChangeListener
    implements IAppLocalizer.IAppLocalizationChangeListener {
        private AppLocalizationChangeListener() {
        }

        public void changeOccurred(IAppLocalizer.AppLocalizationChangeEvent event) {
            if (event.getChangeType() == IAppLocalizer.AppLocalizationChangeEvent.ChangeType.PROPERTY_FILE_CHANGED) {
                WPEUtil wpeUtil = new WPEUtil();
                for (Map.Entry<HTMLEditor, EditorEntry> mapEntry : WPEUpdateListener.this.cloneWatchingParts().entrySet()) {
                    EditorEntry editorEntry = mapEntry.getValue();
                    IFile file = wpeUtil.getEditorInput((IEditorPart)editorEntry.getEditor());
                    if (file == null || !file.exists() || !file.getProject().equals((Object)event.getFileEvent().getChangedResource().getProject())) continue;
                    WPEUpdateListener.refreshEditor("Localization update", wpeUtil, editorEntry);
                }
            }
        }
    }

    static class EditorEntry {
        private HTMLEditor _editor;
        private IFile _file;
        private final AtomicBoolean _reentrancyGuard;
        private final AtomicBoolean _isDisposed = new AtomicBoolean(false);
        private final AtomicInteger _pendingUpdates = new AtomicInteger(0);
        private final Runnable _updateRunnable;

        public EditorEntry(HTMLEditor editor, IFile file) {
            this._editor = editor;
            this._file = file;
            this._reentrancyGuard = new AtomicBoolean(false);
            this._updateRunnable = new UIUpdateRunnable(this, new WPEUtil(), "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final HTMLEditor getEditor() {
            EditorEntry editorEntry = this;
            synchronized (editorEntry) {
                return this._editor;
            }
        }

        public void queueUpdate() {
            if (this._pendingUpdates.compareAndSet(0, 1)) {
                Thread delayedUpdate = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(30000L);
                            EditorEntry.this._pendingUpdates.getAndSet(0);
                            Display display = PlatformUI.getWorkbench().getDisplay();
                            if (display != null && !display.isDisposed()) {
                                display.asyncExec(EditorEntry.this._updateRunnable);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.interrupted();
                        }
                    }
                });
                delayedUpdate.start();
            } else {
                this._pendingUpdates.incrementAndGet();
            }
        }

        public final synchronized IFile getFile() {
            return this._file;
        }

        public final synchronized void setFile(IFile file) {
            this._file = file;
        }

        public final AtomicBoolean getReentrancyGuard() {
            return this._reentrancyGuard;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object obj) {
            EditorEntry editorEntry = this;
            synchronized (editorEntry) {
                return obj == this._editor;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            EditorEntry editorEntry = this;
            synchronized (editorEntry) {
                return this._editor.hashCode();
            }
        }

        public boolean isDisposed() {
            return this._isDisposed.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            if (this._isDisposed.compareAndSet(false, true)) {
                EditorEntry editorEntry = this;
                synchronized (editorEntry) {
                    this._editor = null;
                }
            }
        }
    }

    private static final class UIUpdateRunnable
    implements Runnable {
        private final EditorEntry editorEntry;
        private final WPEUtil wpeUtil;
        private final String sourceName;

        private UIUpdateRunnable(EditorEntry editorEntry, WPEUtil wpeUtil, String sourceName) {
            this.editorEntry = editorEntry;
            this.wpeUtil = wpeUtil;
            this.sourceName = sourceName;
        }

        @Override
        public void run() {
            if (this.editorEntry.getFile().isAccessible() && this.editorEntry.getReentrancyGuard().compareAndSet(false, true) && !this.editorEntry.isDisposed()) {
                try {
                    System.out.println(this.sourceName);
                    HTMLEditor editorPart = this.editorEntry.getEditor();
                    if (editorPart != null) {
                        this.wpeUtil.refreshWPEDesignPane((IEditorPart)editorPart);
                    }
                }
                finally {
                    this.editorEntry.getReentrancyGuard().set(false);
                }
            }
        }
    }

    private final class VariableChangeListener
    implements IVariablesListener {
        private final AtomicBoolean _isDisposed = new AtomicBoolean(false);
        private EditorEntry _editorEntry;

        public VariableChangeListener(EditorEntry editorEntry) {
            this._editorEntry = editorEntry;
        }

        public void refresh(IVariablesListener.VariableChangeEvent event) {
            if (!(event.isCauseOnly(IVariablesListener.VariableChangeEvent.Cause.REFERENCE) && event.getContext().getType() == 1 || this._isDisposed.get() || this.getEntry().isDisposed())) {
                WPEUtil wpeUtil = new WPEUtil();
                WPEUpdateListener.refreshEditor("Variable change update", wpeUtil, this.getEntry());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EditorEntry getEntry() {
            VariableChangeListener variableChangeListener = this;
            synchronized (variableChangeListener) {
                return this._editorEntry;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            if (this._isDisposed.compareAndSet(false, true)) {
                VariableChangeListener variableChangeListener = this;
                synchronized (variableChangeListener) {
                    this._editorEntry = null;
                }
            }
        }
    }
}

