/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wizards.existing;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ProjectFromExistingSourceWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;

public class ProjectBuildPathPage
extends JavaCapabilityConfigurationPage {
    public void configureJavaProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)10);
            IWorkspaceRoot workspaceRoot = JavaPlugin.getWorkspace().getRoot();
            this.addJavaNatureIfNecessary(this.getJavaProject().getProject());
            IResource res = workspaceRoot.findMember(this.getJavaProject().getOutputLocation());
            File file = new File(this.getJavaProject().getResource().getLocation().toFile(), ".classpath");
            if (res != null && res.exists() && res.isAccessible() && !file.exists()) {
                BuildPathsBlock.removeOldClassfiles((IResource)res);
                res.delete(true, null);
            }
            super.configureJavaProject(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)5));
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            try {
                ((ProjectFromExistingSourceWizard)this.getWizard()).ensureProject(this.getShell());
            }
            catch (InvocationTargetException e) {
                String message = Messages.ProjectBuildPathPage_newProject_create_failed_text;
                DialogService.showErrorDialog((String)message, (Throwable)e.getTargetException());
            }
            catch (InterruptedException e) {
                String message = Messages.ProjectBuildPathPage_newProject_create_failed_text;
                DialogService.showErrorDialog((String)message, (Throwable)e);
            }
        }
        super.setVisible(visible);
    }

    private void addJavaNatureIfNecessary(IProject project) throws CoreException {
        if (project != null && !project.hasNature("org.eclipse.jdt.core.javanature")) {
            IProjectDescription projDesc = project.getDescription();
            String[] natures = projDesc.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "org.eclipse.jdt.core.javanature";
            projDesc.setNatureIds(newNatures);
            project.setDescription(projDesc, null);
        }
    }
}

