/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wizards.existing;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ProjectBuildPathPage;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ProjectFromExistingSourceDataModelOperation;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EnsureProjectRunnableWithProgress
implements IRunnableWithProgress {
    private IDataModel dataModel;

    public EnsureProjectRunnableWithProgress(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void run(IProgressMonitor progressMon) throws InvocationTargetException, InterruptedException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
                    EnsureProjectRunnableWithProgress.this.cleanupCreatedProject(EnsureProjectRunnableWithProgress.this.dataModel, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                    if (!EnsureProjectRunnableWithProgress.this.dataModel.isPropertySet("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT")) {
                        EnsureProjectRunnableWithProgress.this.createProject(EnsureProjectRunnableWithProgress.this.dataModel, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
                    }
                }
                finally {
                    ProgressMonitorUtil.done((IProgressMonitor)monitor);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, progressMon);
        }
        catch (CoreException ce) {
            throw new InvocationTargetException(ce);
        }
    }

    void createProject(IDataModel model, IProgressMonitor monitor) throws CoreException {
        try {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)Messages.ProjectFromExistingSourceWizard_newProject_creatingProject, (int)2);
            String projectName = model.getStringProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_NAME");
            File projectDir = (File)model.getProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_PATH_FILE");
            ArrayList<File> rootList = new ArrayList<File>();
            EnsureProjectRunnableWithProgress.getWebAppRoots(projectDir, rootList);
            File[] roots = rootList.toArray(new File[rootList.size()]);
            String relativeRootDir = roots.length == 1 ? EnsureProjectRunnableWithProgress.getRelativeRoot(projectDir, roots[0]) : null;
            Project webProject = null;
            try {
                webProject = ProjectFromExistingSourceDataModelOperation.EclipseNewProjectController.createProject(projectName, projectDir, relativeRootDir, (ProjectBuildPathPage)((Object)model.getProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_BUILD_PATH_PAGE")), true);
            }
            catch (IOException ioe) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.ProjectFromExistingSourceWizard_newProject_create_failed, (Throwable)ioe));
            }
            catch (CoreException ce) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.ProjectFromExistingSourceWizard_newProject_create_failed, (Throwable)ce));
            }
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            if (webProject == null) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.ProjectFromExistingSourceWizard_newProject_create_failed));
            }
            model.setProperty("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT", (Object)webProject);
            model.setProperty("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT_NAME", model.getProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_NAME"));
            model.setProperty("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT_PATH", model.getProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_PATH"));
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    void cleanupCreatedProject(IDataModel model, IProgressMonitor monitor) {
        try {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)Messages.ProjectFromExistingSourceWizard_newProject_cleaningUp, (int)1);
            if (this.projectNeedsDelete(model)) {
                ProjectFromExistingSourceDataModelOperation.EclipseNewProjectController.deleteProject((Project)model.getProperty("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT"));
                model.setProperty("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT", null);
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private boolean projectNeedsDelete(IDataModel model) {
        return model.isPropertySet("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT") && (!model.isPropertySet("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT") || !model.isPropertySet("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT_PATH") || !model.getProperty("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT_PATH").equals(model.getProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_PATH")) || !model.isPropertySet("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT_NAME") || !model.getProperty("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT_NAME").equals(model.getProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_NAME")));
    }

    public static void getWebAppRoots(File root, List<File> result) {
        boolean isWebAppRoot = new File(root, "WEB-INF/web.xml").exists();
        if (isWebAppRoot) {
            result.add(root);
            return;
        }
        File[] files = root.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    EnsureProjectRunnableWithProgress.getWebAppRoots(file, result);
                }
                ++n2;
            }
        }
    }

    public static String getRelativeRoot(File projectDir, File rootDir) {
        String rootDirStr;
        String relativeRoot = null;
        String projectDirStr = projectDir.getAbsolutePath();
        if (projectDirStr.equals(rootDirStr = rootDir.getAbsolutePath())) {
            relativeRoot = "./";
        } else if (rootDirStr.startsWith(projectDirStr)) {
            relativeRoot = rootDirStr.substring(projectDirStr.length());
        }
        return relativeRoot;
    }
}

