/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wizards.existing;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.wizards.existing.EJBProjectConfigurator;
import oracle.eclipse.tools.webtier.ui.wizards.existing.WlsRuntimeUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class EJBProjectConverter {
    private static final String WLS_EJB_FACET_ID = "wls.ejb";
    private EJBProjectConfigurator mConfigurator;

    public EJBProjectConverter(EJBProjectConfigurator config) {
        this.mConfigurator = config;
    }

    public boolean convert(IProgressMonitor monitor) throws Exception {
        IStatus checkStatus;
        IRuntime runtime;
        Object ejbConfig;
        IFacetedProject.Action unInstall;
        Object utilConfig;
        IActionDefinition def;
        Project ejbProject = this.mConfigurator.getEJBProject();
        boolean hasEJBProject = ejbProject != null;
        File prjFolder = this.mConfigurator.getProjectLocation();
        if (!hasEJBProject) {
            return false;
        }
        IProjectFacetVersion utilFacetVersion = this.mConfigurator.getUtilModuleFacetVersion();
        IProjectFacetVersion ejbFacetVersion = this.mConfigurator.getEJBModuleFacetVersion();
        IProjectFacetVersion wlsUtilModuleFacetVersion = this.mConfigurator.getWlsUtilModuleFacetVersion();
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)ejbProject.getEclipseProject(), (boolean)true, (IProgressMonitor)ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
        if (ejbFacetVersion == null || facetedProject.hasProjectFacet(ejbFacetVersion.getProjectFacet())) {
            return false;
        }
        IFolder settingsFolder = ejbProject.getEclipseProject().getFolder(".settings");
        if (!settingsFolder.exists() && new File(prjFolder, ".settings").exists()) {
            try {
                settingsFolder.refreshLocal(0, null);
            }
            catch (Throwable throwable) {}
        }
        HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
        if (wlsUtilModuleFacetVersion != null && facetedProject.hasProjectFacet(wlsUtilModuleFacetVersion.getProjectFacet())) {
            def = wlsUtilModuleFacetVersion.getActionDefinition(facetedProject.getProjectFacets(), IFacetedProject.Action.Type.UNINSTALL);
            utilConfig = def.createConfigObject();
            unInstall = new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, wlsUtilModuleFacetVersion, utilConfig);
            actions.add(unInstall);
        }
        if (utilFacetVersion != null && facetedProject.hasProjectFacet(utilFacetVersion.getProjectFacet())) {
            def = utilFacetVersion.getActionDefinition(facetedProject.getProjectFacets(), IFacetedProject.Action.Type.UNINSTALL);
            utilConfig = def.createConfigObject();
            unInstall = new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, utilFacetVersion, utilConfig);
            actions.add(unInstall);
        }
        if ((ejbConfig = (def = ejbFacetVersion.getActionDefinition(facetedProject.getProjectFacets(), IFacetedProject.Action.Type.INSTALL)).createConfigObject()) instanceof IDataModel) {
            IProject earProject = this.mConfigurator.getEarProject();
            if (earProject != null) {
                EJBProjectConverter.earPreDeploymentAssemblyRemoval(earProject, ejbProject.getEclipseProject(), monitor);
                IFacetedProjectWorkingCopy fpjwc = facetedProject.createWorkingCopy();
                ((IDataModel)ejbConfig).setProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY", (Object)fpjwc);
                ((IDataModel)ejbConfig).setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", true);
                ((IDataModel)ejbConfig).setStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", earProject.getName());
                ((IDataModel)ejbConfig).setBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", false);
                ((IDataModel)ejbConfig).setStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_NAME ", "");
            } else {
                ((IDataModel)ejbConfig).setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
            }
        }
        if (!facetedProject.hasProjectFacet(ejbFacetVersion.getProjectFacet())) {
            IFacetedProject.Action ejbFacetInstallAction = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, ejbFacetVersion, ejbConfig);
            actions.add(ejbFacetInstallAction);
            fixedFacets.add(ejbFacetVersion.getProjectFacet());
        }
        if ((runtime = this.mConfigurator.getRuntime()) != null && WlsRuntimeUtil.isWlsRuntime(runtime)) {
            try {
                IProjectFacetVersion latestSupportedWlsEJBFacetVersion;
                IProjectFacet wlsEJBFacet = ProjectFacetsManager.getProjectFacet((String)WLS_EJB_FACET_ID);
                if (!facetedProject.hasProjectFacet(wlsEJBFacet) && (latestSupportedWlsEJBFacetVersion = wlsEJBFacet.getLatestSupportedVersion(runtime)) != null) {
                    IFacetedProject.Action ejbFacetInstallAction = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, latestSupportedWlsEJBFacetVersion, null);
                    actions.add(ejbFacetInstallAction);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (CoreException coreException) {}
        }
        if (!(checkStatus = ProjectFacetsManager.check((Set)facetedProject.getProjectFacets(), actions)).isOK()) {
            IStatus srcStatus = checkStatus;
            if (checkStatus.isMultiStatus()) {
                srcStatus = checkStatus.getChildren()[0];
            }
            Status thrownStatus = new Status(srcStatus.getSeverity(), srcStatus.getPlugin(), 10101, srcStatus.getMessage(), checkStatus.getException());
            throw new CoreException((IStatus)thrownStatus);
        }
        facetedProject.modify(actions, (IProgressMonitor)new NullProgressMonitor());
        if (fixedFacets.size() > 0) {
            fixedFacets.addAll(facetedProject.getFixedProjectFacets());
            facetedProject.setFixedProjectFacets(fixedFacets);
        }
        return true;
    }

    public static boolean convert(final EJBProjectConfigurator config, IRunnableContext context, final String taskName) throws CoreException {
        EJBProjectConverter.preverify(config);
        final boolean[] results = new boolean[1];
        final IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.setTaskName(taskName);
                results[0] = EJBProjectConverter.convert(config, monitor);
            }
        };
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            context.run(false, false, op);
        }
        catch (Throwable e) {
            String message = e.getLocalizedMessage();
            Status status = new Status(4, "oracle.eclipse.tools.webtier.ui", -1, message == null ? "" : message, e);
            throw new CoreException((IStatus)status);
        }
        return results[0];
    }

    private static void preverify(EJBProjectConfigurator config) throws CoreException {
        File dotproject = new File(config.getProjectLocation(), ".project");
        File dotclasspath = new File(config.getProjectLocation(), ".classpath");
        if (dotproject.exists() && !dotproject.canWrite()) {
            Status status = new Status(4, "oracle.eclipse.tools.webtier.ui", -1, Messages.DynamicWebProjectConverter_dotProject_readOnly, null);
            throw new CoreException((IStatus)status);
        }
        if (dotclasspath.exists() && !dotclasspath.canWrite()) {
            Status status = new Status(4, "oracle.eclipse.tools.webtier.ui", -1, Messages.DynamicWebProjectConverter_dotClasspath_readOnly, null);
            throw new CoreException((IStatus)status);
        }
    }

    public static boolean convert(EJBProjectConfigurator config, IProgressMonitor monitor) throws CoreException {
        EJBProjectConverter converter = new EJBProjectConverter(config);
        monitor.beginTask("", 10);
        boolean result = false;
        try {
            try {
                result = converter.convert(monitor);
            }
            catch (Exception e) {
                if (e instanceof CoreException) {
                    throw (CoreException)((Object)e);
                }
                Status status = new Status(2, "oracle.eclipse.tools.webtier.ui", -1, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    public static void earPreDeploymentAssemblyRemoval(IProject earProject, IProject targetProject, IProgressMonitor monitor) throws ExecutionException {
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        IVirtualComponent targetComp = ComponentCore.createComponent((IProject)targetProject);
        List<IProject> earProjects = EJBProjectConverter.getEARProjectReferences(earProject);
        if (!EJBProjectConverter.referencedByEAR(earProjects, targetProject)) {
            return;
        }
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComp);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modHandlesList.add(targetComp);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
        model.getDefaultOperation().execute(monitor, null);
    }

    protected static boolean referencedByEAR(List<IProject> earProjects, IProject project) {
        for (IProject earProject : earProjects) {
            if (!earProject.equals((Object)project)) continue;
            return true;
        }
        return false;
    }

    public static final List<IProject> getEARProjectReferences(IProject earProject) {
        IVirtualReference[] refComponents;
        EJBProjectConverter.validProject(earProject);
        ArrayList<IProject> result = new ArrayList<IProject>();
        IVirtualComponent component = ComponentCore.createComponent((IProject)earProject);
        IVirtualReference[] iVirtualReferenceArray = refComponents = component.getReferences();
        int n = refComponents.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            IVirtualComponent comp = ref.getReferencedComponent();
            if (comp != null && comp.getProject() != null) {
                result.add(comp.getProject());
            }
            ++n2;
        }
        return Collections.unmodifiableList(result);
    }

    protected static boolean validProject(IProject project) {
        return project != null && project.exists() && project.isOpen();
    }
}

