/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wizards.existing;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.project.Project;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.common.project.facet.core.internal.JavaFacetUtil;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class EJBProjectConfigurator {
    private String mCompilerCompliance;
    private final IDataModel mDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetProjectCreationDataModelProvider());
    private IRuntime mRuntime = null;
    private final Project _project;
    private final IProject _earProject;
    private static IGroup MODULES_GROUP = ProjectFacetsManager.getGroup((String)"modules");
    private static final String WLS_UTIL_FACET_ID = "wls.utility";

    public EJBProjectConfigurator(Project project) {
        this._project = project;
        this.mDataModel.setProperty("IProjectCreationPropertiesNew.PROJECT_NAME", (Object)this._project.getEclipseProject().getName());
        this._earProject = this.getReferenceEARProject(this._project.getEclipseProject());
        this.setRuntime(this.determineRuntime());
    }

    public Set<IProjectFacetVersion> getAdaptedFacetVersions() throws CoreException {
        IProjectFacetVersion javaFacet;
        HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
        IProjectFacetVersion ejbFacet = this.getEJBModuleFacetVersion();
        if (ejbFacet != null) {
            facets.add(ejbFacet);
        }
        if ((javaFacet = this.getJavaFacetVersion()) != null) {
            facets.add(javaFacet);
        }
        return facets;
    }

    public IProjectFacetVersion getEJBModuleFacetVersion() throws CoreException {
        Set facets = ProjectFacetsManager.getProjectFacets();
        String ejbVersion = this.getEJBLatestVersion("3.0");
        for (IProjectFacet facet : facets) {
            String id = facet.getId();
            if (!id.equals("jst.ejb")) continue;
            Set versions = facet.getVersions();
            for (IProjectFacetVersion fv : versions) {
                String version = fv.getVersionString();
                if (!version.equals(ejbVersion)) continue;
                return fv;
            }
        }
        return null;
    }

    public IProjectFacetVersion getUtilModuleFacetVersion() {
        if (this._project.getEclipseProject() == null) {
            return null;
        }
        try {
            IFacetedProject fProject = ProjectFacetsManager.create((IProject)this._project.getEclipseProject());
            if (fProject != null) {
                return fProject.getProjectFacetVersion(ProjectFacetsManager.getProjectFacet((String)IJ2EEFacetConstants.UTILITY_FACET.getId()));
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public IProjectFacetVersion getWlsUtilModuleFacetVersion() {
        if (this._project.getEclipseProject() == null) {
            return null;
        }
        try {
            IFacetedProject fProject = ProjectFacetsManager.create((IProject)this._project.getEclipseProject());
            if (fProject != null) {
                return fProject.getProjectFacetVersion(ProjectFacetsManager.getProjectFacet((String)WLS_UTIL_FACET_ID));
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public IProjectFacetVersion getJavaFacetVersion() {
        if (this._project.getEclipseProject() == null) {
            return null;
        }
        String level = this.mCompilerCompliance != null ? this.mCompilerCompliance : JavaFacetUtil.getCompilerLevel((IProject)this._project.getEclipseProject());
        return JavaFacet.FACET.getVersion(level);
    }

    public File getProjectLocation() {
        return this._project.getEclipseProject().getLocation().toFile();
    }

    public IDataModel getDataModel() {
        return this.mDataModel;
    }

    public Project getEJBProject() {
        return this._project;
    }

    public void setRuntime(IRuntime runtime) {
        this.mRuntime = runtime;
    }

    public IRuntime getRuntime() {
        return this.mRuntime;
    }

    protected IProject getEarProject() {
        return this._earProject;
    }

    private IRuntime determineRuntime() {
        IFacetedProject earFacetedProject;
        block8: {
            IProject earProject;
            block7: {
                IFacetedProject facetedProject;
                block6: {
                    try {
                        facetedProject = ProjectFacetsManager.create((IProject)this._project.getEclipseProject());
                        if (facetedProject != null && this.hasModuleFacet((IFacetedProjectBase)facetedProject)) break block6;
                        return null;
                    }
                    catch (CoreException coreException) {
                        return null;
                    }
                }
                IRuntime runtime = facetedProject.getPrimaryRuntime();
                if (runtime != null) {
                    return runtime;
                }
                earProject = this.getEarProject();
                if (earProject != null) break block7;
                return null;
            }
            earFacetedProject = ProjectFacetsManager.create((IProject)earProject);
            if (earFacetedProject != null) break block8;
            return null;
        }
        return earFacetedProject.getPrimaryRuntime();
    }

    private String getEJBLatestVersion(String defVersion) throws CoreException {
        IProjectFacetVersion latestVersion;
        IProjectFacet ejbFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        if (this.getRuntime() != null && (latestVersion = ejbFacet.getLatestSupportedVersion(this.getRuntime())) != null) {
            return latestVersion.getVersionString();
        }
        return defVersion;
    }

    private boolean hasModuleFacet(IFacetedProjectBase fproj) {
        for (IProjectFacetVersion fv : fproj.getProjectFacets()) {
            if (!MODULES_GROUP.getMembers().contains(fv)) continue;
            return true;
        }
        return false;
    }

    private IProject getReferenceEARProject(IProject project) {
        try {
            int n;
            IProject[] referencingProjects;
            IModule[] modules = ServerUtil.getModules((String)"jst.ear");
            IProject[] iProjectArray = referencingProjects = project.getReferencingProjects();
            int n2 = referencingProjects.length;
            int n3 = 0;
            while (n3 < n2) {
                IProject refProject = iProjectArray[n3];
                IModule[] iModuleArray = modules;
                n = modules.length;
                int n4 = 0;
                while (n4 < n) {
                    IModule nextModule = iModuleArray[n4];
                    if (refProject.getName().equals(nextModule.getName())) {
                        return nextModule.getProject();
                    }
                    ++n4;
                }
                ++n3;
            }
            iProjectArray = modules;
            n2 = modules.length;
            n3 = 0;
            while (n3 < n2) {
                IProject[] prot;
                IProject nextModule = iProjectArray[n3];
                IProject[] iProjectArray2 = prot = nextModule.getProject().getReferencedProjects();
                int n5 = prot.length;
                n = 0;
                while (n < n5) {
                    IProject prt = iProjectArray2[n];
                    if (prt.getName().equals(project.getName())) {
                        return nextModule.getProject();
                    }
                    ++n;
                }
                ++n3;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }
}

