/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wizards.existing;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.wizards.existing.EJBProjectFromExistingDataModelOperation;
import oracle.eclipse.tools.webtier.ui.wizards.existing.IProjectFromExistingSourceDataModelProvider;
import oracle.eclipse.tools.webtier.ui.wizards.existing.ProjectFromExistingSourceDataModelOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class EJBFromExistingDataModelProvider
extends AbstractDataModelProvider
implements IProjectFromExistingSourceDataModelProvider {
    private static final Map<String, String> mComplianceLevelToUserStringMap;

    static {
        HashMap<String, String> modifiableComplianceLevelToUserStringMap = new HashMap<String, String>();
        modifiableComplianceLevelToUserStringMap.put("1.3", "1.3");
        modifiableComplianceLevelToUserStringMap.put("1.4", "1.4");
        modifiableComplianceLevelToUserStringMap.put("1.5", "5.0");
        modifiableComplianceLevelToUserStringMap.put("1.6", "6.0");
        mComplianceLevelToUserStringMap = Collections.unmodifiableMap(modifiableComplianceLevelToUserStringMap);
    }

    public IDataModelOperation getDefaultOperation() {
        return new EJBProjectFromExistingDataModelOperation(this.model);
    }

    public Object getDefaultProperty(String propertyName) {
        Object property = super.getDefaultProperty(propertyName);
        if (property != null) {
            return property;
        }
        if ("IProjectFromExistingSourceDataModelProperties.PROJECT_CONTEXT_ROOT".equals(propertyName)) {
            return "/";
        }
        if ("IProjectFromExistingSourceDataModelProperties.PROJECT_COMPILER_COMPLIANCE".equals(propertyName)) {
            return "1.5";
        }
        return null;
    }

    public Set<String> getPropertyNames() {
        HashSet<String> set = new HashSet<String>();
        set.add("IProjectFromExistingSourceDataModelProperties.TARGET_RUNTIME");
        set.add("IProjectFromExistingSourceDataModelProperties.PROJECT_CONTEXT_ROOT");
        set.add("IProjectFromExistingSourceDataModelProperties.PROJECT_NAME");
        set.add("IProjectFromExistingSourceDataModelProperties.PROJECT_PATH");
        set.add("IProjectFromExistingSourceDataModelProperties.PROJECT_PATH_FILE");
        set.add("IProjectFromExistingSourceDataModelProperties.PROJECT_COMPILER_COMPLIANCE");
        set.add("IProjectFromExistingSourceDataModelProperties.PROJECT_BUILD_PATH_PAGE");
        set.add("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT");
        set.add("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT_NAME");
        set.add("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT_PATH");
        set.add("IProjectFromExistingSourceDataModelProperties.WORKBENCH");
        return set;
    }

    public IStatus validate(String name) {
        String projectContextRoot;
        if ("IProjectFromExistingSourceDataModelProperties.PROJECT_NAME".equals(name)) {
            String projectName = this.getStringProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_NAME");
            if (projectName == null || projectName.length() == 0) {
                return new Status(4, "oracle.eclipse.tools.webtier.ui", -1, Messages.ProjectFromExistingSourceDataModelProvider_newProject_operation_validate_projectName, null);
            }
            if (!this.isPropertySet("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT") || !projectName.equals(this.getStringProperty("IProjectFromExistingSourceDataModelProperties.CREATED_PROJECT_NAME"))) {
                if (ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) {
                    return new Status(4, "oracle.eclipse.tools.webtier.ui", -1, Messages.ProjectFromExistingSourceDataModelProvider_newProject_locationPage_projectExists, null);
                }
                IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(projectName, 4);
                if (!nameStatus.isOK()) {
                    return nameStatus;
                }
                IStatus pathValidationStatus = this.validate("IProjectFromExistingSourceDataModelProperties.PROJECT_PATH_FILE");
                if (pathValidationStatus != null && !pathValidationStatus.isOK()) {
                    return nameStatus;
                }
            }
        } else if ("IProjectFromExistingSourceDataModelProperties.PROJECT_PATH_FILE".equals(name)) {
            File webXml;
            File projectPath = (File)this.getProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_PATH_FILE");
            if (projectPath == null || !projectPath.canRead() || !projectPath.isDirectory()) {
                return new Status(4, "oracle.eclipse.tools.webtier.ui", -1, Messages.ProjectFromExistingSourceDataModelProvider_newProject_operation_validate_projectLocation, null);
            }
            String pathStr = projectPath.getPath();
            if (!new Path("").isValidPath(pathStr)) {
                return new Status(4, "oracle.eclipse.tools.webtier.ui", -1, Messages.ProjectFromExistingSourceDataModelProvider_newProject_operation_validate_projectLocation, null);
            }
            Path projectIPath = new Path(pathStr);
            String projectName = this.getStringProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_NAME");
            IPath platformPath = Platform.getLocation();
            if (!platformPath.equals((Object)projectIPath.removeLastSegments(1)) || projectIPath.lastSegment() == null || !projectIPath.lastSegment().equals(projectName)) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                IStatus locationStatus = ResourcesPlugin.getWorkspace().validateProjectLocation(project, (IPath)projectIPath);
                if (!locationStatus.isOK()) {
                    return locationStatus;
                }
            }
            File dotProject = new File(projectPath, ".project");
            File dotClasspath = new File(projectPath, ".classpath");
            if (dotProject.exists() && dotClasspath.exists()) {
                return new Status(4, "oracle.eclipse.tools.webtier.ui", -1, Messages.ProjectFromExistingSourceDataModelProvider_newProject_operation_validate_projectLocationIsEclipse, null);
            }
            File webInf = new File(projectPath, "WEB-INF");
            if (webInf.exists() && webInf.isDirectory() && (webXml = new File(webInf, "web.xml")).exists()) {
                return new Status(4, "oracle.eclipse.tools.webtier.ui", -1, Messages.ProjectFromExistingSourceDataModelProvider_newProject_operation_validate_projectLocationWebContentAtRoot, null);
            }
        } else if ("IProjectFromExistingSourceDataModelProperties.PROJECT_CONTEXT_ROOT".equals(name) && ((projectContextRoot = this.getStringProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_CONTEXT_ROOT")) == null || projectContextRoot.length() == 0)) {
            return new Status(4, "oracle.eclipse.tools.webtier.ui", -1, Messages.ProjectFromExistingSourceDataModelProvider_newProject_operation_validate_contextRoot, null);
        }
        return super.validate(name);
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if ("IProjectFromExistingSourceDataModelProperties.TARGET_RUNTIME".equals(propertyName)) {
            IRuntime runtime = (IRuntime)this.getProperty(propertyName);
            if (runtime != null) {
                return new DataModelPropertyDescriptor((Object)runtime, runtime.getName());
            }
            return new DataModelPropertyDescriptor(null, WTPCommonPlugin.getResourceString((String)"44", null));
        }
        if ("IProjectFromExistingSourceDataModelProperties.PROJECT_COMPILER_COMPLIANCE".equals(propertyName)) {
            String realCompilerLevel = this.getStringProperty(propertyName);
            return new DataModelPropertyDescriptor((Object)realCompilerLevel, mComplianceLevelToUserStringMap.get(realCompilerLevel));
        }
        return super.getPropertyDescriptor(propertyName);
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("IProjectFromExistingSourceDataModelProperties.TARGET_RUNTIME".equals(propertyName)) {
            Set runtimes = RuntimeManager.getRuntimes();
            ArrayList<IRuntime> serverRuntimes = new ArrayList<IRuntime>();
            for (IRuntime runtime : runtimes) {
                if (RuntimeBridgeUtil.bridge((IRuntime)runtime) == null) continue;
                serverRuntimes.add(runtime);
            }
            DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[serverRuntimes.size() + 1];
            int i = 0;
            while (i < serverRuntimes.size()) {
                IRuntime runtime = (IRuntime)serverRuntimes.get(i);
                descriptors[i] = new DataModelPropertyDescriptor((Object)runtime, runtime.getName());
                ++i;
            }
            descriptors[descriptors.length - 1] = new DataModelPropertyDescriptor(null, WTPCommonPlugin.getResourceString((String)"44", null));
            return descriptors;
        }
        if ("IProjectFromExistingSourceDataModelProperties.PROJECT_COMPILER_COMPLIANCE".equals(propertyName)) {
            Set<String> compilerLevels = mComplianceLevelToUserStringMap.keySet();
            DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[compilerLevels.size()];
            int i = 0;
            for (String compilerLevel : compilerLevels) {
                descriptors[i++] = new DataModelPropertyDescriptor((Object)compilerLevel, mComplianceLevelToUserStringMap.get(compilerLevel));
            }
            return descriptors;
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        String contextRoot;
        if ("IProjectFromExistingSourceDataModelProperties.PROJECT_PATH".equals(propertyName)) {
            String projectPath = (String)propertyValue;
            if (projectPath != null && projectPath.trim().length() != 0) {
                this.setProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_NAME", this.nonExistingProjectName(new Path(projectPath).lastSegment()));
                this.setProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_PATH_FILE", new File(projectPath));
            }
        } else if ("IProjectFromExistingSourceDataModelProperties.PROJECT_NAME".equals(propertyName)) {
            String cleanedName;
            String projectName = (String)propertyValue;
            if (projectName != null && projectName.equals(cleanedName = projectName.trim())) {
                this.setProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_NAME", cleanedName);
            }
        } else if ("IProjectFromExistingSourceDataModelProperties.PROJECT_CONTEXT_ROOT".equals(propertyName) && (contextRoot = (String)propertyValue) != null) {
            String cleanedContextRoot = contextRoot.trim();
            if (cleanedContextRoot.length() == 0) {
                this.setProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_CONTEXT_ROOT", null);
            } else if (!contextRoot.equals(cleanedContextRoot)) {
                this.setProperty("IProjectFromExistingSourceDataModelProperties.PROJECT_CONTEXT_ROOT", cleanedContextRoot);
            }
        }
        return super.propertySet(propertyName, propertyValue);
    }

    String nonExistingProjectName(String projectName) {
        int i = 2;
        String result = projectName;
        while (ProjectFromExistingSourceDataModelOperation.EclipseNewProjectController.projectExists(result)) {
            result = String.valueOf(projectName) + '-' + i++;
        }
        return result;
    }
}

