/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.wizards.existing;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.PreferenceConstants;

public class ClassPathDetector
implements IResourceProxyVisitor {
    private boolean mFromTemplate;
    private HashMap mSourceFolders;
    private List mClassFiles;
    private HashSet mJARFiles;
    private IPath mWebRoot;
    private IProject fProject;
    private IPath fOutputLocation;
    private IClasspathEntry[] fResultClasspath;

    public ClassPathDetector(IProject project, String webRootURI, boolean fromTemplate) throws CoreException {
        assert (project != null);
        this.fProject = project;
        if (webRootURI != null) {
            IPath projPath = project.getFullPath();
            this.mWebRoot = webRootURI.equals("./") ? projPath : projPath.append(String.valueOf(webRootURI) + "/");
        }
        this.mFromTemplate = fromTemplate;
        this.mSourceFolders = new HashMap();
        this.mJARFiles = new HashSet(10);
        this.mClassFiles = new ArrayList(100);
        project.accept((IResourceProxyVisitor)this, 0);
        this.fResultClasspath = null;
        this.fOutputLocation = null;
        this.detectClasspath();
    }

    private boolean isNested(IPath path, Iterator iter) {
        while (iter.hasNext()) {
            IPath other = (IPath)iter.next();
            if (!other.isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }

    private void detectClasspath() {
        ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
        this.detectSourceFolders(cpEntries);
        IPath outputLocation = null;
        outputLocation = this.mWebRoot != null && this.mSourceFolders.get(this.mWebRoot) == null ? this.mWebRoot.append("WEB-INF/classes") : this.fProject.getFullPath().append("build/classes");
        this.detectLibraries(cpEntries, outputLocation);
        if (cpEntries.isEmpty() && this.mClassFiles.isEmpty()) {
            return;
        }
        IClasspathEntry[] jreEntries = PreferenceConstants.getDefaultJRELibrary();
        int i = 0;
        while (i < jreEntries.length) {
            cpEntries.add(jreEntries[i]);
            ++i;
        }
        IClasspathEntry[] entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
        IJavaModelStatus jms = JavaConventions.validateClasspath((IJavaProject)JavaCore.create((IProject)this.fProject), (IClasspathEntry[])entries, (IPath)outputLocation);
        if (!jms.isOK()) {
            Activator.logError(MessageFormat.format(Messages.ClassPathDetector_validateClasspath_failed, this.fProject.getName(), jms), null);
            return;
        }
        this.fResultClasspath = entries;
        this.fOutputLocation = outputLocation;
    }

    private void detectLibraries(ArrayList cpEntries, IPath outputLocation) {
        Set sourceFolderSet = this.mSourceFolders.keySet();
        for (IPath path : this.mJARFiles) {
            if (this.isNested(path, sourceFolderSet.iterator()) || outputLocation != null && outputLocation.isPrefixOf(path)) continue;
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)path, null, null);
            cpEntries.add(entry);
        }
    }

    private void checkSourceFolder(IPath srcPath, List resEntries) {
        if (!this.fProject.exists(srcPath.removeFirstSegments(1))) {
            return;
        }
        IPath resourcesPath = null;
        IPath javaPath = srcPath.append("java/");
        if (this.fProject.exists(javaPath.removeFirstSegments(1))) {
            resourcesPath = srcPath.append("resources/");
            if (!this.fProject.exists(resourcesPath.removeFirstSegments(1))) {
                resourcesPath = null;
            }
            srcPath = javaPath;
        }
        IClasspathEntry entry = JavaCore.newSourceEntry((IPath)srcPath);
        resEntries.add(entry);
        if (resourcesPath != null) {
            entry = JavaCore.newSourceEntry((IPath)resourcesPath);
            resEntries.add(entry);
        }
    }

    private void detectSourceFolders(ArrayList resEntries) {
        if (this.mFromTemplate) {
            IPath projectPath = this.fProject.getFullPath();
            this.checkSourceFolder(projectPath.append("src/"), resEntries);
            this.checkSourceFolder(this.mWebRoot.append("WEB-INF/src/"), resEntries);
            return;
        }
        Set sourceFolderSet = this.mSourceFolders.keySet();
        for (IPath path : sourceFolderSet) {
            ArrayList<IPath> excluded = new ArrayList<IPath>();
            for (IPath other : sourceFolderSet) {
                if (path.equals((Object)other) || !path.isPrefixOf(other)) continue;
                IPath pathToExclude = other.removeFirstSegments(path.segmentCount()).addTrailingSeparator();
                excluded.add(pathToExclude);
            }
            IPath[] excludedPaths = excluded.toArray(new IPath[excluded.size()]);
            IClasspathEntry entry = JavaCore.newSourceEntry((IPath)path, (IPath[])excludedPaths);
            resEntries.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitCompilationUnit(IFile file) throws JavaModelException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
        if (cu != null) {
            ICompilationUnit workingCopy = null;
            try {
                ICompilationUnit iCompilationUnit = workingCopy = cu.getWorkingCopy((IProgressMonitor)monitor);
                synchronized (iCompilationUnit) {
                    workingCopy.reconcile(0, false, false, null, null);
                }
                IPath packPath = file.getParent().getFullPath();
                IPackageDeclaration[] decls = workingCopy.getPackageDeclarations();
                String cuName = file.getName();
                if (decls.length == 0) {
                    this.addToMap(this.mSourceFolders, packPath, (IPath)new Path(cuName));
                } else {
                    Path relpath = new Path(decls[0].getElementName().replace('.', '/'));
                    IPath folderPath = this.getFolderPath(packPath, (IPath)relpath);
                    if (folderPath != null) {
                        this.addToMap(this.mSourceFolders, folderPath, relpath.append(cuName));
                    }
                }
            }
            finally {
                if (workingCopy != null) {
                    workingCopy.discardWorkingCopy();
                }
            }
        }
    }

    private void addToMap(HashMap map, IPath folderPath, IPath relPath) {
        ArrayList<IPath> list = (ArrayList<IPath>)map.get(folderPath);
        if (list == null) {
            list = new ArrayList<IPath>(50);
            map.put(folderPath, list);
        }
        list.add(relPath);
    }

    private IPath getFolderPath(IPath packPath, IPath relpath) {
        IPath common;
        int remainingSegments = packPath.segmentCount() - relpath.segmentCount();
        if (remainingSegments >= 0 && (common = packPath.removeFirstSegments(remainingSegments)).equals((Object)relpath)) {
            return packPath.uptoSegment(remainingSegments);
        }
        return null;
    }

    private boolean hasExtension(String name, String ext) {
        return name.endsWith(ext) && ext.length() != name.length();
    }

    private boolean isValidCUName(String name) {
        return !JavaConventions.validateCompilationUnitName((String)name, (String)"1.3", (String)"1.3").matches(4);
    }

    public boolean visit(IResourceProxy proxy) throws CoreException {
        if (proxy.getType() == 1) {
            String name = proxy.getName();
            if (this.hasExtension(name, ".java") && this.isValidCUName(name)) {
                this.visitCompilationUnit((IFile)proxy.requestResource());
            } else if (this.hasExtension(name, ".class")) {
                this.mClassFiles.add(proxy.requestResource());
            } else if (this.hasExtension(name, ".jar")) {
                this.mJARFiles.add(proxy.requestFullPath());
            }
            return false;
        }
        return true;
    }

    public IPath getOutputLocation() {
        return this.fOutputLocation;
    }

    public IClasspathEntry[] getClasspath() {
        return this.fResultClasspath;
    }
}

