/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.utils;

import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Node;

public class PositionUtils {
    private PositionUtils() {
    }

    public static final long calculateInsertOffset(IDOMPosition position, IFile baseFile) {
        if (baseFile == null || position == null) {
            return -1L;
        }
        if (position.isText()) {
            return PositionUtils.calculateInsertOffsetForTextNode((IDOMText)position.getContainerNode(), baseFile);
        }
        Node node = position.getPreviousSiblingNode();
        if (node instanceof IDOMElement) {
            IDOMElement prevSib = (IDOMElement)node;
            Range range = PositionUtils.getRange(prevSib, baseFile);
            return range.getEndOffset();
        }
        if (node instanceof IDOMText) {
            return PositionUtils.calculateInsertOffsetForTextNode((IDOMText)node, baseFile);
        }
        node = position.getNextSiblingNode();
        if (node instanceof IDOMElement) {
            IDOMElement nextSib = (IDOMElement)node;
            Range range = PositionUtils.getRange(nextSib, baseFile);
            return range.getOffset();
        }
        if (node instanceof IDOMText) {
            return PositionUtils.calculateInsertOffsetForTextNode((IDOMText)node, baseFile);
        }
        node = position.getContainerNode();
        if (node instanceof IDOMElement) {
            IDOMElement container = (IDOMElement)node;
            Range range = PositionUtils.getRange(container, baseFile);
            return range.getOffset() + (long)(container.getStartEndOffset() - container.getStartOffset()) + 1L;
        }
        if (node instanceof IDOMText) {
            return PositionUtils.calculateInsertOffsetForTextNode((IDOMText)node, baseFile);
        }
        return -1L;
    }

    private static final long calculateInsertOffsetForTextNode(IDOMText textNode, IFile baseFile) {
        Node node = textNode.getPreviousSibling();
        if (node instanceof IDOMElement) {
            IDOMElement prevSib = (IDOMElement)node;
            Range range = PositionUtils.getRange(prevSib, baseFile);
            return range.getEndOffset();
        }
        node = textNode.getNextSibling();
        if (node instanceof IDOMElement) {
            IDOMElement nextSib = (IDOMElement)node;
            Range range = PositionUtils.getRange(nextSib, baseFile);
            return range.getOffset();
        }
        Node parentNode = textNode.getParentNode();
        while (parentNode != null && !(parentNode instanceof IDOMElement)) {
            parentNode = parentNode.getParentNode();
        }
        if (parentNode != null) {
            IDOMElement container = (IDOMElement)parentNode;
            Range range = PositionUtils.getRange(container, baseFile);
            return range.getOffset() + (long)(container.getStartEndOffset() - container.getStartOffset()) + 1L;
        }
        return -1L;
    }

    private static Range getRange(IDOMElement domElement, IFile baseFile) {
        StructuredDocumentResourceLocationFactory factory = new StructuredDocumentResourceLocationFactory(baseFile);
        ResourceLocation location = factory.createForEntireElement(domElement);
        return location.getRange();
    }
}

