/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.utils;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.AbstractBaseTag;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.impl.AbstractJSPTagImpl;
import oracle.eclipse.tools.webtier.ui.tagdrop.FacetComposite;
import oracle.eclipse.tools.webtier.ui.tagdrop.OverlayImageDescriptor;
import oracle.eclipse.tools.xml.model.emfbinding.dom.NodeEStoreFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.ListOfValues;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MDUtils {
    private static final String CHILD_TEMPLATE_SUFFIX = "-child-template";
    private static final String ICON_SUFFIX = "-icon";
    private static final String TRAIT_FACET_VALID_VALUES = "facet-valid-values";
    private static final String TRAIT_AUTOGENERATED_FACETS = "auto-generated-facets";
    private static final String TRAIT_USER_SELECTED_FACETS = "user-selected-facets";
    private static final String TRAIT_USER_DEFAULT_SELECTED_FACETS = "user-default-selected-facets";
    private static final String TRAIT_BASE_ICON = "base-icon";
    private static final String NAME_ATTR = "name";

    public static IMetaDataDomainContext getMDContext(IStructuredDocumentContext context) {
        IWorkspaceContextResolver contextResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        IResource res = contextResolver.getResource();
        if (res instanceof IFile) {
            return MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext((IFile)res);
        }
        return MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(contextResolver.getProject());
    }

    public static void addDefaultFacets(EObject _rootObject, IDOMPosition _position, NodeEStoreFactory estoreFactory) {
        IDOMNode container = (IDOMNode)_position.getContainerNode();
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)container.getStructuredDocument(), _position.getOffset());
        IMetaDataDomainContext metadataContext = MDUtils.getMDContext(context);
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(metadataContext);
        Model model = query.findTagLibraryModel(((AbstractJSPTagImpl)_rootObject).getNamespaceUri());
        if (model == null) {
            return;
        }
        Entity entity = query.findTagEntity(model, ((AbstractJSPTagImpl)_rootObject).getTagName());
        if (entity == null) {
            return;
        }
        List<String> validFacets = MDUtils.getListOfValues(query, entity, TRAIT_FACET_VALID_VALUES);
        List<String> autogenFasets = MDUtils.getListOfValues(query, entity, TRAIT_AUTOGENERATED_FACETS);
        for (String facetName : autogenFasets) {
            if (!validFacets.contains(facetName)) continue;
            MDUtils.addFacetChild(_rootObject, _position, estoreFactory, facetName);
        }
    }

    public static List<String> getUserSelectedFacets(EObject rootObject, IDOMPosition position) {
        ITaglibDomainMetaDataQuery query = MDUtils.getQuery(rootObject, position);
        if (query == null) {
            return Collections.EMPTY_LIST;
        }
        Model model = MDUtils.getModel(rootObject, position, query);
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        Entity entity = query.findTagEntity(model, ((AbstractJSPTagImpl)rootObject).getTagName());
        if (entity == null) {
            return Collections.EMPTY_LIST;
        }
        return MDUtils.getListOfValues(query, entity, TRAIT_USER_SELECTED_FACETS);
    }

    public static List<String> getUserDefaultSelectedFacets(EObject rootObject, IDOMPosition position) {
        ITaglibDomainMetaDataQuery query = MDUtils.getQuery(rootObject, position);
        if (query == null) {
            return Collections.EMPTY_LIST;
        }
        Model model = MDUtils.getModel(rootObject, position, query);
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        Entity entity = query.findTagEntity(model, ((AbstractJSPTagImpl)rootObject).getTagName());
        if (entity == null) {
            return Collections.EMPTY_LIST;
        }
        return MDUtils.getListOfValues(query, entity, TRAIT_USER_DEFAULT_SELECTED_FACETS);
    }

    public static List<String> getAutogeneratedFacets(EObject rootObject, IDOMPosition position) {
        ITaglibDomainMetaDataQuery query = MDUtils.getQuery(rootObject, position);
        if (query == null) {
            return Collections.EMPTY_LIST;
        }
        Model model = MDUtils.getModel(rootObject, position, query);
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        Entity entity = query.findTagEntity(model, ((AbstractJSPTagImpl)rootObject).getTagName());
        if (entity == null) {
            return Collections.EMPTY_LIST;
        }
        return MDUtils.getListOfValues(query, entity, TRAIT_AUTOGENERATED_FACETS);
    }

    public static ImageDescriptor getImageDescriptor(EObject rootObject, IDOMPosition position, String imageTraitName) {
        ITaglibDomainMetaDataQuery query = MDUtils.getQuery(rootObject, position);
        if (query == null) {
            return null;
        }
        Model model = MDUtils.getModel(rootObject, position, query);
        if (model == null) {
            return null;
        }
        Entity entity = query.findTagEntity(model, ((AbstractJSPTagImpl)rootObject).getTagName());
        if (entity == null) {
            return null;
        }
        return MDUtils.getImageDescriptorFromTagTraitValueAsString(query, entity, imageTraitName);
    }

    private static ImageDescriptor getImageDescriptorFromString(IMetaDataSourceModelProvider sourceModelProvider, String imgDesc) {
        IImageDescriptorProvider imageProvider = (IImageDescriptorProvider)sourceModelProvider.getAdapter(IImageDescriptorProvider.class);
        if (imageProvider != null) {
            return imageProvider.getImageDescriptor(imgDesc);
        }
        return null;
    }

    private static ImageDescriptor getImageDescriptorFromTagTraitValueAsString(ITaglibDomainMetaDataQuery query, Entity entity, String key) {
        Trait t = query.findTrait(entity, key);
        if (t != null) {
            String imgDesc = TraitValueHelper.getValueAsString((Trait)t);
            return MDUtils.getImageDescriptorFromString(t.getSourceModelProvider(), imgDesc);
        }
        return null;
    }

    public static List<String> getFacetsValidValues(EObject rootObject, IDOMPosition position) {
        ITaglibDomainMetaDataQuery query = MDUtils.getQuery(rootObject, position);
        if (query == null) {
            return Collections.EMPTY_LIST;
        }
        Model model = MDUtils.getModel(rootObject, position, query);
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        Entity entity = query.findTagEntity(model, ((AbstractJSPTagImpl)rootObject).getTagName());
        if (entity == null) {
            return Collections.EMPTY_LIST;
        }
        return MDUtils.getListOfValues(query, entity, TRAIT_FACET_VALID_VALUES);
    }

    private static Model getModel(EObject rootObject, IDOMPosition position, ITaglibDomainMetaDataQuery query) {
        return query.findTagLibraryModel(((AbstractJSPTagImpl)rootObject).getNamespaceUri());
    }

    private static ITaglibDomainMetaDataQuery getQuery(EObject rootObject, IDOMPosition position) {
        IDOMNode container = (IDOMNode)position.getContainerNode();
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)container.getStructuredDocument(), position.getOffset());
        IMetaDataDomainContext metadataContext = MDUtils.getMDContext(context);
        return (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(metadataContext);
    }

    private static void addFacetChild(EObject rootObject, IDOMPosition position, NodeEStoreFactory estoreFactory, String facetName) {
        if (rootObject != null && rootObject instanceof AbstractJSPTagImpl) {
            AbstractJSPTagImpl tagElement = (AbstractJSPTagImpl)rootObject;
            AbstractBaseTag facet = (AbstractBaseTag)estoreFactory.createUnboundEObject("http://java.sun.com/jsf/core", "facet");
            EClass eClass = facet.eClass();
            EStructuralFeature nameFeature = eClass.getEStructuralFeature(NAME_ATTR);
            facet.eSet(nameFeature, (Object)facetName);
            tagElement.getChildTags().add((Object)facet);
            MDUtils.addChildContent(rootObject, position, facet, estoreFactory, facetName);
        }
    }

    private static void addChildContent(EObject rootObject, IDOMPosition position, AbstractBaseTag facetTag, NodeEStoreFactory estoreFactory, String facetName) {
        Node node;
        AbstractBaseTag adaptedChild;
        String childContent = MDUtils.getChildContent(rootObject, position, facetName);
        if (childContent != null && (adaptedChild = MDUtils.adaptNode(node = MDUtils.parseString(childContent), estoreFactory)) != null) {
            facetTag.getChildTags().add((Object)adaptedChild);
        }
    }

    private static AbstractBaseTag adaptNode(Node node, NodeEStoreFactory estoreFactory) {
        if (node instanceof Document) {
            node = ((Document)node).getFirstChild();
        }
        if (node instanceof Element) {
            AbstractBaseTag object = (AbstractBaseTag)estoreFactory.createUnboundEObject(((Element)node).getNamespaceURI(), ((Element)node).getLocalName());
            MDUtils.addAttributes(object, node, estoreFactory);
            NodeList childNodes = ((Element)node).getChildNodes();
            if (childNodes != null) {
                int i = 0;
                while (i < childNodes.getLength()) {
                    AbstractBaseTag child;
                    Node item = childNodes.item(i);
                    if (item instanceof Element && (child = MDUtils.adaptNode(item, estoreFactory)) != null) {
                        MDUtils.addAttributes(child, item, estoreFactory);
                        object.getChildTags().add((Object)child);
                    }
                    ++i;
                }
            }
            return object;
        }
        return null;
    }

    private static void addAttributes(AbstractBaseTag tagElement, Node node, NodeEStoreFactory estoreFactory) {
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attr = (Attr)attributes.item(i);
            EClass eClass = tagElement.eClass();
            EStructuralFeature attrFeature = eClass.getEStructuralFeature(attr.getLocalName());
            if (attrFeature != null && !tagElement.eIsSet(attrFeature)) {
                tagElement.eSet(attrFeature, (Object)attr.getValue());
            }
            ++i;
        }
    }

    private static Node parseString(String str) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(str.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getChildContent(EObject rootObject, IDOMPosition position, String facetName) {
        ITaglibDomainMetaDataQuery query = MDUtils.getQuery(rootObject, position);
        if (query == null) {
            return null;
        }
        Model model = MDUtils.getModel(rootObject, position, query);
        if (model == null) {
            return null;
        }
        Entity entity = query.findTagEntity(model, ((AbstractJSPTagImpl)rootObject).getTagName());
        if (entity == null) {
            return null;
        }
        Trait t = query.findTrait(entity, String.valueOf(facetName) + CHILD_TEMPLATE_SUFFIX);
        if (t != null) {
            return TraitValueHelper.getValueAsString((Trait)t);
        }
        return null;
    }

    public static List<String> getListOfValues(ITaglibDomainMetaDataQuery query, Entity entity, String traitName) {
        EObject value;
        ArrayList<String> result = new ArrayList<String>();
        Trait trait = query.getQueryHelper().getTrait(entity, traitName);
        if (trait != null && (value = trait.getValue()) != null && value instanceof ListOfValues) {
            for (Object entry : ((ListOfValues)value).getEntries()) {
                if (!(entry instanceof SimpleAnyType)) continue;
                result.add(((SimpleAnyType)entry).getRawValue());
            }
        }
        return result;
    }

    public static void addSelectedFacets(EObject rootObject, IDOMPosition position, NodeEStoreFactory eStoreFactory, List<FacetComposite.FacetState> facetStates) {
        for (FacetComposite.FacetState facetState : facetStates) {
            if (!facetState.isState()) continue;
            MDUtils.addFacetChild(rootObject, position, eStoreFactory, facetState.getName());
        }
    }

    public static Image getBaseImage(EObject rootObject, IDOMPosition position) {
        ImageDescriptor imageDescriptor = MDUtils.getImageDescriptor(rootObject, position, TRAIT_BASE_ICON);
        if (imageDescriptor != null) {
            return imageDescriptor.createImage();
        }
        return null;
    }

    public static Image getImage(EObject rootObject, IDOMPosition position, String imageName) {
        ImageDescriptor imageDescriptor = MDUtils.getImageDescriptor(rootObject, position, imageName);
        if (imageDescriptor != null) {
            return imageDescriptor.createImage();
        }
        return null;
    }

    public static OverlayImageDescriptor getOverlayImageDescriptor(EObject rootObject, IDOMPosition position) {
        Image baseImage = MDUtils.getImage(rootObject, position, TRAIT_BASE_ICON);
        if (baseImage == null) {
            return null;
        }
        Map<String, ImageDescriptor> overlays = MDUtils.getOverlays(rootObject, position);
        if (overlays == null) {
            return null;
        }
        return new OverlayImageDescriptor(baseImage, overlays);
    }

    private static Map<String, ImageDescriptor> getOverlays(EObject rootObject, IDOMPosition position) {
        HashMap<String, ImageDescriptor> result = new HashMap<String, ImageDescriptor>();
        List<String> values = MDUtils.getFacetsValidValues(rootObject, position);
        for (String facetName : values) {
            ImageDescriptor descriptor = MDUtils.getImageDescriptor(rootObject, position, String.valueOf(facetName) + ICON_SUFFIX);
            if (descriptor == null) continue;
            result.put(facetName, descriptor);
        }
        return result;
    }
}

