/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.tagdrop.wizardpages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.ComponentGenerationInfo;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.FieldGenerationInfo;
import oracle.eclipse.tools.application.common.services.variables.IComponentGenerationInfoProvider;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.ValueReferenceHolder;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.ValueReferenceTreeContentProvider;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesTreeLabelProvider;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.HideStringFieldsFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.NoEmptyFieldsFilter;
import oracle.eclipse.tools.webtier.ui.tagdrop.AbstractTagDropWizardAdvisor;
import oracle.eclipse.tools.webtier.ui.tagdrop.ITagDropWizardModel;
import oracle.eclipse.tools.webtier.ui.tagdrop.wizardpages.AbstractTagDropWizardPage;
import oracle.eclipse.tools.webtier.ui.tagdrop.wizardpages.ComponentTypeDisplayNameToComponentTypeConverter;
import oracle.eclipse.tools.webtier.ui.tagdrop.wizardpages.ComponentTypeToComponentTypeDisplayNameConverter;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableColumn;

public class ChooseFieldsAndComponentsPages {
    private ChooseFieldsPage _chooseFieldsPage;
    private ChooseFieldComponentsPage _chooseFieldCompsPage;
    private CheckboxTreeViewer _fieldsViewer;
    private TableViewer _fieldsSelectedViewer;
    private WritableSet _selectedFieldsSet;
    private IObservableList _selectedFieldsList;
    private IObservableValue _selectedField;

    public ChooseFieldsAndComponentsPages(AbstractTagDropWizardAdvisor advisor) {
        this._chooseFieldsPage = new ChooseFieldsPage(advisor);
        this._chooseFieldCompsPage = new ChooseFieldComponentsPage(advisor);
    }

    public ChooseFieldsPage getChooseFieldsPage() {
        return this._chooseFieldsPage;
    }

    public ChooseFieldComponentsPage getChooseFieldComponentsPage() {
        return this._chooseFieldCompsPage;
    }

    private IObservableValue getSelectedValueRef() {
        return ((ITagDropWizardModel)((Object)this._chooseFieldCompsPage.getWizardAdvisor())).getSelectedValueReference();
    }

    private synchronized IObservableSet getSelectedFieldsSet() {
        if (this._selectedFieldsSet == null) {
            this._selectedFieldsSet = new WritableSet(new HashSet(), FieldGenerationInfo.class);
        }
        return this._selectedFieldsSet;
    }

    private synchronized IObservableList getSelectedFieldsList() {
        if (this._selectedFieldsList == null) {
            this._selectedFieldsList = new WritableList(new ArrayList(), FieldGenerationInfo.class);
        }
        return this._selectedFieldsList;
    }

    public class ChooseFieldComponentsPage
    extends AbstractTagDropWizardPage {
        private Button _moveUp;
        private Button _moveDown;
        private ISWTObservableValue _selectedIndex;
        private Binding _moveUpBinding;
        private Binding _moveDownBinding;

        protected ChooseFieldComponentsPage(AbstractTagDropWizardAdvisor advisor) {
            super("chooseFieldCompsPage", advisor);
        }

        @Override
        protected void bindControls() {
            this.bindSelectedFieldsTableViewer();
            this._selectedIndex = SWTObservables.observeSingleSelectionIndex((Control)ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer.getControl());
            this._moveUp.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Object fld = ChooseFieldsAndComponentsPages.this._selectedField.getValue();
                    int index = ChooseFieldsAndComponentsPages.this.getSelectedFieldsList().indexOf(fld);
                    ChooseFieldsAndComponentsPages.this.getSelectedFieldsList().remove(index);
                    ChooseFieldsAndComponentsPages.this.getSelectedFieldsList().add(--index, fld);
                    ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer.getControl().setFocus();
                    ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer.setSelection((ISelection)new StructuredSelection(fld), true);
                    ChooseFieldComponentsPage.this._moveUpBinding.updateModelToTarget();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this._moveDown.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Object fld = ChooseFieldsAndComponentsPages.this._selectedField.getValue();
                    int index = ChooseFieldsAndComponentsPages.this.getSelectedFieldsList().indexOf(fld);
                    ChooseFieldsAndComponentsPages.this.getSelectedFieldsList().remove(index);
                    ChooseFieldsAndComponentsPages.this.getSelectedFieldsList().add(++index, fld);
                    ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer.getControl().setFocus();
                    ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer.setSelection((ISelection)new StructuredSelection(fld), true);
                    ChooseFieldComponentsPage.this._moveDownBinding.updateModelToTarget();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this._moveUpBinding = this.getDataBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this._moveUp), (IObservableValue)this._selectedIndex, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new Converter(Integer.class, Boolean.class){

                public Object convert(Object fromObject) {
                    if (fromObject == null) {
                        return Boolean.FALSE;
                    }
                    int i = (Integer)fromObject;
                    return i > 0;
                }
            }));
            this._moveDownBinding = this.getDataBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this._moveDown), (IObservableValue)this._selectedIndex, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new Converter(Integer.class, Boolean.class){

                public Object convert(Object fromObject) {
                    if (fromObject == null) {
                        return Boolean.FALSE;
                    }
                    int i = (Integer)fromObject;
                    return i >= 0 && i < ChooseFieldsAndComponentsPages.this.getSelectedFieldsList().size() - 1;
                }
            }));
        }

        private void bindSelectedFieldsTableViewer() {
            ViewerSupport.bind((StructuredViewer)ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer, (IObservableList)ChooseFieldsAndComponentsPages.this.getSelectedFieldsList(), (IValueProperty[])BeanProperties.values(FieldGenerationInfo.class, (String[])new String[]{"fieldName", "label", "displayName", "componentGenerationInfo.componentType.displayName"}));
            ChooseFieldsAndComponentsPages.this._selectedField = (IObservableValue)ViewersObservables.observeSingleSelection((Viewer)ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer);
        }

        @Override
        protected String getWizardPageTitle() {
            return this.getWizardAdvisor().getWizardConfigPageTitle();
        }

        @Override
        protected String getWizardPageDescription() {
            return this.getWizardAdvisor().getWizardConfigPageDescription();
        }

        public void createControl(Composite parent) {
            Composite c = this.getWizardAdvisor().getWidgetAdapter().createComposite(parent, 0);
            GridLayoutFactory.swtDefaults().margins(14, 14).applyTo(c);
            GridDataFactory.swtDefaults().grab(true, true).applyTo((Control)c);
            GridDataFactory gdf = GridDataFactory.swtDefaults().align(4, 4).grab(true, false);
            this.getWizardAdvisor().getWidgetAdapter().createLabel(c, this.getWizardAdvisor().getWizardConfigPageTableLabel(), 0);
            Composite tableViewerComp = this.getWizardAdvisor().getWidgetAdapter().createComposite(c, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).applyTo(tableViewerComp);
            GridDataFactory.swtDefaults().align(4, 4).grab(true, true).applyTo((Control)tableViewerComp);
            ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer = new TableViewer(tableViewerComp, 67584);
            gdf.hint(-1, 100);
            gdf.span(0, 1);
            GridDataFactory.swtDefaults().align(4, 4).grab(true, true).applyTo(ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer.getControl());
            this.createColumn(Messages.ChooseFieldsAndComponentsPages_nameColumn);
            this.createColumnWithTextCellEditor(Messages.ChooseFieldsAndComponentsPages_labelColumn, "label");
            this.createColumn(Messages.ChooseFieldsAndComponentsPages_typeColumn);
            this.createColumnWithComboBoxCellEditor(Messages.ChooseFieldsAndComponentsPages_componentColumn, "componentGenerationInfo.componentType");
            ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer.getTable().setLinesVisible(true);
            ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer.getTable().setHeaderVisible(true);
            this.addMoveButtons(tableViewerComp);
            this.bindControls();
            this.setControl((Control)c);
        }

        private void createColumn(String name) {
            TableColumn column = new TableColumn(ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer.getTable(), 0);
            column.setText(name);
            column.pack();
            if (column.getWidth() < 100) {
                column.setWidth(100);
            }
        }

        private void createColumnWithTextCellEditor(String name, String beanProperty) {
            TableViewerColumn column = new TableViewerColumn(ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer, 0);
            column.setEditingSupport((EditingSupport)new InlineTextEditingSupport((ColumnViewer)ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer, this.getDataBindingContext(), beanProperty));
            column.getColumn().setText(name);
            column.getColumn().setWidth(100);
        }

        private void createColumnWithComboBoxCellEditor(String name, String beanProperty) {
            TableViewerColumn column = new TableViewerColumn(ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer, 0);
            column.setEditingSupport((EditingSupport)new InlineComboEditingSupportForComponentType((ColumnViewer)ChooseFieldsAndComponentsPages.this._fieldsSelectedViewer, this.getDataBindingContext(), beanProperty, (IFilePositionContext)new FilePositionContext(this.getDocument().getFile())));
            column.getColumn().setText(name);
            column.getColumn().setWidth(100);
        }

        private void addMoveButtons(Composite tableViewerComp) {
            Composite composite = this.getWizardAdvisor().getWidgetAdapter().createComposite(tableViewerComp, 0);
            GridLayoutFactory.swtDefaults().applyTo(composite);
            GridDataFactory gdf = GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false);
            this._moveUp = this.getWizardAdvisor().getWidgetAdapter().createButton(composite, "", 8);
            this._moveUp.setImage(Activator.Images.MOVEUP_ICON.getImage());
            this._moveUp.setEnabled(false);
            gdf.applyTo((Control)this._moveUp);
            this._moveDown = this.getWizardAdvisor().getWidgetAdapter().createButton(composite, "", 8);
            this._moveDown.setImage(Activator.Images.MOVEDOWN_ICON.getImage());
            this._moveDown.setEnabled(false);
            gdf.applyTo((Control)this._moveDown);
        }

        public IObservableList getSelectedFieldsForGeneration() {
            return ChooseFieldsAndComponentsPages.this._selectedFieldsList;
        }

        @Override
        protected void doDispose() {
            if (this._moveDownBinding != null) {
                this._moveDownBinding.dispose();
            }
            if (this._moveUpBinding != null) {
                this._moveUpBinding.dispose();
            }
        }
    }

    public class ChooseFieldsPage
    extends AbstractTagDropWizardPage {
        private Binding _fieldsSetBinding;

        protected ChooseFieldsPage(AbstractTagDropWizardAdvisor advisor) {
            super("chooseFields", advisor);
        }

        @Override
        protected void bindControls() {
            this.bindFieldsTreeViewer();
            IViewerObservableSet checkedItems = ViewersObservables.observeCheckedElements((CheckboxTreeViewer)ChooseFieldsAndComponentsPages.this._fieldsViewer, ValueReference.class);
            this._fieldsSetBinding = this.getDataBindingContext().bindSet(ChooseFieldsAndComponentsPages.this.getSelectedFieldsSet(), (IObservableSet)checkedItems, new UpdateSetStrategy(UpdateSetStrategy.POLICY_NEVER), new UpdateSetStrategy(UpdateSetStrategy.POLICY_UPDATE){

                protected IStatus doAdd(IObservableSet observableSet, Object element) {
                    FieldGenerationInfo bgi;
                    if (!(element instanceof ValueReferenceHolder) && (bgi = this.getFieldGenerationInfo(observableSet, (ValueReference)element)) == null) {
                        FieldGenerationInfo info = new FieldGenerationInfo((ValueReference)element, (IComponentGenerationInfoProvider)ChooseFieldsPage.this.getWizardAdvisor(), ChooseFieldsPage.this.getDocument().getFile());
                        this.addToSelectedFieldsIfNecessary(info, (Collection)ChooseFieldsAndComponentsPages.this.getSelectedFieldsSet());
                        this.addToSelectedFieldsIfNecessary(info, (Collection)ChooseFieldsAndComponentsPages.this.getSelectedFieldsList());
                    }
                    return this.validate();
                }

                private void addToSelectedFieldsIfNecessary(FieldGenerationInfo info, Collection col) {
                    boolean found = false;
                    for (Object elem : col) {
                        FieldGenerationInfo inListInfo = (FieldGenerationInfo)elem;
                        if (!info.getValueReference().equals((Object)inListInfo.getValueReference())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        col.add(info);
                    }
                }

                private void removeFromSelectedFieldsIfPresent(FieldGenerationInfo info, Collection col) {
                    for (Object elem : col) {
                        FieldGenerationInfo inListInfo = (FieldGenerationInfo)elem;
                        if (!info.getValueReference().equals((Object)inListInfo.getValueReference())) continue;
                        col.remove(elem);
                        break;
                    }
                }

                protected IStatus doRemove(IObservableSet observableSet, Object element) {
                    FieldGenerationInfo bgi;
                    if (!(element instanceof ValueReferenceHolder) && (bgi = this.getFieldGenerationInfo(observableSet, (ValueReference)element)) != null) {
                        this.removeFromSelectedFieldsIfPresent(bgi, (Collection)ChooseFieldsAndComponentsPages.this.getSelectedFieldsSet());
                        this.removeFromSelectedFieldsIfPresent(bgi, (Collection)ChooseFieldsAndComponentsPages.this.getSelectedFieldsList());
                    }
                    return this.validate();
                }

                private IStatus validate() {
                    if (ChooseFieldsAndComponentsPages.this.getSelectedFieldsList().size() == 0) {
                        return ValidationStatus.error((String)Messages.ChooseFieldsAndComponentsPages_FldComps_valdiationMsg);
                    }
                    return ValidationStatus.OK_STATUS;
                }

                private FieldGenerationInfo getFieldGenerationInfo(IObservableSet observableSet, ValueReference valRef) {
                    for (Object o : observableSet) {
                        FieldGenerationInfo fgi = (FieldGenerationInfo)o;
                        if (!fgi.getValueReference().equals((Object)valRef)) continue;
                        return fgi;
                    }
                    return null;
                }
            });
            ChooseFieldsAndComponentsPages.this.getSelectedValueRef().addValueChangeListener(new IValueChangeListener(){

                public void handleValueChange(ValueChangeEvent event) {
                    ChooseFieldsAndComponentsPages.this._fieldsViewer.setInput(ChooseFieldsAndComponentsPages.this.getSelectedValueRef().getValue());
                    ChooseFieldsAndComponentsPages.this.getSelectedFieldsSet().clear();
                    ChooseFieldsAndComponentsPages.this.getSelectedFieldsList().clear();
                    ChooseFieldsPage.this.setDefaultSelections((ValueReference)ChooseFieldsAndComponentsPages.this.getSelectedValueRef().getValue(), ChooseFieldsAndComponentsPages.this._fieldsViewer);
                }
            });
        }

        private void bindFieldsTreeViewer() {
            FilePositionContext context = new FilePositionContext(this.getWizardAdvisor().getFile());
            ChooseFieldsAndComponentsPages.this._fieldsViewer.setContentProvider((IContentProvider)new ValueReferenceTreeContentProvider((IFilePositionContext)context));
            ChooseFieldsAndComponentsPages.this._fieldsViewer.setLabelProvider((IBaseLabelProvider)new VariablesTreeLabelProvider((IModelContext)context));
            ChooseFieldsAndComponentsPages.this._fieldsViewer.addFilter((ViewerFilter)new NoEmptyFieldsFilter());
            ChooseFieldsAndComponentsPages.this._fieldsViewer.addFilter((ViewerFilter)new HideStringFieldsFilter((IModelContext)context));
            ChooseFieldsAndComponentsPages.this._fieldsViewer.setInput(ChooseFieldsAndComponentsPages.this.getSelectedValueRef().getValue());
            this.setDefaultSelections((ValueReference)ChooseFieldsAndComponentsPages.this.getSelectedValueRef().getValue(), ChooseFieldsAndComponentsPages.this._fieldsViewer);
            ChooseFieldsAndComponentsPages.this._fieldsViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (event.getElement() instanceof ValueReferenceHolder) {
                        ValueReference valRef = ((ValueReferenceHolder)event.getElement()).getValueReference();
                        if (valRef == ChooseFieldsAndComponentsPages.this.getSelectedValueRef().getValue()) {
                            event.getCheckable().setChecked(event.getElement(), true);
                        }
                        ChooseFieldsPage.this._fieldsSetBinding.updateModelToTarget();
                    }
                }
            });
        }

        private void setDefaultSelections(ValueReference valRef, CheckboxTreeViewer viewer) {
            viewer.expandToLevel(2);
            TreePath[] paths = viewer.getExpandedTreePaths();
            if (paths.length > 0) {
                Object[] children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(paths[0].getFirstSegment());
                if (children != null) {
                    this.fillSelected(children, viewer);
                }
                viewer.setGrayChecked((Object)paths[0], true);
            }
        }

        private void fillSelected(Object[] children, CheckboxTreeViewer viewer) {
            ChooseFieldsAndComponentsPages.this.getSelectedFieldsSet().clear();
            ChooseFieldsAndComponentsPages.this.getSelectedFieldsList().clear();
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                IFile file = this.getDocument().getFile();
                DataType.Field fld = ((ValueReference)o).getField((IModelContext)new FilePositionContext(file));
                if (fld.getType().getNumFields((IModelContext)new FilePositionContext(file)) == 0 && !fld.getType().isEnumerable()) {
                    FieldGenerationInfo info = new FieldGenerationInfo((ValueReference)o, (IComponentGenerationInfoProvider)this.getWizardAdvisor(), file);
                    ChooseFieldsAndComponentsPages.this.getSelectedFieldsSet().add((Object)info);
                    viewer.setChecked(o, true);
                }
                ++n2;
            }
            this._fieldsSetBinding.updateModelToTarget();
        }

        @Override
        protected String getWizardPageTitle() {
            return Messages.ChooseFieldsAndComponentsPages_Flds_pageTitle;
        }

        @Override
        protected String getWizardPageDescription() {
            return this.getWizardAdvisor().getWizardFieldsPageDescription();
        }

        public void createControl(Composite parent) {
            Composite c = this.getWizardAdvisor().getWidgetAdapter().createComposite(parent, 0);
            GridLayoutFactory.swtDefaults().margins(14, 14).applyTo(c);
            GridDataFactory.swtDefaults().align(4, 4).grab(true, true).applyTo((Control)c);
            Label lbl = this.getWizardAdvisor().getWidgetAdapter().createLabel(c, Messages.ChooseFieldsAndComponentsPages_Flds_treeLabel, 0);
            GridDataFactory.swtDefaults().applyTo((Control)lbl);
            ChooseFieldsAndComponentsPages.this._fieldsViewer = new CheckboxTreeViewer(c, 2048);
            GridDataFactory.swtDefaults().align(4, 4).grab(true, true).applyTo(ChooseFieldsAndComponentsPages.this._fieldsViewer.getControl());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)ChooseFieldsAndComponentsPages.this._fieldsViewer);
            c.pack();
            this.bindControls();
            this.setControl((Control)c);
        }

        @Override
        protected void doDispose() {
            if (this._fieldsSetBinding != null) {
                this._fieldsSetBinding.dispose();
            }
        }
    }

    private static class ComponentTypeLabelProvider
    extends LabelProvider {
        private ComponentTypeLabelProvider() {
        }

        public String getText(Object element) {
            return ((ComponentGenerationInfo.ComponentType)element).getDisplayName();
        }
    }

    private class InlineComboEditingSupportForComponentType
    extends ObservableValueEditingSupport {
        private ComboBoxViewerCellEditor _cellEditor;
        private String _beanProperty;
        private DataBindingContext _dbc;
        private IFilePositionContext _context;

        public InlineComboEditingSupportForComponentType(ColumnViewer viewer, DataBindingContext dbc, String beanProperty, IFilePositionContext context) {
            super(viewer, dbc);
            this._dbc = dbc;
            this._cellEditor = new InlineComboBoxViewerCellEditor((Composite)viewer.getControl(), 10, false);
            this._cellEditor.setContenProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
            this._cellEditor.setLabelProvider((IBaseLabelProvider)new ComponentTypeLabelProvider());
            this._beanProperty = beanProperty;
            this._context = context;
        }

        protected Binding createBinding(IObservableValue target, IObservableValue model) {
            Binding binding = this._dbc.bindValue(target, model, new UpdateValueStrategy().setConverter((IConverter)new ComponentTypeDisplayNameToComponentTypeConverter()), new UpdateValueStrategy().setConverter((IConverter)new ComponentTypeToComponentTypeDisplayNameConverter()));
            return binding;
        }

        protected CellEditor getCellEditor(Object element) {
            return this._cellEditor;
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            ((ComboBoxViewerCellEditor)cellEditor).setInput(this.getApplicableValues());
            return SWTObservables.observeSelection((Control)cellEditor.getControl());
        }

        private List<ComponentGenerationInfo.ComponentType> getApplicableValues() {
            DataType.Field field = ((FieldGenerationInfo)ChooseFieldsAndComponentsPages.this._selectedField.getValue()).getValueReference().getField((IModelContext)this._context);
            List values = ((IComponentGenerationInfoProvider)ChooseFieldsAndComponentsPages.this.getChooseFieldComponentsPage().getWizardAdvisor()).getAvailableComponentTypes(field);
            Collections.sort(values, new Comparator<ComponentGenerationInfo.ComponentType>(){

                @Override
                public int compare(ComponentGenerationInfo.ComponentType o1, ComponentGenerationInfo.ComponentType o2) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
            });
            return values;
        }

        protected IObservableValue doCreateElementObservable(Object element, ViewerCell cell) {
            return BeansObservables.observeValue((Object)element, (String)this._beanProperty);
        }

        private final class InlineComboBoxViewerCellEditor
        extends ComboBoxViewerCellEditor {
            public InlineComboBoxViewerCellEditor(Composite parent, int style, int visibleItems, boolean editable) {
                super(parent, style);
                this.adjustComboSettings(visibleItems, editable);
            }

            public InlineComboBoxViewerCellEditor(Composite parent, int visibleItems, boolean editable) {
                super(parent);
                this.adjustComboSettings(visibleItems, editable);
            }

            private void adjustComboSettings(int visibleItems, boolean editable) {
                CCombo combo = this.getViewer().getCCombo();
                combo.setVisibleItemCount(visibleItems);
                combo.setEditable(editable);
            }
        }
    }

    private static class InlineTextEditingSupport
    extends ObservableValueEditingSupport {
        private CellEditor _cellEditor;
        private String _beanProperty;

        public InlineTextEditingSupport(ColumnViewer viewer, DataBindingContext dbc, String beanProperty) {
            super(viewer, dbc);
            this._cellEditor = new TextCellEditor((Composite)viewer.getControl());
            this._beanProperty = beanProperty;
        }

        protected CellEditor getCellEditor(Object element) {
            return this._cellEditor;
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            return SWTObservables.observeText((Control)cellEditor.getControl(), (int)24);
        }

        protected IObservableValue doCreateElementObservable(Object element, ViewerCell cell) {
            return BeansObservables.observeValue((Object)element, (String)this._beanProperty);
        }
    }
}

