/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.tagdrop;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.eclipse.tools.webtier.ui.tagdrop.FacetMessages;
import oracle.eclipse.tools.webtier.ui.tagdrop.OverlayImageDescriptor;
import oracle.eclipse.tools.webtier.ui.utils.MDUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FacetComposite
extends Composite {
    private static final int GROUP_SIZE = 3;
    private final DataBindingContext bindingContext = new DataBindingContext();
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private EObject rootObject;
    private IDOMPosition position;
    private List<FacetState> facetStates;
    private OverlayImageDescriptor imageDescriptor;
    private Label imgLabel;

    public FacetComposite(Composite parent, int style, EObject rootObject, IDOMPosition position) {
        super(parent, style);
        this.rootObject = rootObject;
        this.position = position;
        if (parent.getLayoutData() instanceof GridData) {
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FacetComposite.this.toolkit.dispose();
                FacetComposite.this.bindingContext.dispose();
            }
        });
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.toolkit.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(1, false);
        this.setLayout((Layout)gridLayout);
        Section facetsComposite = this.toolkit.createSection((Composite)this, 2);
        GridData gd_facetsComposite = new GridData(4, 4, true, true, 1, 1);
        gd_facetsComposite.horizontalIndent = 5;
        facetsComposite.setLayoutData((Object)gd_facetsComposite);
        this.toolkit.paintBordersFor((Composite)facetsComposite);
        facetsComposite.setText("Facets");
        facetsComposite.setExpanded(true);
        this.toolkit.createCompositeSeparator((Composite)facetsComposite);
        Composite mainComposite = this.toolkit.createComposite((Composite)facetsComposite, 0);
        this.toolkit.paintBordersFor(mainComposite);
        facetsComposite.setClient((Control)mainComposite);
        mainComposite.setLayout((Layout)new RowLayout(256));
        this.facetStates = this.findFacetStates();
        this.createButtonGroups(mainComposite, this.facetStates);
        this.imageDescriptor = MDUtils.getOverlayImageDescriptor(rootObject, position);
        if (this.imageDescriptor != null) {
            this.createVisualizationComposite(mainComposite);
        }
    }

    private void createVisualizationComposite(Composite parent) {
        Composite composite = this.toolkit.createComposite(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 20;
        composite.setLayout((Layout)fillLayout);
        this.imgLabel = this.toolkit.createLabel(composite, null);
        this.updateLabel();
    }

    private void updateLabel() {
        List<FacetState> states = this.getFacetStates();
        HashSet<String> keys = new HashSet<String>();
        for (FacetState state : states) {
            if (!state.isState()) continue;
            keys.add(state.getName());
        }
        if (this.imageDescriptor == null) {
            this.imageDescriptor = MDUtils.getOverlayImageDescriptor(this.rootObject, this.position);
        }
        this.imageDescriptor.setKeys(keys);
        Image oldImage = this.imgLabel.getImage();
        this.imgLabel.setImage(this.imageDescriptor.createImage());
        if (oldImage != null) {
            oldImage.dispose();
        }
    }

    private List<FacetState> findFacetStates() {
        ArrayList<FacetState> result = new ArrayList<FacetState>();
        List<String> facets = MDUtils.getUserSelectedFacets(this.rootObject, this.position);
        List<String> defaults = MDUtils.getUserDefaultSelectedFacets(this.rootObject, this.position);
        for (String facetName : facets) {
            result.add(new FacetState(facetName, defaults.contains(facetName)));
        }
        return result;
    }

    private void createButtonGroups(Composite parent, List<FacetState> stateList) {
        int groups = stateList.size() / 3;
        int i = 0;
        while (i <= groups) {
            ArrayList<FacetState> subGroup = new ArrayList<FacetState>(3);
            int j = 0;
            while (j < 3) {
                if (i * 3 + j >= stateList.size()) break;
                int idx = i * 3 + j;
                subGroup.add(stateList.get(idx));
                ++j;
            }
            this.createButtonGroup(parent, subGroup);
            ++i;
        }
    }

    private void createButtonGroup(Composite parent, List<FacetState> stateList) {
        Composite composite = this.toolkit.createComposite(parent, 0);
        this.toolkit.paintBordersFor(composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        for (FacetState facetState : stateList) {
            this.createButton(composite, facetState);
        }
    }

    private void createButton(Composite parent, FacetState state) {
        this.toolkit.createLabel(parent, FacetMessages.getString(state.getName()), 0);
        Button btn = new Button(parent, 0x800020);
        this.toolkit.adapt((Control)btn, true, true);
        this.bindButtonToState(btn, state);
    }

    private void bindButtonToState(Button button, FacetState state) {
        ISWTObservableValue observeSelectionBtnAsdObserveWidget = WidgetProperties.selection().observe((Widget)button);
        IObservableValue stateStateObserveValue = PojoProperties.value((String)"state").observe((Object)state);
        this.bindingContext.bindValue((IObservableValue)observeSelectionBtnAsdObserveWidget, stateStateObserveValue, null, null);
        stateStateObserveValue.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                FacetComposite.this.updateLabel();
            }
        });
    }

    public List<FacetState> getFacetStates() {
        return this.facetStates;
    }

    public class FacetState {
        private String name;
        private boolean state;

        FacetState(String name, boolean state) {
            this.name = name;
            this.state = state;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isState() {
            return this.state;
        }

        public void setState(boolean state) {
            this.state = state;
        }
    }
}

