/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.tagdrop;

import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jst.pagedesigner.dnd.internal.SourceViewerDragDropHelper;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.w3c.dom.Node;

public abstract class AbstractOEPEOutlineDropTargetListener
implements TransferDropTargetListener {
    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 1;
        float feedbackFloat = this.getHeightInItem(event);
        if ((double)feedbackFloat > 0.75) {
            event.feedback = 4;
        } else if ((double)feedbackFloat < 0.25) {
            event.feedback = 2;
        }
        event.feedback |= 0x18;
    }

    protected float getHeightInItem(DropTargetEvent event) {
        if (event.item == null) {
            return 0.5f;
        }
        if (event.item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)event.item;
            Tree control = treeItem.getParent();
            Point point = control.toControl(new Point(event.x, event.y));
            Rectangle bounds = treeItem.getBounds();
            return (float)(point.y - bounds.y) / (float)bounds.height;
        }
        if (event.item instanceof TableItem) {
            TableItem tableItem = (TableItem)event.item;
            Table control = tableItem.getParent();
            Point point = control.toControl(new Point(event.x, event.y));
            Rectangle bounds = tableItem.getBounds(0);
            return (float)(point.y - bounds.y) / (float)bounds.height;
        }
        return 0.0f;
    }

    public abstract void drop(DropTargetEvent var1);

    public void dropAccept(DropTargetEvent event) {
    }

    protected int getInsertLocation(Node node, DropTargetEvent event) {
        int location = 0;
        float heightInItem = this.getHeightInItem(event);
        location = (double)heightInItem > 0.75 ? (node.hasChildNodes() ? EditModelQuery.getNodeStartNameEndIndex((Node)node) : EditModelQuery.getNodeEndIndex((Node)node)) : ((double)heightInItem < 0.25 ? EditModelQuery.getNodeStartIndex((Node)node) : (node.hasChildNodes() ? EditModelQuery.getNodeEndNameStartIndex((Node)node) : EditModelQuery.getNodeStartNameEndIndex((Node)node)));
        SourceViewerDragDropHelper helper = SourceViewerDragDropHelper.getInstance();
        location = helper.showCaret(this.getTextEditor(), location);
        return location;
    }

    protected int getInsertLocation(DropTargetEvent event) {
        Widget item = event.item;
        if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            return this.getInsertLocation((Node)treeItem.getData(), event);
        }
        return 0;
    }

    protected HTMLEditor getEditor() {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor instanceof HTMLEditor) {
            return (HTMLEditor)activeEditor;
        }
        return null;
    }

    protected StructuredTextEditor getTextEditor() {
        HTMLEditor htmlEditor = this.getEditor();
        return htmlEditor == null ? null : htmlEditor.getTextEditor();
    }

    public abstract Transfer getTransfer();

    public boolean isEnabled(DropTargetEvent event) {
        return this.getTransfer().isSupportedType(event.currentDataType);
    }
}

