/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.tagdrop;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.documentservices.AbstractDocumentContentGenerator;
import oracle.eclipse.tools.application.common.services.variables.ComponentGenerationInfo;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.IComponentGenerationInfoProvider;
import oracle.eclipse.tools.webtier.ui.tagdrop.AbstractTagDropWizardAdvisor;
import oracle.eclipse.tools.webtier.ui.tagdrop.TagDropWizard;
import oracle.eclipse.tools.webtier.ui.tagdrop.wizardpages.ChooseFieldsAndComponentsPages;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.wizard.IWizardPage;

public abstract class AbstractFieldsCreatingTagDropWizardAdvisor
extends AbstractTagDropWizardAdvisor
implements IComponentGenerationInfoProvider {
    private ChooseFieldsAndComponentsPages.ChooseFieldsPage _chooseFieldsPage;
    private ChooseFieldsAndComponentsPages.ChooseFieldComponentsPage _chooseFieldCompsPage;

    public AbstractFieldsCreatingTagDropWizardAdvisor(TagDropWizard wizard) {
        super(wizard);
        this.init();
    }

    private void init() {
        this.doInitialization();
        ChooseFieldsAndComponentsPages p = new ChooseFieldsAndComponentsPages(this);
        this._chooseFieldsPage = p.getChooseFieldsPage();
        this._chooseFieldCompsPage = p.getChooseFieldComponentsPage();
    }

    protected abstract void doInitialization();

    @Override
    public final void addPages() {
        this.addStartingPage();
        this.doAddCommonPages();
        this.addOptionalPages();
    }

    protected IWizardPage getChooseFieldsPage() {
        return this._chooseFieldsPage;
    }

    protected IWizardPage getChooseFieldComponentsPage() {
        return this._chooseFieldCompsPage;
    }

    protected void doAddCommonPages() {
        this.addPage((IWizardPage)this._chooseFieldsPage);
        this.addPage((IWizardPage)this._chooseFieldCompsPage);
    }

    protected abstract void addStartingPage();

    protected abstract void addOptionalPages();

    @Override
    public final void performFinish() {
        AbstractDocumentContentGenerator generator = this.getGenerator();
        generator.setFieldGenerationInfos((List)this.getSelectedFieldsForGeneration());
        this.setAdditionalGenerationSettings(generator);
        this.getWizard().setRootObject(generator.getFragment());
    }

    protected void setAdditionalGenerationSettings(AbstractDocumentContentGenerator generator) {
    }

    public IObservableList getSelectedFieldsForGeneration() {
        return this._chooseFieldCompsPage.getSelectedFieldsForGeneration();
    }

    public List<ComponentGenerationInfo.ComponentType> getAvailableComponentTypes(DataType.Field field) {
        ArrayList<ComponentGenerationInfo.ComponentType> ret = new ArrayList<ComponentGenerationInfo.ComponentType>();
        boolean isMulti = field.getType().isEnumerable();
        ComponentGenerationInfo.ComponentType[] componentTypeArray = ComponentGenerationInfo.ComponentType.values();
        int n = componentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentGenerationInfo.ComponentType c = componentTypeArray[n2];
            if (isMulti && c.isMultiValueType()) {
                ret.add(c);
            } else if (!isMulti && !c.isMultiValueType()) {
                ret.add(c);
            }
            ++n2;
        }
        return ret;
    }

    protected boolean isUpdateableByDefault(DataType.Field field) {
        return false;
    }

    public ComponentGenerationInfo getComponentGenerationInfo(DataType.Field field, ComponentGenerationInfo.ComponentType component) {
        if (component == null) {
            component = this.getDefaultComponentType(field);
        }
        ComponentGenerationInfo cgi = new ComponentGenerationInfo(component);
        return cgi;
    }

    public ComponentGenerationInfo.ComponentType getDefaultComponentType(DataType.Field field) {
        if (this.isUpdateableByDefault(field)) {
            if (field.getType().isBoolean()) {
                return ComponentGenerationInfo.ComponentType.Checkbox;
            }
            if (field.getType().isEnumerable()) {
                return ComponentGenerationInfo.ComponentType.MultiSelectList;
            }
            return ComponentGenerationInfo.ComponentType.Textbox;
        }
        return ComponentGenerationInfo.ComponentType.Label;
    }

    protected abstract AbstractDocumentContentGenerator getGenerator();

    protected Option getInitialDoHeaderSetting() {
        return Option.available;
    }

    protected Option getInitialDoFooterSetting() {
        return Option.available;
    }

    protected Option getInitialDoValidationSetting() {
        return Option.available;
    }

    public static enum Option {
        unavailable,
        available,
        availableAndSelected;

    }
}

