/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource.internal;

import java.util.HashMap;
import java.util.Set;
import java.util.TimeZone;
import oracle.eclipse.tools.webtier.ui.resource.internal.TimeZoneNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TimeZoneNodeContentProvider
implements ITreeContentProvider {
    private static final TimeZoneNode[] TIME_ZONES;
    private static final RootElement ROOT_ELEMENT;

    static {
        ROOT_ELEMENT = new RootElement();
        String[] timeZoneIds = TimeZone.getAvailableIDs();
        HashMap<String, TimeZoneNode> nodes = new HashMap<String, TimeZoneNode>();
        String[] stringArray = timeZoneIds;
        int n = timeZoneIds.length;
        int n2 = 0;
        while (n2 < n) {
            String timeZoneId = stringArray[n2];
            String[] parts = timeZoneId.split("/");
            if (parts.length != 0) {
                TimeZoneNode node = (TimeZoneNode)nodes.get(parts[0]);
                if (node == null) {
                    node = new TimeZoneNode(parts[0]);
                    nodes.put(parts[0], node);
                }
                int i = 1;
                while (i < parts.length) {
                    TimeZoneNode childNode = node.getChild(parts[i]);
                    if (childNode == null) {
                        childNode = new TimeZoneNode(parts[i]);
                        node.addChild(childNode);
                    }
                    node = childNode;
                    ++i;
                }
            }
            ++n2;
        }
        TIME_ZONES = nodes.values().toArray(new TimeZoneNode[nodes.size()]);
    }

    public static RootElement getRootElement() {
        return ROOT_ELEMENT;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == TimeZoneNodeContentProvider.getRootElement()) {
            return TIME_ZONES;
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == TimeZoneNodeContentProvider.getRootElement()) {
            return TIME_ZONES;
        }
        if (parentElement instanceof TimeZoneNode && ((TimeZoneNode)parentElement).hasChildren()) {
            Set<TimeZoneNode> children = ((TimeZoneNode)parentElement).getChildren();
            return children.toArray(new TimeZoneNode[children.size()]);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element == TimeZoneNodeContentProvider.getRootElement()) {
            return TIME_ZONES.length > 0;
        }
        if (element instanceof TimeZoneNode) {
            return ((TimeZoneNode)element).hasChildren();
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element instanceof TimeZoneNode && ((TimeZoneNode)element).hasParent()) {
            return ((TimeZoneNode)element).getParent();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private static class RootElement {
        private RootElement() {
        }
    }
}

