/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public class TimeZoneNode {
    private final String _name;
    private TimeZoneNode _parent;
    private Set<TimeZoneNode> _children;

    public TimeZoneNode(String name) {
        Assert.isNotNull((Object)name);
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    private void setParent(TimeZoneNode parent) {
        this._parent = parent;
    }

    public boolean hasParent() {
        return this._parent != null;
    }

    public TimeZoneNode getParent() {
        return this._parent;
    }

    private void ensureChildrenInitialized() {
        if (this._children == null) {
            this._children = new HashSet<TimeZoneNode>();
        }
    }

    public boolean isLeaf() {
        return this._children == null;
    }

    public boolean hasChildren() {
        return this._children != null;
    }

    public boolean addChild(TimeZoneNode child) {
        this.ensureChildrenInitialized();
        boolean added = this._children.add(child);
        child.setParent(this);
        return added;
    }

    public Set<TimeZoneNode> getChildren() {
        if (this._children == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this._children);
    }

    public TimeZoneNode getChild(String name) {
        if (this._children == null) {
            return null;
        }
        for (TimeZoneNode child : this._children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeZoneNode)) {
            return false;
        }
        TimeZoneNode that = (TimeZoneNode)obj;
        if (this.getName().equals(that.getName())) {
            if (this.hasParent() == that.hasParent()) {
                if (this.hasParent()) {
                    return this.getParent().equals(that.getParent());
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("(name=");
        builder.append(this.getName());
        if (this.hasParent()) {
            builder.append(", parent=");
            builder.append(this.getParent().getName());
        }
        builder.append(")");
        for (TimeZoneNode child : this.getChildren()) {
            builder.append("\n");
            TimeZoneNode n = child;
            while (n.hasParent()) {
                builder.append("\t");
                n = n.getParent();
            }
            builder.append(child);
        }
        return builder.toString();
    }
}

