/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource.internal;

import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.webapp.javasrc.ParentAndResource;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.ui.resource.internal.Package;
import oracle.eclipse.tools.webtier.ui.resource.internal.ResourceBaseName;
import oracle.eclipse.tools.webtier.ui.resource.internal.Source;
import org.eclipse.core.databinding.conversion.Converter;

public class StringToResourceBaseNameConverter
extends Converter {
    private final IDocument _iDocument;

    public StringToResourceBaseNameConverter(IDocument iDocument) {
        super(String.class, ResourceBaseName.class);
        this._iDocument = iDocument;
    }

    public Object convert(Object fromObject) {
        if (fromObject instanceof String) {
            String fullBaseName = (String)fromObject;
            if ((fullBaseName = fullBaseName.trim()).length() == 0) {
                return null;
            }
            IAppLocalizer localizer = (IAppLocalizer)this._iDocument.getProject().getAppService(IAppLocalizer.class);
            Set baseNames = localizer.getAllBaseNamesWithParents(true);
            ParentAndResource found = null;
            for (ParentAndResource par : baseNames) {
                if (!fullBaseName.equals(par.getBaseName())) continue;
                found = par;
                break;
            }
            if (found == null) {
                return null;
            }
            Source src = new Source(found.getSimpleParentName());
            ResourceBaseName name = new ResourceBaseName(fullBaseName);
            Package pkg = new Package(name.getPackage());
            src.addBaseName(pkg);
            pkg.addBaseName(name);
            return name;
        }
        return null;
    }
}

