/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import oracle.eclipse.tools.application.common.services.resource.IResourceBundleExt;
import oracle.eclipse.tools.webtier.ui.resource.IKeyValuePair;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ResourceExpandedTreeContentProvider
implements ITreeContentProvider {
    private static final String SEPARATOR = ".";
    private static final String REGEX_SEPARATOR = "\\.";

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IResourceBundleExt) {
            return this.childrenFromResourceBundleExt((IResourceBundleExt)parentElement);
        }
        if (parentElement instanceof TreeExpandedNode) {
            return this.childrenFromExpandedNode((TreeExpandedNode)parentElement);
        }
        return null;
    }

    private Object[] childrenFromResourceBundleExt(IResourceBundleExt bundleExt) {
        ArrayList<TreeExpandedNode> children = new ArrayList<TreeExpandedNode>();
        Enumeration keys = bundleExt.getKeys();
        ArrayList<String> myKeys = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            myKeys.add((String)keys.nextElement());
        }
        Collections.sort(myKeys);
        TreeExpandedNode root = new TreeExpandedNode("", "");
        for (String key : myKeys) {
            this.insertKey(key, root, bundleExt);
        }
        for (TreeExpandedNode node : root.getChildren()) {
            node.setParent(null);
            children.add(node);
        }
        return children.toArray(new Object[children.size()]);
    }

    private void insertKey(String key, TreeExpandedNode parent, IResourceBundleExt bundleExt) {
        String[] keyParts = key.split(REGEX_SEPARATOR);
        StringBuffer fullKey = new StringBuffer();
        String[] stringArray = keyParts;
        int n = keyParts.length;
        int n2 = 0;
        while (n2 < n) {
            String keyPart = stringArray[n2];
            if (fullKey.length() != 0) {
                fullKey.append(SEPARATOR);
            }
            fullKey.append(keyPart);
            parent = this.insertNode(parent, keyPart, fullKey.toString(), bundleExt);
            ++n2;
        }
    }

    private TreeExpandedNode insertNode(TreeExpandedNode parent, String keyPart, String fullKey, IResourceBundleExt bundleExt) {
        for (TreeExpandedNode child : parent.getChildren()) {
            if (!child.getKey().equals(keyPart)) continue;
            return child;
        }
        String value = this.getValueFromBundle(bundleExt, fullKey);
        TreeExpandedNode newChild = value == null ? new TreeExpandedNode(keyPart, fullKey) : new TreeExpandedNode(keyPart, fullKey, value);
        parent.addChild(newChild);
        return newChild;
    }

    private String getValueFromBundle(IResourceBundleExt bundleExt, String key) {
        try {
            return bundleExt.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private Object[] childrenFromExpandedNode(TreeExpandedNode node) {
        ArrayList<TreeExpandedNode> children = new ArrayList<TreeExpandedNode>();
        children.addAll(node.getChildren());
        return children.toArray(new Object[children.size()]);
    }

    public Object getParent(Object element) {
        if (element instanceof IResourceBundleExt) {
            return new Object[0];
        }
        if (element instanceof TreeExpandedNode) {
            return ((TreeExpandedNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IResourceBundleExt) {
            return ((IResourceBundleExt)element).getKeys().hasMoreElements();
        }
        if (element instanceof TreeExpandedNode) {
            return ((TreeExpandedNode)element).getChildren().size() > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IResourceBundleExt) {
            return this.getChildren(inputElement);
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public static final class TreeExpandedNode
    implements IKeyValuePair {
        private final String _key;
        private final String _fullKey;
        private String _value;
        private TreeExpandedNode _parent;
        private List<TreeExpandedNode> _children = new ArrayList<TreeExpandedNode>();

        public TreeExpandedNode(String key, String fullKey, String value) {
            this._key = key;
            this._fullKey = fullKey;
            this._value = value;
        }

        public TreeExpandedNode(String key, String fullKey) {
            this._key = key;
            this._fullKey = fullKey;
        }

        public String getKey() {
            return this._key;
        }

        public String getFullKey() {
            return this._fullKey;
        }

        public String getValue() {
            return this._value;
        }

        public boolean hasValue() {
            return this._value != null;
        }

        public void addChild(TreeExpandedNode child) {
            this._children.add(child);
            child.setParent(this);
        }

        public List<TreeExpandedNode> getChildren() {
            return Collections.unmodifiableList(this._children);
        }

        public boolean hasChildren() {
            return this._children.size() > 0;
        }

        private void setParent(TreeExpandedNode parent) {
            this._parent = parent;
        }

        public TreeExpandedNode getParent() {
            return this._parent;
        }

        public boolean hasParent() {
            return this._parent != null;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " key: \"" + this.getKey() + "\"" + ", full key: \"" + this.getFullKey() + "\"" + (this.hasValue() ? ", value: \"" + this.getValue() + "\"" : "");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TreeExpandedNode)) {
                return false;
            }
            TreeExpandedNode otherNode = (TreeExpandedNode)obj;
            return this.getFullKey() == null && otherNode.getFullKey() == null || this.getFullKey() != null && (this.getFullKey() == otherNode.getFullKey() || this.getFullKey().equals(otherNode.getFullKey()));
        }

        public int hashCode() {
            return this.getFullKey() == null ? 0 : this.getFullKey().hashCode();
        }

        @Override
        public String getResourceKey() {
            return this.getFullKey();
        }
    }
}

