/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource.internal;

import java.util.ArrayList;
import java.util.Collection;
import oracle.eclipse.tools.application.common.services.resource.IResourceBundleExt;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleExtFactory;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleUtil;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ResourceBundleListContentProvider
implements IStructuredContentProvider {
    private static final Object[] EMPTY = new IResourceBundleExt[0];
    private final EObject _eObject;
    private final IFilePositionContext _context;
    private final Collection<ResolutionTime> _expectedResTime;

    public ResourceBundleListContentProvider(IFilePositionContext context, EObject eObject, Collection<ResolutionTime> expectedResTime) {
        this._eObject = eObject;
        this._context = context;
        this._expectedResTime = expectedResTime;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof EStructuralFeature) {
            return this.getBundlesFromEStructuralFeature((EStructuralFeature)inputElement);
        }
        return EMPTY;
    }

    private Object[] getBundlesFromEStructuralFeature(EStructuralFeature eFeature) {
        if (this.requiresImplicitBundle(this._eObject)) {
            Object[] objectArray;
            IResourceBundleExt bundleExt = ResourceBundleUtil.INSTANCE.getBundleExtFromLocalizationContext(this._eObject, eFeature);
            if (bundleExt == null) {
                objectArray = EMPTY;
            } else {
                IResourceBundleExt[] iResourceBundleExtArray = new IResourceBundleExt[1];
                objectArray = iResourceBundleExtArray;
                iResourceBundleExtArray[0] = bundleExt;
            }
            return objectArray;
        }
        return this.getBundlesForElValueExpressionCase(this._eObject, eFeature);
    }

    private boolean requiresImplicitBundle(EObject eObject) {
        return false;
    }

    private IResourceBundleExt[] getBundlesForElValueExpressionCase(EObject eObject, EStructuralFeature eFeature) {
        Variable[] vars = ResourceBundleUtil.INSTANCE.getExternalVariableBundles(eObject, eFeature, this._expectedResTime);
        ArrayList<IResourceBundleExt> bundleExts = new ArrayList<IResourceBundleExt>(vars.length);
        Variable[] variableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            bundleExts.add(ResourceBundleExtFactory.INSTANCE.create(this._context, (JavaResourceBundleDataType)var.getType(), var));
            ++n2;
        }
        return bundleExts.toArray(new IResourceBundleExt[bundleExts.size()]);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

