/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource.internal;

import oracle.eclipse.tools.application.common.services.resource.IResourceBundleExt;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleKeyPair;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import org.eclipse.core.databinding.conversion.Converter;

public class ResourceBundleKeyPairToValueReferenceConverter
extends Converter {
    public ResourceBundleKeyPairToValueReferenceConverter() {
        super(ResourceBundleKeyPair.class, ValueReference.class);
    }

    public Object convert(Object fromObject) {
        if (fromObject instanceof ResourceBundleKeyPair) {
            ResourceBundleKeyPair pair = (ResourceBundleKeyPair)fromObject;
            IResourceBundleExt bundleExt = pair.getBundleExt();
            if (bundleExt == null) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.webtier.ui", (String)Messages.Converter_IResourceBundleExt_NullError);
                return null;
            }
            Variable var = bundleExt.getVariable();
            if (var == null) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.webtier.ui", (String)Messages.Converter_Variable_NullError);
                return null;
            }
            String field = pair.getKey();
            if (field == null) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.webtier.ui", (String)Messages.Converter_Key_NullError);
                return null;
            }
            return new ValueReference(var, field);
        }
        return null;
    }
}

