/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource.internal;

import java.util.HashMap;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.webapp.javasrc.ParentAndResource;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.ui.resource.internal.Package;
import oracle.eclipse.tools.webtier.ui.resource.internal.ResourceBaseName;
import oracle.eclipse.tools.webtier.ui.resource.internal.Source;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ResourceBaseNameContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IDocument) {
            return this.getSources((IDocument)inputElement);
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IDocument) {
            return this.getSources((IDocument)parentElement);
        }
        if (parentElement instanceof Source) {
            Set<Package> packages = ((Source)parentElement).getPackages();
            return packages.toArray(new Package[packages.size()]);
        }
        if (parentElement instanceof Package) {
            Set<ResourceBaseName> baseNames = ((Package)parentElement).getBaseNames();
            return baseNames.toArray(new ResourceBaseName[baseNames.size()]);
        }
        return null;
    }

    protected Source[] getSources(IDocument iDocument) {
        IAppLocalizer localizer = (IAppLocalizer)iDocument.getProject().getAppService(IAppLocalizer.class);
        Set baseNames = localizer.getAllBaseNamesWithParents(true);
        HashMap<String, Source> sources = new HashMap<String, Source>();
        for (ParentAndResource baseName : baseNames) {
            String fullBaseName;
            ResourceBaseName resource;
            String packageName;
            Package pkg;
            String sourceName = baseName.getSimpleParentName() == null ? "" : baseName.getSimpleParentName();
            Source source = (Source)sources.get(sourceName);
            if (source == null) {
                source = new Source(sourceName);
                sources.put(sourceName, source);
            }
            if ((pkg = source.getPackage(packageName = (resource = new ResourceBaseName(fullBaseName = baseName.getBaseName())).getPackage())) == null) {
                pkg = new Package(packageName);
                source.addBaseName(pkg);
            }
            pkg.addBaseName(resource);
        }
        return sources.values().toArray(new Source[sources.size()]);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IDocument) {
            IAppLocalizer localizer = (IAppLocalizer)((IDocument)element).getProject().getAppService(IAppLocalizer.class);
            return localizer.getAllBaseNames(true).size() > 0;
        }
        if (element instanceof Source) {
            return ((Source)element).getPackages().size() > 0;
        }
        if (element instanceof Package) {
            return ((Package)element).getBaseNames().size() > 0;
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element instanceof ResourceBaseName) {
            return ((ResourceBaseName)element).getParent();
        }
        if (element instanceof Package) {
            return ((Package)element).getParent();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

