/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.resource.internal.ResourceBaseName;
import oracle.eclipse.tools.webtier.ui.resource.internal.Source;
import org.eclipse.core.runtime.Assert;

public class Package {
    private final String _packageName;
    private Set<ResourceBaseName> _baseNames = new HashSet<ResourceBaseName>();
    private Source _parent;

    Package(String packageName) {
        Assert.isNotNull((Object)packageName);
        this._packageName = packageName;
    }

    public String getPackageName() {
        return this._packageName;
    }

    public boolean addBaseName(ResourceBaseName baseName) {
        if (!baseName.getPackage().equals(this._packageName)) {
            throw new IllegalArgumentException(Messages.Package_AddBaseName_IllegalArgumentException);
        }
        boolean added = this._baseNames.add(baseName);
        baseName.setParent(this);
        return added;
    }

    public Set<ResourceBaseName> getBaseNames() {
        return Collections.unmodifiableSet(this._baseNames);
    }

    void setParent(Source parent) {
        this._parent = parent;
    }

    public Source getParent() {
        return this._parent;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Package)) {
            return false;
        }
        Package that = (Package)obj;
        return this.getPackageName().equals(that.getPackageName());
    }

    public int hashCode() {
        return this.getPackageName().hashCode();
    }

    public String toString() {
        return String.valueOf(super.toString()) + '[' + this.getPackageName() + ']';
    }
}

