/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.resource;

import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.application.common.services.documentservices.WebtierDocumentServicesFactory;
import oracle.eclipse.tools.common.services.document.IDisposable;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.resource.internal.CurrentLocaleObservableValue;
import oracle.eclipse.tools.webtier.ui.resource.internal.ResourceLocaleDialogCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.CustomEditDialog;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.ReadOnlyMessageObservable;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class ResourceLocaleEditorAction
implements IEditorActionDelegate {
    private IEditorPart _targetEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this._targetEditor = targetEditor;
        IDocumentLocalizationContext dlContext = this.getDocumentLocalizationContext();
        boolean enabled = false;
        if (dlContext != null) {
            enabled = true;
            if (dlContext instanceof IDisposable) {
                ((IDisposable)dlContext).dispose();
            }
        }
        action.setEnabled(enabled);
    }

    public void run(IAction action) {
        CurrentLocaleObservableValue userModelObservable = new CurrentLocaleObservableValue(this.getProject());
        ResourceLocaleDialogCreationAdvisor advisor = new ResourceLocaleDialogCreationAdvisor(new DataBindingContext(), Messages.ResourceLocaleDialog_Title, (AbstractDialogEditorCreationAdvisor.MessageSourceObservableValue)new ReadOnlyMessageObservable(Messages.ResourceLocaleDialog_Prompt), (IObservableValue)userModelObservable, this.getDocumentLocalizationContext());
        CustomEditDialog dialog = new CustomEditDialog(new IShellProvider(){

            public Shell getShell() {
                return ResourceLocaleEditorAction.this._targetEditor.getEditorSite().getShell();
            }
        }, (AbstractDialogEditorCreationAdvisor)advisor);
        dialog.open();
    }

    private IDocumentLocalizationContext getDocumentLocalizationContext() {
        if (this._targetEditor == null) {
            return null;
        }
        IResource resource = (IResource)this._targetEditor.getAdapter(IResource.class);
        if (resource == null) {
            return null;
        }
        IDocument doc = (IDocument)resource.getAdapter(IDocument.class);
        if (doc == null) {
            return null;
        }
        WebtierDocumentServicesFactory factory = new WebtierDocumentServicesFactory();
        return (IDocumentLocalizationContext)factory.createAdapter(IDocumentLocalizationContext.class, doc);
    }

    private IProject getIProject() {
        IResource resource = (IResource)this._targetEditor.getAdapter(IResource.class);
        return resource == null ? null : resource.getProject();
    }

    private Project getProject() {
        IProject iProject = this.getIProject();
        return iProject == null ? null : (Project)iProject.getAdapter(Project.class);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

