/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteEntry;
import oracle.eclipse.tools.webtier.ui.palette.model.ModelAdapter;
import oracle.eclipse.tools.webtier.ui.palette.model.ModelAdapterListener;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteTreeItem;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;

public abstract class TreeModelAdapter
implements ModelAdapter {
    private List<ModelAdapterListener> listenerList = new CopyOnWriteArrayList<ModelAdapterListener>();
    private ILabelProvider _labelProvider = null;
    private List<IFilter> _filters = new CopyOnWriteArrayList<IFilter>();

    public TreeModelAdapter(ILabelProvider labelProvider) {
        this._labelProvider = labelProvider;
    }

    @Override
    public void addListener(ModelAdapterListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public ILabelProvider getLabelProvider() {
        return this._labelProvider;
    }

    @Override
    public void removeListener(ModelAdapterListener listener) {
        if (this.listenerList.contains(listener)) {
            this.listenerList.remove(listener);
        }
    }

    @Override
    public void firePropertyChanged(Object notifier, String property) {
        ArrayList<ModelAdapterListener> list = new ArrayList<ModelAdapterListener>();
        list.addAll(this.listenerList);
        for (ModelAdapterListener listener : list) {
            listener.propertyChanged(notifier, property);
        }
    }

    @Override
    public Object getProperty(Object modelObject, String propertyName) {
        Object result = null;
        if (propertyName.equals("CHILDREN_PROPERTY")) {
            result = this.getChildren(modelObject);
        } else if (propertyName.equals("LABEL_PROPERTY")) {
            result = this.getLabel(modelObject);
        } else if (propertyName.equals("IMAGE_PROPERTY")) {
            result = this.getImage(modelObject);
        } else if (propertyName.equals("TOOLTIP_PROPERTY")) {
            result = this.getToolTipText(modelObject);
        } else if (propertyName.equals("READONLY_PROPERTY")) {
            result = this.isReadonly(modelObject);
        }
        return result;
    }

    protected abstract List<DesignPaletteEntry> getChildren(Object var1);

    protected abstract Image getImage(Object var1);

    protected abstract String getLabel(Object var1);

    protected String getToolTipText(Object model) {
        if (model instanceof PaletteTreeItem) {
            PaletteTreeItem item = (PaletteTreeItem)((Object)model);
            return item.getToolTipText();
        }
        return null;
    }

    protected abstract boolean isReadonly(Object var1);

    public abstract Object getRoot();

    protected Object[] doFilter(Object parent, Object[] children) {
        if (children == null) {
            return children;
        }
        PaletteTreeFilter ptFilter = this.getPaletteTreeFilter();
        if (!(this._filters.size() != 0 || ptFilter != null && ptFilter.shouldFilter())) {
            return children;
        }
        ArrayList<Object> filtered = new ArrayList<Object>();
        int i = 0;
        while (i < children.length) {
            block6: {
                for (IFilter filter : this._filters) {
                    if (filter.select(children[i])) {
                        continue;
                    }
                    break block6;
                }
                filtered.add(children[i]);
            }
            ++i;
        }
        if (ptFilter != null && ptFilter.shouldFilter()) {
            List<Object> ptFiltered = ptFilter.filter(parent, filtered, 0);
            return ptFiltered.toArray(new Object[ptFiltered.size()]);
        }
        return filtered.toArray(new Object[filtered.size()]);
    }

    public abstract PaletteTreeFilter getPaletteTreeFilter();

    public void setPaletteTreeFilterText(String filterText) {
        this.getPaletteTreeFilter().setFilterString(filterText);
    }

    public void addFilter(IFilter filter) {
        this._filters.add(filter);
    }

    public void removeFilter(IFilter filter) {
        this._filters.remove(filter);
    }

    protected static class PaletteTreeFilter {
        private static final String EMPTY_STRING = "";
        private static final int STOP_RECURSING = 4;
        private ILabelProvider _labelProvider;
        private ITreeContentProvider _contentProvider;
        private String _filterString = "";
        private Map<Object, List<Object>> cache = new HashMap<Object, List<Object>>(1024);
        private Object[] EMPTY = new Object[0];

        public PaletteTreeFilter(ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            this._labelProvider = labelProvider;
            this._contentProvider = contentProvider;
        }

        public void setFilterString(String filterString) {
            this._filterString = filterString == null ? EMPTY_STRING : filterString.trim();
            this.cache.clear();
        }

        public boolean shouldFilter() {
            return !this._filterString.equals(EMPTY_STRING);
        }

        public List<Object> filter(Object parent, List<Object> children, int level) {
            if (parent == null) {
                return Collections.emptyList();
            }
            if (level > 4) {
                return Collections.emptyList();
            }
            List<Object> cached = this.cache.get(parent);
            if (cached != null) {
                return cached;
            }
            ArrayList<Object> selected = new ArrayList<Object>();
            for (Object child : children) {
                if (!this.select(parent, child, level)) continue;
                selected.add(child);
            }
            this.cache.put(parent, selected);
            return selected;
        }

        private boolean select(Object parent, Object child, int level) {
            return this.isElementVisible(child, level);
        }

        private boolean isElementVisible(Object entry, int level) {
            if (this.isLeafMatch(entry)) {
                return true;
            }
            Object[] children = this._contentProvider.getChildren(entry);
            if (children == null) {
                children = this.EMPTY;
            }
            return this.filter(entry, Arrays.asList(children), level + 1).size() > 0;
        }

        private boolean isLeafMatch(Object entry) {
            String label = this._labelProvider.getText(entry);
            String string = label = label == null ? EMPTY_STRING : label;
            return label.toLowerCase().indexOf(this._filterString.toLowerCase()) >= 0;
        }
    }
}

