/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.model;

import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.webtier.ui.palette.model.IPaletteContributor;
import oracle.eclipse.tools.webtier.ui.palette.model.IPaletteContributorListener;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteCategory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.osgi.framework.Bundle;

public abstract class PaletteContributor
implements IPaletteContributor {
    private final String _id;
    private Bundle _contributingBundle;
    private IFile _file;
    private int _priority;
    private final Set<IPaletteContributorListener> _listeners = new LinkedHashSet<IPaletteContributorListener>();

    public PaletteContributor(String id, Bundle contributingBundle, Integer priority, IFile file) {
        this._id = id;
        this._contributingBundle = contributingBundle;
        this._priority = priority;
        this._file = file;
    }

    public abstract List<PaletteCategory> getContributions();

    public void fillContextMenu(IMenuManager menu, Object selectedModel) {
    }

    public void fillPullDownMenu(IMenuManager manager) {
    }

    public void fillToolBar(IToolBarManager manager) {
    }

    public void selectionChanged(Object selection) {
    }

    public void onHelp(String helpId) {
    }

    public void dispose() {
        this._file = null;
        this._contributingBundle = null;
    }

    public String getID() {
        return this._id;
    }

    public final void updateFile(IFile newFile) {
        this._file = newFile;
        this.doUpdateFile(newFile);
    }

    public abstract void doUpdateFile(IFile var1);

    public IFile getFile() {
        return this._file;
    }

    public int getPriority() {
        return this._priority;
    }

    public ImageDescriptor getImageDescriptorFromRoot(String iconPath) {
        URL iconDir;
        ImageDescriptor descriptor = null;
        URL localURL = iconDir = FileLocator.find((Bundle)this._contributingBundle, (IPath)new Path(iconPath), null);
        descriptor = ImageDescriptor.createFromURL((URL)localURL);
        return descriptor;
    }

    public EditPartFactory getEditPartFactory() {
        return null;
    }

    public void addListener(IPaletteContributorListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(IPaletteContributorListener listener) {
        this._listeners.remove(listener);
    }

    public void refresh() {
    }

    public abstract void performInsertTag(TagToolPaletteEntry var1);

    public boolean applySystemFilter(PaletteCategory categoryModel) {
        return false;
    }

    public boolean isActive() {
        return true;
    }
}

