/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal.figure;

import oracle.eclipse.tools.webtier.ui.palette.internal.figure.DetailedLabelFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonBorder;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Toggle;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.internal.ui.palette.PaletteColorUtil;

public class ToolEntryToggle
extends Toggle {
    private boolean showHoverFeedback = false;
    private DetailedLabelFigure _label;
    static final Border TOOLBAR_ITEM_BORDER = new ButtonBorder(ButtonBorder.SCHEMES.TOOLBAR);
    static final int ARROW_WIDTH = 9;
    static final Insets LIST_HIGHLIGHT_INSETS = new Insets(1, 5, 2, 0);
    static final Insets ICON_HIGHLIGHT_INSETS = new Insets(2, 1, 2, 1);
    static final Border LIST_BORDER = new MarginBorder(3, 16, 4, 0);
    static final Border ICON_BORDER = new MarginBorder(4, 4, 3, 13);

    ToolEntryToggle(IFigure contents, DetailedLabelFigure label) {
        super(contents);
        this.setOpaque(false);
        this.setEnabled(true);
        this._label = label;
    }

    public boolean containsPoint(int x, int y) {
        Rectangle rect = this.getBounds().getCopy();
        if (this._label.getBorder() == ICON_BORDER) {
            rect.width -= 9;
        } else if (this._label.getBorder() == LIST_BORDER) {
            rect.width -= 9;
            rect.x += 9;
        }
        return rect.contains(x, y);
    }

    public IFigure findMouseEventTargetAt(int x, int y) {
        return null;
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        if (this.isEnabled()) {
            this.setRolloverEnabled(true);
            if (this.getFlag(STYLE_BUTTON)) {
                this.setBorder(TOOLBAR_ITEM_BORDER);
            }
            this.setForegroundColor(null);
        } else {
            if (this.getFlag(STYLE_BUTTON)) {
                this.setBorder(null);
            }
            this.setRolloverEnabled(false);
            this.setForegroundColor(ColorConstants.gray);
        }
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.isEnabled() && this.isRolloverEnabled()) {
            ButtonModel model = this.getModel();
            if (model.isSelected()) {
                graphics.setBackgroundColor(PaletteColorUtil.getSelectedColor());
                graphics.fillRoundRectangle(ToolEntryToggle.getSelectionRectangle(this._label), 3, 3);
            } else if (model.isMouseOver() || this.showHoverFeedback) {
                graphics.setBackgroundColor(PaletteColorUtil.getHoverColor());
                graphics.fillRoundRectangle(ToolEntryToggle.getSelectionRectangle(this._label), 3, 3);
            }
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isEnabled()) {
            if (this.getBorder() != null) {
                this.getBorder().paint((IFigure)this, graphics, NO_INSETS);
            }
            if (this.hasFocus()) {
                graphics.setForegroundColor(ColorConstants.black);
                graphics.setBackgroundColor(ColorConstants.white);
                Rectangle area = ToolEntryToggle.getSelectionRectangle(this._label);
                if (this.isStyle(STYLE_BUTTON)) {
                    graphics.drawFocus(area.x, area.y, area.width, area.height);
                } else {
                    graphics.drawFocus(area.x, area.y, area.width - 1, area.height - 1);
                }
            }
        } else {
            super.paintBorder(graphics);
        }
    }

    public void setShowHoverFeedback(boolean showHoverFeedback) {
        this.showHoverFeedback = showHoverFeedback;
        this.repaint();
    }

    static Rectangle getSelectionRectangle(DetailedLabelFigure labelFigure) {
        Rectangle rect = Rectangle.SINGLETON;
        rect.setBounds(labelFigure.getBounds());
        rect.x += 9;
        rect.width -= 9;
        int newWidth = labelFigure.getPreferredSize().width + 17;
        if (newWidth < rect.width) {
            rect.width = newWidth;
        }
        rect.crop(LIST_HIGHLIGHT_INSETS);
        return rect;
    }
}

