/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal.figure;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.palette.internal.figure.IExpandable;
import oracle.eclipse.tools.webtier.ui.palette.internal.figure.Interactor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class InteractorHelper
implements MouseListener {
    private EditPart editPart;
    private Interactor interactor;
    private IExpandable expandable;

    public InteractorHelper(EditPart editPart, Interactor interactor, IExpandable expandable) {
        this.editPart = editPart;
        this.interactor = interactor;
        this.expandable = expandable;
        interactor.addMouseListener(this);
        expandable.setExpanded(interactor.isExpanded());
    }

    public void setExpanded(boolean isExpanded) {
        this.interactor.setExpanded(isExpanded);
        this.interactorExpansionChanged(isExpanded);
    }

    protected void interactorExpansionChanged(boolean isInteractorExpanded) {
        RootEditPart root;
        this.expandable.setExpanded(isInteractorExpanded);
        this.expandable.setVisible(isInteractorExpanded);
        if (this.editPart == null) {
            return;
        }
        this.editPart.refresh();
        if (this.editPart.getParent() != null && (root = this.editPart.getRoot()) instanceof AbstractGraphicalEditPart && root.getModel() != null) {
            IFigure rootFigure = ((AbstractGraphicalEditPart)root).getFigure();
            this.invalidateAll(rootFigure);
            try {
                rootFigure.validate();
                rootFigure.repaint();
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            }
        }
    }

    protected void invalidateAll(IFigure figure) {
        figure.invalidate();
        LayoutManager manager = figure.getLayoutManager();
        if (manager != null) {
            manager.invalidate();
        }
        for (IFigure child : figure.getChildren()) {
            this.invalidateAll(child);
        }
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        boolean newExpansionState = !this.interactor.isExpanded();
        this.interactor.setExpanded(newExpansionState);
        this.interactorExpansionChanged(newExpansionState);
    }

    public void mouseReleased(MouseEvent me) {
    }
}

