/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal.figure;

import java.util.List;
import oracle.eclipse.tools.webtier.ui.palette.internal.figure.IExpandable;
import oracle.eclipse.tools.webtier.ui.palette.internal.figure.SpacingFigure;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class ContainerLayout
extends AbstractLayout {
    private boolean isHorizontal;
    private int spacing = 0;
    private int border = 0;

    public ContainerLayout() {
        this(true, 0);
    }

    public ContainerLayout(boolean isHorizontal, int spacing) {
        this.isHorizontal = isHorizontal;
        this.spacing = spacing;
    }

    public void setHorizontal(boolean isHorizontal) {
        this.isHorizontal = isHorizontal;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    protected int alignFigure(IFigure parent, IFigure child) {
        return -1;
    }

    protected Dimension calculatePreferredSizeHelper(IFigure parent) {
        Dimension preferred = new Dimension();
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = child.getPreferredSize();
            if (this.isHorizontal) {
                preferred.width += childSize.width;
                preferred.height = Math.max(preferred.height, childSize.height);
            } else {
                preferred.height += childSize.height;
                preferred.width = Math.max(preferred.width, childSize.width);
            }
            ++i;
        }
        int childrenSize = children.size();
        if (childrenSize > 1) {
            if (this.isHorizontal) {
                preferred.width += this.spacing * (childrenSize - 1);
            } else {
                preferred.height += this.spacing * (childrenSize - 1);
            }
        }
        preferred.width += this.border * 2;
        preferred.height += this.border * 2;
        preferred.width += parent.getInsets().getWidth();
        preferred.height += parent.getInsets().getHeight();
        return preferred;
    }

    protected Dimension calculatePreferredSize(IFigure parent, int width, int height) {
        IExpandable expandableFigure;
        Dimension preferred = null;
        if (parent instanceof IExpandable && !(expandableFigure = (IExpandable)parent).isExpanded()) {
            preferred = new Dimension();
        }
        if (preferred == null) {
            preferred = this.calculatePreferredSizeHelper(parent);
        }
        return preferred;
    }

    protected void adjustLayoutLocation(IFigure parent, Dimension dimension) {
    }

    public void layout(IFigure parent) {
        Dimension childSize;
        IFigure child;
        List children = parent.getChildren();
        int rx = 0;
        Dimension dimension = new Dimension();
        int i = 0;
        while (i < children.size()) {
            child = (IFigure)children.get(i);
            childSize = child.getPreferredSize();
            if (this.isHorizontal) {
                dimension.height = Math.max(dimension.height, childSize.height);
                rx += childSize.width;
            } else {
                dimension.width = Math.max(dimension.width, childSize.width);
            }
            ++i;
        }
        if (this.isHorizontal) {
            dimension.height += this.border * 2;
            dimension.width += this.border;
        } else {
            dimension.width += this.border * 2;
            dimension.height += this.border;
        }
        this.adjustLayoutLocation(parent, dimension);
        i = 0;
        while (i < children.size()) {
            child = (IFigure)children.get(i);
            childSize = child.getPreferredSize();
            if (this.isHorizontal) {
                int y = -1;
                y = this.alignFigure(parent, child);
                if (y == -1) {
                    y = (dimension.height - childSize.height) / 2;
                }
                Rectangle rectangle = new Rectangle(dimension.width, y, childSize.width, childSize.height);
                rectangle.translate(parent.getClientArea().getLocation());
                child.setBounds(rectangle);
                dimension.width += childSize.width;
                dimension.width += this.spacing;
                if (child instanceof SpacingFigure) {
                    int availableHorizontalSpace = parent.getClientArea().width - rx;
                    dimension.width += availableHorizontalSpace;
                }
            } else {
                Rectangle rectangle = new Rectangle(0, dimension.height, childSize.width, childSize.height);
                rectangle.translate(parent.getClientArea().getLocation());
                child.setBounds(rectangle);
                dimension.height += childSize.height;
                dimension.height += this.spacing;
            }
            ++i;
        }
    }
}

