/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal.editparts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.webtier.ui.palette.internal.editparts.PaletteTreeRootEditPart;
import oracle.eclipse.tools.webtier.ui.palette.internal.figure.InteractorHelper;
import oracle.eclipse.tools.webtier.ui.palette.internal.figure.SelectableContainerFigure;
import oracle.eclipse.tools.webtier.ui.palette.internal.figure.TreeNodeContentFigure;
import oracle.eclipse.tools.webtier.ui.palette.model.ModelAdapter;
import oracle.eclipse.tools.webtier.ui.palette.model.ModelAdapterListener;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteItem;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteTree;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.design.editpolicies.SelectionHandlesEditPolicyImpl;

public class PaletteTreeNodeEditPart
extends PaletteEditPart
implements ModelAdapterListener {
    private static final Border TOOLTIP_BORDER = new MarginBorder(0, 2, 1, 0);
    private static final int MOUSE_CLICK_INTERVAL = 800;
    private Label _label;
    private SelectableContainerFigure labelHolder;
    private TreeNodeContentFigure contentFigure;
    private InteractorHelper interactorHelper;
    private boolean isSelected = false;
    private boolean isReadOnly = false;
    private ModelAdapter modelAdapter;
    int removeNotifyCount = 0;

    public PaletteTreeNodeEditPart() {
        super(null);
    }

    public void activate() {
        this.addModelAdapterListener(this.getModel(), this);
        super.activate();
    }

    public void removeNotify() {
        ++this.removeNotifyCount;
        if (this.removeNotifyCount == 1) {
            super.removeNotify();
        }
    }

    public void deactivate() {
        this.removeModelAdapterListener(this.getModel(), this);
        super.deactivate();
    }

    public void createEditPolicies() {
        SelectionHandlesEditPolicyImpl policy = new SelectionHandlesEditPolicyImpl();
        this.installEditPolicy("Selection Feedback", (EditPolicy)policy);
    }

    @Override
    public void propertyChanged(Object object, String property) {
        if (property.equals("CHILDREN_PROPERTY")) {
            this.refreshChildren();
        } else if (property.equals("DETAIL_PROPERTY")) {
            this.refreshVisuals();
        } else {
            this.refreshChildren();
            this.refreshVisuals();
        }
    }

    public IFigure createFigure() {
        this.createContentFigure();
        this.createFigureContent();
        return this.contentFigure;
    }

    protected void createContentFigure() {
        this.contentFigure = new TreeNodeContentFigure();
    }

    protected void createFigureContent() {
        RectangleFigure space = new RectangleFigure();
        space.setVisible(false);
        space.setPreferredSize(new Dimension(3, 3));
        this.contentFigure.getIconArea().add((IFigure)space);
        this.labelHolder = new SelectableContainerFigure();
        this.contentFigure.getIconArea().add(this.labelHolder);
        this._label = new Label("Node");
        this._label.setForegroundColor(ColorConstants.black);
        this.labelHolder.add((IFigure)this._label);
        AbstractGraphicalEditPart parentEditPart = (AbstractGraphicalEditPart)this.getParent();
        this._label.setFont(parentEditPart.getFigure().getFont());
        this._label.addMouseListener(new MouseListener(){
            long t1 = 0L;
            long t2 = 0L;
            boolean running = false;

            public void mouseDoubleClicked(MouseEvent me) {
                if (this.running) {
                    return;
                }
                this.running = true;
                PaletteTreeNodeEditPart.this.executeAction();
                this.running = false;
            }

            public void mousePressed(MouseEvent me) {
                this.t2 = System.currentTimeMillis();
                if (this.t2 - this.t1 < 800L) {
                    this.mouseDoubleClicked(me);
                }
                this.t1 = this.t2;
            }

            public void mouseReleased(MouseEvent me) {
            }
        });
        this._label.setToolTip(this.getToolTipFigure());
        this.interactorHelper = new InteractorHelper((EditPart)this, this.contentFigure.getInteractor(), this.contentFigure.getInnerContentArea());
    }

    public void executeAction() {
        Object model = this.getModel();
        boolean cfr_ignored_0 = model instanceof PaletteItem;
    }

    public EditPart getNext() {
        return this.getNext(true);
    }

    public EditPart getNext(boolean stepIntoChildNode) {
        if (this.getParent() instanceof PaletteTreeNodeEditPart) {
            if (stepIntoChildNode && this.isExpanded() && this.children != null && this.children.size() > 0) {
                PaletteTreeNodeEditPart firstChild = (PaletteTreeNodeEditPart)this.children.get(0);
                return firstChild;
            }
            PaletteTreeNodeEditPart parent = (PaletteTreeNodeEditPart)this.getParent();
            PaletteTreeNodeEditPart next = parent.getNextFor(this);
            if (next != null) {
                return next;
            }
            return parent.getNext(false);
        }
        if (this.children.size() > 0) {
            PaletteTreeNodeEditPart firstChild = (PaletteTreeNodeEditPart)this.children.get(0);
            return firstChild;
        }
        List c = this.getParent().getChildren();
        int i = 0;
        while (i < c.size()) {
            EditPart item = (EditPart)c.get(i);
            if (item == this && i != c.size() - 1) {
                return (EditPart)c.get(i + 1);
            }
            ++i;
        }
        return this.getParent();
    }

    public PaletteTreeNodeEditPart getNextFor(PaletteTreeNodeEditPart part) {
        List childs = this.children;
        int i = 0;
        while (i < childs.size()) {
            PaletteTreeNodeEditPart item = (PaletteTreeNodeEditPart)childs.get(i);
            if (item == part && i != childs.size() - 1) {
                return (PaletteTreeNodeEditPart)childs.get(i + 1);
            }
            ++i;
        }
        return null;
    }

    public EditPart getPrevious() {
        if (this.getParent() instanceof PaletteTreeNodeEditPart) {
            PaletteTreeRootEditPart root;
            PaletteTree tree;
            PaletteTreeNodeEditPart parent = (PaletteTreeNodeEditPart)this.getParent();
            PaletteTreeNodeEditPart prev = parent.getPreviousFor(this);
            if (prev != null) {
                if (prev.isExpanded() && prev.getChildren().size() > 0) {
                    return (PaletteTreeNodeEditPart)prev.getChildren().get(prev.getChildren().size() - 1);
                }
                return prev;
            }
            if (parent instanceof PaletteTreeRootEditPart && (tree = (PaletteTree)((Object)(root = (PaletteTreeRootEditPart)parent).getModel())).isHideRootNode()) {
                return this;
            }
            return parent;
        }
        List childs = this.getParent().getChildren();
        int i = 0;
        while (i < childs.size()) {
            EditPart item = (EditPart)childs.get(i);
            if (item == this && i != 0) {
                return (EditPart)childs.get(i - 1);
            }
            ++i;
        }
        return null;
    }

    private PaletteTreeNodeEditPart getPreviousFor(PaletteTreeNodeEditPart part) {
        List childs = this.children;
        int i = 0;
        while (i < childs.size()) {
            PaletteTreeNodeEditPart item = (PaletteTreeNodeEditPart)childs.get(i);
            if (item == part && i != 0) {
                return (PaletteTreeNodeEditPart)childs.get(i - 1);
            }
            ++i;
        }
        return null;
    }

    public IFigure getContentPane() {
        return this.contentFigure.getInnerContentArea();
    }

    public Color computeLabelColor() {
        Color color = ColorConstants.black;
        if (this.isSelected) {
            color = ColorConstants.black;
        } else if (this.isReadOnly) {
            color = ColorConstants.gray;
        }
        return color;
    }

    public void refreshVisuals() {
        ModelAdapter adapter = this.getModelAdapter();
        if (adapter != null) {
            this.isReadOnly = Boolean.TRUE.equals(adapter.getProperty(this.getModel(), "READONLY_PROPERTY"));
            this._label.setForegroundColor(this.computeLabelColor());
            String strLabel = (String)adapter.getProperty(this.getModel(), "LABEL_PROPERTY");
            this._label.setText(strLabel);
            this._label.setIcon((Image)adapter.getProperty(this.getModel(), "IMAGE_PROPERTY"));
            this._label.setToolTip(this.getToolTipFigure());
        } else {
            this._label.setText(this.getModel().getClass().getName());
        }
    }

    protected IFigure getToolTipFigure() {
        return this.createToolTip();
    }

    protected IFigure createToolTip() {
        String message = this.getToolTipText();
        if (message == null || message.length() == 0) {
            return null;
        }
        FlowPage fp = new FlowPage(){

            public Dimension getPreferredSize(int w, int h) {
                Dimension d = super.getPreferredSize(-1, -1);
                if (d.width > 500) {
                    d = super.getPreferredSize(500, -1);
                }
                return d;
            }
        };
        fp.setOpaque(true);
        fp.setBorder(TOOLTIP_BORDER);
        TextFlow tf = new TextFlow();
        tf.setText(message);
        fp.add((IFigure)tf);
        return fp;
    }

    /*
     * Unable to fully structure code
     */
    private void _refreshChildren() {
        modelToEditPart = new HashMap<Object, EditPart>();
        childs = this.getChildren();
        i = 0;
        while (i < childs.size()) {
            editPart = (EditPart)childs.get(i);
            modelToEditPart.put(editPart.getModel(), editPart);
            ++i;
        }
        modelObjects = this.getModelChildren();
        i = 0;
        while (i < modelObjects.size()) {
            block10: {
                block9: {
                    model = modelObjects.get(i);
                    if (i >= childs.size()) break block9;
                    editPart = (EditPart)childs.get(i);
                    editPartModel = editPart.getModel();
                    if (editPartModel == model) break block10;
                    if (editPartModel.getClass() == model.getClass()) {
                        modelToEditPart.remove(editPartModel);
                        if (this.isActive()) {
                            editPart.deactivate();
                        }
                        editPart.setModel(model);
                        if (this.isActive()) {
                            editPart.activate();
                            editPart.refresh();
                            ** GOTO lbl36
                        } else {
                            ** GOTO lbl29
                        }
                    }
                    break block9;
lbl29:
                    // 2 sources

                    break block10;
                }
                if ((editPart = (EditPart)modelToEditPart.get(model)) != null) {
                    this.reorderChild(editPart, i);
                } else {
                    editPart = this.createChild(model);
                    this.addChild(editPart, i);
                }
            }
            ++i;
        }
        trash = new ArrayList<E>();
        while (i < childs.size()) {
            trash.add(childs.get(i));
            ++i;
        }
        i = 0;
        while (i < trash.size()) {
            ep = (EditPart)trash.get(i);
            this.removeChild(ep);
            ep.setParent((EditPart)this);
            ++i;
        }
    }

    public void refreshChildren() {
        boolean reuseChildren = true;
        if (reuseChildren) {
            this._refreshChildren();
        } else {
            super.refreshChildren();
        }
        this.contentFigure.getInteractor().setVisible(this.hasChildren());
    }

    public List<?> getModelChildren() {
        return this.contentFigure.getInteractor().isExpanded() ? this.getModelChildrenHelper() : Collections.EMPTY_LIST;
    }

    protected List<?> getModelChildrenHelper() {
        List result = null;
        ModelAdapter adapter = this.getModelAdapter();
        if (adapter != null) {
            result = (List)adapter.getProperty(this.getModel(), "CHILDREN_PROPERTY");
        }
        return result != null ? result : Collections.EMPTY_LIST;
    }

    protected boolean hasChildren() {
        return this.getModelChildrenHelper().size() > 0;
    }

    public ModelAdapter getModelAdapter() {
        return this.modelAdapter;
    }

    public void setModelAdapter(ModelAdapter modelAdapter) {
        this.modelAdapter = modelAdapter;
    }

    protected void addModelAdapterListener(Object modelObject, ModelAdapterListener listener) {
        ModelAdapter adapter = this.getModelAdapter();
        if (adapter != null) {
            adapter.addListener(listener);
        }
    }

    protected void removeModelAdapterListener(Object modelObject, ModelAdapterListener listener) {
        ModelAdapter adapter = this.getModelAdapter();
        if (adapter != null) {
            adapter.removeListener(listener);
        }
    }

    public void addFeedback() {
        this.labelHolder.setSelected(true);
        this.isSelected = true;
        this._label.setForegroundColor(this.computeLabelColor());
        this.getPaletteViewer().setActiveTool(null);
    }

    public void removeFeedback() {
        this.isSelected = false;
        this.labelHolder.setSelected(this.isSelected);
        this._label.setForegroundColor(this.computeLabelColor());
    }

    public boolean isExpanded() {
        return this.contentFigure.getInteractor().isExpanded();
    }

    public void setExpanded(boolean expanded) {
        this.interactorHelper.setExpanded(expanded);
    }

    public void setSelected(int value) {
        super.setSelected(value);
        if (value == 2) {
            this.addFeedback();
        } else {
            this.removeFeedback();
        }
    }

    protected String getToolTipText() {
        ModelAdapter adapter = this.getModelAdapter();
        String toolTip = (String)adapter.getProperty(this.getModel(), "TOOLTIP_PROPERTY");
        return toolTip;
    }

    public String toString() {
        if (this._label != null) {
            return "PaletteTreeNodeEditPart: " + this._label.getText();
        }
        return super.toString();
    }
}

