/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal.editparts;

import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteViewer;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteDrawer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.Toggle;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerFigure;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.UIJob;

public class MaximizableDrawerEditPart
extends DrawerEditPart {
    private static final Image MAX_IMAGE = Activator.Images.PALETTE_MAXIMIZE_ICON.getImage();
    private static final Image RESTORE_IMAGE = Activator.Images.PALETTE_RESTORE_ICON.getImage();
    private final MaximizeJob _maximizeJob = new MaximizeJob();
    private Toggle maximizeToggle;
    private final Label toolTipFig = new Label();
    private boolean _isMaximized;

    public MaximizableDrawerEditPart(DesignPaletteDrawer drawer) {
        super((PaletteDrawer)drawer);
    }

    public IFigure createFigure() {
        DrawerFigure fig = (DrawerFigure)super.createFigure();
        this.addMaximizeToggle(fig);
        final ButtonModel maxToggleModel = this.maximizeToggle.getModel();
        fig.getCollapseToggle().addMouseListener(new MouseListener(){

            public void mouseDoubleClicked(MouseEvent me) {
                maxToggleModel.setSelected(!MaximizableDrawerEditPart.this.isMaximized());
            }

            public void mousePressed(MouseEvent me) {
            }

            public void mouseReleased(MouseEvent me) {
            }
        });
        return fig;
    }

    private void addMaximizeToggle(DrawerFigure fig) {
        IFigure titleFig = this.getTitleFig(fig);
        IFigure labelFig = this.getLabelFigure(titleFig);
        this.maximizeToggle = new Toggle((IFigure)new ImageFigure(this.isMaximized() ? RESTORE_IMAGE : MAX_IMAGE));
        this.toolTipFig.setText(Messages.MaximizableDrawerEditPart_MaximizeToolTip);
        labelFig.setLayoutManager((LayoutManager)new BorderLayout());
        labelFig.add((IFigure)this.maximizeToggle, (Object)BorderLayout.RIGHT);
        this.maximizeToggle.getModel().addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent event) {
                if (event.getPropertyName().equals("selected")) {
                    if (MaximizableDrawerEditPart.this.isMaximized()) {
                        ((ImageFigure)MaximizableDrawerEditPart.this.maximizeToggle.getChildren().get(0)).setImage(MAX_IMAGE);
                        MaximizableDrawerEditPart.this._maximizeJob.go(false);
                        MaximizableDrawerEditPart.this.toolTipFig.setText(Messages.MaximizableDrawerEditPart_MaximizeToolTip);
                    } else {
                        ((ImageFigure)MaximizableDrawerEditPart.this.maximizeToggle.getChildren().get(0)).setImage(RESTORE_IMAGE);
                        MaximizableDrawerEditPart.this._maximizeJob.go(true);
                        MaximizableDrawerEditPart.this.toolTipFig.setText(Messages.MaximizableDrawerEditPart_RestoreToolTip);
                    }
                }
            }
        });
    }

    private IFigure getTitleFig(DrawerFigure fig) {
        Toggle collapseToggle = this.getCollapseToggle(fig);
        return (IFigure)collapseToggle.getChildren().get(0);
    }

    private Toggle getCollapseToggle(DrawerFigure fig) {
        return (Toggle)fig.getChildren().get(0);
    }

    private IFigure getLabelFigure(IFigure titleFig) {
        for (Object o : titleFig.getChildren()) {
            IFigure fig = (IFigure)o;
            if (!(o instanceof Label)) continue;
            return fig;
        }
        return null;
    }

    public void setMaximized(boolean maximize) {
        this.setMaximized(maximize, false);
    }

    private void setMaximized(boolean maximize, boolean force) {
        ButtonModel maxToggleModel = this.maximizeToggle.getModel();
        maxToggleModel.setSelected(maximize);
    }

    private OEPEPaletteViewer getOEPEPaletteViewer() {
        return (OEPEPaletteViewer)this.getPaletteViewer();
    }

    public boolean isMaximized() {
        return this._isMaximized;
    }

    private class MaximizeJob
    extends UIJob {
        private boolean _maximize;

        public MaximizeJob() {
            super(Messages.MaximizableDrawerEditPart_job_desc);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!MaximizableDrawerEditPart.this.isActive()) {
                return Status.OK_STATUS;
            }
            if (this._maximize) {
                MaximizableDrawerEditPart.this.getOEPEPaletteViewer().maximizeState(MaximizableDrawerEditPart.this);
            } else {
                MaximizableDrawerEditPart.this.getOEPEPaletteViewer().resetToMinimizeState();
            }
            MaximizableDrawerEditPart.this._isMaximized = this._maximize;
            MaximizableDrawerEditPart.this.setExpanded(true);
            return Status.OK_STATUS;
        }

        public void go(boolean maximize) {
            this._maximize = maximize;
            this.setSystem(true);
            this.schedule();
        }
    }
}

