/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.palette.internal;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.palette.internal.IPaletteFilterListener;
import oracle.eclipse.tools.webtier.ui.palette.internal.OEPEPaletteViewer;
import oracle.eclipse.tools.webtier.ui.palette.internal.PaletteViewerState;
import oracle.eclipse.tools.webtier.ui.palette.internal.editparts.PaletteTreeNodeEditPart;
import oracle.eclipse.tools.webtier.ui.palette.internal.editparts.PaletteTreeRootEditPart;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteDrawer;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteEntry;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteTree;
import oracle.eclipse.tools.webtier.ui.palette.model.TreeModelAdapter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.progress.UIJob;

public class PaletteFilter
extends Composite {
    static final String DEFAULT_FILTER_TEXT = Messages.FilterPalette_default_text;
    static final String EMPTY_STRING = "";
    public static final int STOP_RECURSING = 4;
    private Text _filterText;
    private ToolBar _clearFilterButton;
    private String _filterString = "";
    private int _currentCollapsePref;
    private List<DesignPaletteDrawer> _filterableCategories = Collections.emptyList();
    private PaletteViewerState _preFilteredState;
    private boolean _ignoreModify;
    private boolean _isRunning;
    private final UIJob paletteFilterJob = new PaletteFilterJob(Messages.PaletteFilter_filter_items);
    private final UIJob resetPaletteFilterJob = new ResetPaletteFilterJob(Messages.PaletteFilter_reset_filter_items);
    private IAction _clearFilterAction;
    private OEPEPaletteViewer _paletteViewer;
    private List<IPaletteFilterListener> _listeners = new CopyOnWriteArrayList<IPaletteFilterListener>();
    private final Color enabledTextColor = this.getDisplay().getSystemColor(21);
    private final Color disabledTextColor = this.getDisplay().getSystemColor(16);
    private static long JOB_FILTER_DELAY = 500L;
    private static long JOB_RESET_DELAY = 0L;

    public PaletteFilter(Composite parent, int style) {
        super(parent, style);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginBottom = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginRight = 10;
        this.setLayout((Layout)gl);
        this.setLayoutData(new GridData(4, 128, true, false));
        this.createFilter(this);
        this.createClearFilterButton(this);
    }

    public void setViewer(OEPEPaletteViewer viewer) {
        this._paletteViewer = viewer;
        this.init();
    }

    private void init() {
        this.saveCurrentAutoCollapseSetting();
        this._preFilteredState = PaletteViewerState.newInstance(this._paletteViewer);
        this.resetFilterText();
        this._filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PaletteFilter.this._ignoreModify) {
                    return;
                }
                if (!PaletteFilter.this._isRunning) {
                    PaletteFilter.this.paletteFilterJob.cancel();
                    if (!PaletteFilter.this.noFilter()) {
                        PaletteFilter.this.paletteFilterJob.schedule(JOB_FILTER_DELAY);
                    } else {
                        PaletteFilter.this._paletteViewer.resetToMinimizeState();
                        PaletteFilter.this.resetPaletteFilterJob.schedule(JOB_RESET_DELAY);
                    }
                }
            }
        });
        this._filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    PaletteFilter.this.doFilter();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this._filterText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                PaletteFilter.this._filterText.setForeground(PaletteFilter.this.enabledTextColor);
                if (PaletteFilter.this._filterString.equals(PaletteFilter.EMPTY_STRING)) {
                    try {
                        PaletteFilter.this._ignoreModify = true;
                        PaletteFilter.this._filterText.setText(PaletteFilter.EMPTY_STRING);
                    }
                    finally {
                        PaletteFilter.this._ignoreModify = false;
                    }
                } else {
                    PaletteFilter.this._filterText.selectAll();
                }
            }

            public void focusLost(FocusEvent e) {
                if (PaletteFilter.this._filterString.equals(PaletteFilter.EMPTY_STRING)) {
                    try {
                        PaletteFilter.this._ignoreModify = true;
                        PaletteFilter.this.resetFilterText();
                        PaletteFilter.this._filterText.setForeground(PaletteFilter.this.disabledTextColor);
                    }
                    finally {
                        PaletteFilter.this._ignoreModify = false;
                    }
                } else {
                    PaletteFilter.this._filterText.setForeground(PaletteFilter.this.enabledTextColor);
                }
            }
        });
        this._filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PaletteFilter.this._clearFilterButton.setVisible(!PaletteFilter.this.noFilter());
            }
        });
    }

    public void resetFilterText() {
        if (!this._filterText.isDisposed()) {
            this._filterText.setText(DEFAULT_FILTER_TEXT);
            this._filterText.selectAll();
            this._filterString = EMPTY_STRING;
        }
    }

    private void createFilter(Composite filterArea) {
        this._filterText = new Text(filterArea, 2052);
        this._filterText.setToolTipText(Messages.PaletteFilter_Tooltip);
        this._filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._filterText.setForeground(this.disabledTextColor);
    }

    private void createClearFilterButton(Composite filterArea) {
        ToolBarManager filterToolBarMgr = new ToolBarManager(0x800100);
        this._clearFilterAction = new Action(EMPTY_STRING, 1){

            public void run() {
                PaletteFilter.this.fireFilterAboutToBeCleared();
                PaletteFilter.this.paletteFilterJob.cancel();
                PaletteFilter.this.resetPaletteFilterJob.schedule(JOB_RESET_DELAY);
            }
        };
        this._clearFilterAction.setToolTipText(Messages.PaletteFilter_ClearFilterTooltip);
        this._clearFilterAction.setImageDescriptor(Activator.Images.CLEAR_FILTER_ICON.getImageDescriptor());
        filterToolBarMgr.add(this._clearFilterAction);
        this._clearFilterButton = filterToolBarMgr.createControl(filterArea);
        this._clearFilterButton.setLayoutData((Object)new GridData(131072));
        this._clearFilterButton.setVisible(false);
    }

    private void resetFilter() {
        if (!this._filterText.isDisposed()) {
            try {
                this._ignoreModify = true;
                this.resetDrawerState();
                this.resetFilterText();
                this.resetPaletteTreeFilters();
                this._filterableCategories.clear();
            }
            finally {
                this._ignoreModify = false;
            }
        }
    }

    private void resetPaletteTreeFilters() {
        for (DesignPaletteDrawer drawer : this._filterableCategories) {
            for (Object object : drawer.getChildren()) {
                DesignPaletteEntry entry;
                if (!(object instanceof DesignPaletteEntry) || !((entry = (DesignPaletteEntry)object).getPaletteItem() instanceof PaletteTree)) continue;
                PaletteTree paletteTree = (PaletteTree)entry.getPaletteItem();
                paletteTree.getModelAdapter().setPaletteTreeFilterText(EMPTY_STRING);
                paletteTree.getPaletteContributor().refresh();
            }
        }
    }

    private boolean noFilter() {
        return this._filterText.getText().equals(DEFAULT_FILTER_TEXT) || this._filterText.getText().trim().equals(EMPTY_STRING);
    }

    private void fireFilterAboutToHappen() {
        for (IPaletteFilterListener listener : this._listeners) {
            listener.filterAboutToBeApplied();
        }
    }

    private void fireFilterAboutToBeCleared() {
        for (IPaletteFilterListener listener : this._listeners) {
            listener.filterAboutToBeCleared();
        }
    }

    public void addPaletteFilterListener(IPaletteFilterListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void removePaletteFilterListener(IPaletteFilterListener listener) {
        if (this._listeners.contains(listener)) {
            this._listeners.remove(listener);
        }
    }

    private IStatus doFilter() {
        if (!this._filterText.isDisposed()) {
            this._filterString = this._filterText.getText();
            if (this.noFilter()) {
                new UIJob("clear filter"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        PaletteFilter.this._clearFilterAction.run();
                        return Status.OK_STATUS;
                    }
                }.schedule(JOB_RESET_DELAY);
                return Status.OK_STATUS;
            }
            this.filterPaletteEntries();
        }
        return Status.OK_STATUS;
    }

    private void resetDrawerState() {
        this.restoreAutoCollapseSetting();
        this._preFilteredState.restoreState();
    }

    private void filterPaletteEntries() {
        if (this._paletteViewer == null || this._paletteViewer.getControl() == null || this._paletteViewer.getControl().isDisposed()) {
            return;
        }
        try {
            this._paletteViewer.getControl().setVisible(false);
            for (DesignPaletteDrawer drawer : this._filterableCategories) {
                if (this.isPaletteTreeDrawer(drawer)) {
                    this.filterPaletteTreeDrawer(drawer);
                    continue;
                }
                this.filterPaletteDrawer(drawer);
            }
        }
        finally {
            this._paletteViewer.getControl().setVisible(true);
        }
    }

    private void filterPaletteTreeDrawer(final DesignPaletteDrawer drawer) {
        List paletteItems = drawer.getChildren();
        if (paletteItems.size() == 0) {
            LoggingService.logWarning((String)"oracle.eclipse.tools.webtier.ui", (String)(drawer + " doesn't have a palette item"));
            return;
        }
        if (paletteItems.size() > 1) {
            LoggingService.logWarning((String)"oracle.eclipse.tools.webtier.ui", (String)(drawer + " has more than one PatteTree"));
        }
        PaletteTree paletteTree = (PaletteTree)((DesignPaletteEntry)paletteItems.get(0)).getPaletteItem();
        paletteTree.getModelAdapter().setPaletteTreeFilterText(this._filterString);
        TreeModelAdapter treeModelAdapter = paletteTree.getModelAdapter();
        List entries = (List)treeModelAdapter.getProperty((Object)paletteTree, "CHILDREN_PROPERTY");
        if (entries.size() == 0) {
            if (drawer.isVisible()) {
                drawer.setVisible(false);
            }
            return;
        }
        if (!drawer.isVisible()) {
            drawer.setVisible(true);
        }
        paletteTree.getPaletteContributor().refresh();
        DrawerEditPart drawerEditPart = (DrawerEditPart)this._paletteViewer.getEditPartRegistry().get(drawer);
        if (drawerEditPart != null && drawerEditPart.isActive() && !drawerEditPart.isExpanded()) {
            drawerEditPart.setExpanded(true);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PaletteFilter.this.expand(drawer);
            }
        });
    }

    private void filterPaletteDrawer(DesignPaletteDrawer drawer) {
        List paletteItems = drawer.getChildren();
        boolean foundEntry = false;
        int j = 0;
        while (j < paletteItems.size()) {
            DesignPaletteEntry item = (DesignPaletteEntry)paletteItems.get(j);
            if (item != null) {
                if (item.getPaletteItem() instanceof PaletteTree) {
                    foundEntry = true;
                } else if (item.getLabel() != null && item.getLabel().toLowerCase().indexOf(this._filterString.toLowerCase()) < 0) {
                    if (item.getTagName() != null && item.getTagName().toLowerCase().indexOf(this._filterString.toLowerCase()) < 0) {
                        item.setVisible(false);
                    } else {
                        foundEntry = true;
                        item.setVisible(true);
                    }
                } else {
                    foundEntry = true;
                    item.setVisible(true);
                }
            }
            ++j;
        }
        if (!foundEntry) {
            if (drawer.isVisible()) {
                drawer.setVisible(false);
            }
        } else {
            DrawerEditPart drawerEditPart;
            if (!drawer.isVisible()) {
                drawer.setVisible(true);
            }
            if ((drawerEditPart = (DrawerEditPart)this._paletteViewer.getEditPartRegistry().get(drawer)) != null && drawerEditPart.isActive() && !drawerEditPart.isExpanded()) {
                drawerEditPart.setExpanded(true);
            }
        }
    }

    private boolean isPaletteTreeDrawer(DesignPaletteDrawer drawer) {
        return this.getPaletteTree(drawer) != null;
    }

    private PaletteTree getPaletteTree(DesignPaletteDrawer drawer) {
        DesignPaletteEntry entry;
        Object child;
        List children = drawer.getChildren();
        if (children.size() > 0 && (child = children.get(0)) instanceof DesignPaletteEntry && (entry = (DesignPaletteEntry)child).getPaletteItem() instanceof PaletteTree) {
            return (PaletteTree)entry.getPaletteItem();
        }
        return null;
    }

    private void expand(DesignPaletteDrawer drawer) {
        AbstractEditPart aep;
        PaletteTree paletteTree = this.getPaletteTree(drawer);
        if (paletteTree != null && (aep = (AbstractEditPart)this._paletteViewer.getEditPartRegistry().get((Object)paletteTree)) instanceof PaletteTreeRootEditPart) {
            PaletteTreeRootEditPart root = (PaletteTreeRootEditPart)aep;
            this.expand(root.getChildren(), 0);
        }
    }

    private void expand(List<PaletteTreeNodeEditPart> children, int level) {
        if (level > 4) {
            return;
        }
        for (PaletteTreeNodeEditPart node : children) {
            if (node.isActive() && !node.isExpanded()) {
                node.setExpanded(true);
            }
            this.expand(node.getChildren(), level + 1);
        }
    }

    private void saveCurrentAutoCollapseSetting() {
        if (this._paletteViewer != null) {
            this._currentCollapsePref = this._paletteViewer.getPaletteViewerPreferences().getAutoCollapseSetting();
        }
    }

    void restoreAutoCollapseSetting() {
        if (this._paletteViewer != null) {
            this._paletteViewer.getPaletteViewerPreferences().setAutoCollapseSetting(this._currentCollapsePref);
        }
    }

    public void dispose() {
        this.resetPaletteFilterJob.cancel();
        this.paletteFilterJob.cancel();
        if (this._filterableCategories != null) {
            this._filterableCategories.clear();
            this._filterableCategories = null;
        }
        if (this._listeners != null) {
            this._listeners.clear();
            this._listeners = null;
        }
        this._paletteViewer = null;
        super.dispose();
    }

    public boolean isInFiltrationMode() {
        return this._filterString != EMPTY_STRING;
    }

    public void reapplyFilter() {
        this.paletteFilterJob.cancel();
        this.paletteFilterJob.schedule();
    }

    private class PaletteFilterJob
    extends UIJob {
        public PaletteFilterJob(String name) {
            super(name);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                PaletteFilter.this._isRunning = true;
                PaletteFilter.this.fireFilterAboutToHappen();
                if (PaletteFilter.this._filterString.equals(PaletteFilter.EMPTY_STRING)) {
                    this.cacheState();
                }
                PaletteFilter.this._paletteViewer.getPaletteViewerPreferences().setAutoCollapseSetting(1);
                IStatus iStatus = PaletteFilter.this.doFilter();
                return iStatus;
            }
            finally {
                PaletteFilter.this._isRunning = false;
            }
        }

        private void cacheState() {
            PaletteFilter.this._preFilteredState.cacheState("PreFilteredState");
            PaletteFilter.this._filterableCategories = PaletteFilter.this._preFilteredState.getVisibleCategories();
        }
    }

    private class ResetPaletteFilterJob
    extends UIJob {
        public ResetPaletteFilterJob(String name) {
            super(name);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                PaletteFilter.this._isRunning = true;
                PaletteFilter.this.resetFilter();
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                PaletteFilter.this._isRunning = false;
            }
        }
    }
}

